/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.DumpComponent;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public interface DumpPanelDecorator {
    public JComponent decorate(@NotNull JComponent var1, @NotNull List<DumpComponent> var2);

    public static class DefaultDumpPanelDecorator
    implements DumpPanelDecorator {
        private static final String EXEC_PATH = "Path to %s: ";
        private static final int WIDTH = 2;
        private final String myName;

        public DefaultDumpPanelDecorator(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "<init>"));
            }
            this.myName = name;
        }

        @Override
        public JComponent decorate(@NotNull JComponent pathComponent, @NotNull List<DumpComponent> components) {
            if (pathComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponent", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "decorate"));
            }
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "decorate"));
            }
            JPanel panel = new JPanel(new GridBagLayout());
            JBLabel pathLabel = new JBLabel(String.format(EXEC_PATH, this.myName));
            GridBagConstraints gbc = DefaultDumpPanelDecorator.createConstraints();
            DefaultDumpPanelDecorator.add(panel, (JComponent)pathLabel, gbc);
            DefaultDumpPanelDecorator.span(gbc);
            DefaultDumpPanelDecorator.add(panel, pathComponent, gbc);
            for (DumpComponent component : components) {
                DefaultDumpPanelDecorator.addComponent(panel, component, gbc);
            }
            return panel;
        }

        private static GridBagConstraints createConstraints() {
            GridBagConstraints gbc = new GridBagConstraints();
            DefaultDumpPanelDecorator.reset(gbc);
            return gbc;
        }

        private static void reset(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "reset"));
            }
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            DefaultDumpPanelDecorator.noSpan(gbc);
        }

        private static void addComponent(@NotNull JPanel panel, @NotNull DumpComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addComponent"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addComponent"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addComponent"));
            }
            if (component.getLabel() == null) {
                DefaultDumpPanelDecorator.addSimple(panel, component, gbc);
                return;
            }
            DefaultDumpPanelDecorator.addLabeled(panel, component, gbc);
        }

        private static void addSimple(@NotNull JPanel panel, @NotNull DumpComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addSimple"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addSimple"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addSimple"));
            }
            DefaultDumpPanelDecorator.noSpan(gbc);
            DefaultDumpPanelDecorator.add(panel, component.getComponent(), gbc);
        }

        private static void addLabeled(@NotNull JPanel panel, @NotNull DumpComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addLabeled"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addLabeled"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "addLabeled"));
            }
            DefaultDumpPanelDecorator.noSpan(gbc);
            DefaultDumpPanelDecorator.nextLine(gbc);
            DefaultDumpPanelDecorator.add(panel, (JComponent)new JBLabel(component.getLabel() + ": "), gbc);
            DefaultDumpPanelDecorator.span(gbc);
            DefaultDumpPanelDecorator.add(panel, component.getComponent(), gbc);
        }

        private static void nextLine(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "nextLine"));
            }
            gbc.gridx = 0;
            ++gbc.gridy;
        }

        private static void noSpan(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "noSpan"));
            }
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
        }

        private static void span(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "span"));
            }
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
        }

        private static void nextCell(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "nextCell"));
            }
            if (gbc.gridx == 1) {
                gbc.gridx = 0;
                ++gbc.gridy;
                return;
            }
            ++gbc.gridx;
        }

        private static void add(@NotNull JPanel panel, @NotNull JComponent component, @NotNull GridBagConstraints gbc) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "add"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "add"));
            }
            if (gbc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gbc", "com/intellij/database/dump/dbdump/DumpPanelDecorator$DefaultDumpPanelDecorator", "add"));
            }
            panel.add((Component)component, gbc);
            DefaultDumpPanelDecorator.nextCell(gbc);
        }
    }
}

