/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpCredentialsManager;
import com.intellij.database.dump.dbdump.DumpSettings;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpManager
implements Disposable {
    private static final int TIMEOUT_MS = 300;
    private static final int MAX_TIME_MS = 86400000;
    private static final int MAX_OUTPUT_CHARS = 10000;
    private static final String TEXT = "Dumping Data with \"%s\"";
    private static final String MAX_TIME_ERROR = "%s: Max execution time is reached";
    private static final String OUT_ERROR = "%s: Maximum number of characters is reached";
    private static final String COMPLETED = "Dump is completed (%s)";
    private static final String FILE_LINK = "<a href=\"\">%s</a>";
    private final DbDataSource myDataSource;
    private final DumpConfiguration myConfiguration;
    private final Project myProject;
    private final DumpSettings mySettings;
    private volatile int myChars;

    public DumpManager(@NotNull DbDataSource source, @NotNull Collection<DbElement> elements, @NotNull Project project, @NotNull DumpConfiguration configuration) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpManager", "<init>"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpManager", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/dbdump/DumpManager", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DumpManager", "<init>"));
        }
        this.myDataSource = source;
        this.myProject = project;
        this.myConfiguration = configuration;
        this.mySettings = new DumpSettings(project, elements, this.myConfiguration, this);
    }

    @NotNull
    public JComponent getView() {
        JComponent jComponent = this.mySettings.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpManager", "getView"));
        }
        return jComponent;
    }

    @NotNull
    public DumpSettings getSettings() {
        DumpSettings dumpSettings = this.mySettings;
        if (dumpSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpManager", "getSettings"));
        }
        return dumpSettings;
    }

    public void dispose() {
    }

    public void dump() {
        this.runInBackground();
        this.mySettings.store();
    }

    private void runInBackground() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Dumping Data..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dump/dbdump/DumpManager$1", "run"));
                }
                try (DumpCredentialsManager manager = new DumpCredentialsManager((LocalDataSource)DumpManager.this.myDataSource.getDelegate(), DumpManager.this.myConfiguration, DumpManager.this.myProject, DumpManager.this.mySettings);){
                    indicator.setText(String.format(DumpManager.TEXT, DumpManager.this.myConfiguration.getName()));
                    indicator.setText2(DumpManager.this.myDataSource.getName());
                    indicator.checkCanceled();
                    Pair<String, String> commandAndPassword = manager.getCommandAndPassword();
                    String command = (String)commandAndPassword.getFirst();
                    String password = (String)commandAndPassword.getSecond();
                    GeneralCommandLine line = DumpManager.this.getCommandLine(command, DumpManager.this.myConfiguration.getEnvironmentVariableName(), password);
                    OSProcessHandler handler = new OSProcessHandler(line);
                    int millis = 0;
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(ProcessEvent event, Key outputType) {
                            String text = event.getText();
                            if (StringUtil.isEmptyOrSpaces((String)text) || DumpManager.this.myChars > 10000) {
                                return;
                            }
                            DumpManager.this.myChars = DumpManager.this.myChars + text.length();
                            if (DumpManager.this.myChars > 10000) {
                                String error = String.format(DumpManager.OUT_ERROR, DumpManager.this.myConfiguration.getName());
                                DumpManager.this.notification(NotificationType.ERROR, error);
                                return;
                            }
                            NotificationType type = DumpManager.getType(outputType);
                            DumpManager.this.notification(type, text);
                        }
                    });
                    handler.startNotify();
                    while (!handler.waitFor(300L)) {
                        DumpManager.this.checkMaxTimeNotReached(handler, millis);
                        if (indicator.isCanceled()) {
                            handler.destroyProcess();
                        }
                        indicator.checkCanceled();
                        millis += 300;
                    }
                    DumpManager.this.notifyEnd(command);
                }
                catch (ExecutionException | IOException e) {
                    DumpManager.this.notification(NotificationType.ERROR, e.getMessage());
                }
            }
        });
    }

    private void notification(@NotNull NotificationType type, @NotNull String text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dump/dbdump/DumpManager", "notification"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DumpManager", "notification"));
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(text, type).notify(this.myProject);
    }

    private void notifyEnd(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpManager", "notifyEnd"));
        }
        String arg = DbDumpUtil.getArgumentValue(command, this.myConfiguration, this.mySettings.getParameterizable(), this.myConfiguration.getFileArgs());
        if (StringUtil.isEmpty((String)arg)) {
            return;
        }
        String path = DbDumpUtil.clearString(arg, StringUtil::unquoteString);
        File file = new File(path);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile == null || !file.exists()) {
            return;
        }
        MyNotificationListener listener = new MyNotificationListener(this.myProject, path);
        String link = String.format(FILE_LINK, path);
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(String.format(COMPLETED, this.myDataSource.getName()), link, NotificationType.INFORMATION, (NotificationListener)listener).notify(this.myProject);
    }

    private void checkMaxTimeNotReached(@NotNull OSProcessHandler handler, int millis) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dump/dbdump/DumpManager", "checkMaxTimeNotReached"));
        }
        if (millis < 86400000) {
            return;
        }
        handler.destroyProcess();
        String notification = String.format(MAX_TIME_ERROR, this.myConfiguration.getName());
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(notification, NotificationType.ERROR).notify(this.myProject);
        throw new ProcessCanceledException();
    }

    @NotNull
    private GeneralCommandLine getCommandLine(@NotNull String command, @NotNull String env, @Nullable String password) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpManager", "getCommandLine"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/database/dump/dbdump/DumpManager", "getCommandLine"));
        }
        List<String> args = DbDumpUtil.getCommandLineArguments(this.myConfiguration, command, this.mySettings.getParameterizable());
        GeneralCommandLine line = new GeneralCommandLine(args);
        GeneralCommandLine generalCommandLine = password == null ? line : line.withEnvironment(env, password);
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpManager", "getCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static NotificationType getType(Key outputType) {
        NotificationType notificationType = outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.SYSTEM ? NotificationType.INFORMATION : NotificationType.ERROR;
        if (notificationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpManager", "getType"));
        }
        return notificationType;
    }

    private static class MyNotificationListener
    implements NotificationListener {
        private final String myPathToFile;
        private final Project myProject;

        MyNotificationListener(@NotNull Project project, @NotNull String pathToFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/dbdump/DumpManager$MyNotificationListener", "<init>"));
            }
            if (pathToFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToFile", "com/intellij/database/dump/dbdump/DumpManager$MyNotificationListener", "<init>"));
            }
            this.myPathToFile = pathToFile;
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/dump/dbdump/DumpManager$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dump/dbdump/DumpManager$MyNotificationListener", "hyperlinkUpdate"));
            }
            File file = new File(this.myPathToFile);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile == null || !file.exists()) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Can't find file", NotificationType.WARNING).notify(this.myProject);
                return;
            }
            ShowFilePathAction.openFile((File)file);
        }
    }
}

