/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpDialogValidator;
import com.intellij.database.dump.dbdump.DumpManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpDialog
extends DialogWrapper {
    private static final String DIMENSION_KEY = "DUMP_DIALOG_DIMENSION_KEY";
    private static final String TITLE = "Dump Manager (%s)";
    private static final Dimension MIN_SIZE = JBUI.size((int)300, (int)100);
    private static final Dimension PREFERRED_SIZE = JBUI.size((int)600, (int)300);
    private final DumpManager myManager;
    private final DumpDialogValidator myValidator;

    public DumpDialog(@NotNull DbDataSource source, @NotNull Project project, @NotNull DumpManager manager, @NotNull DumpConfiguration configuration) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/dbdump/DumpDialog", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dump/dbdump/DumpDialog", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DumpDialog", "<init>"));
        }
        super(project);
        this.myManager = manager;
        this.myValidator = configuration.getValidator();
        Disposer.register((Disposable)this.myManager, (Disposable)this.myValidator);
        this.setTitle(String.format(TITLE, source.getName()));
        this.initValidation();
        this.init();
    }

    protected boolean shouldAddErrorNearButtons() {
        return !DumpDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myManager.getSettings().getPreferredFocusableComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myValidator.createInfo(this.myManager.getSettings());
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent view2 = this.myManager.getView();
        view2.setMinimumSize(MIN_SIZE);
        view2.setPreferredSize(PREFERRED_SIZE);
        return view2;
    }
}

