/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpSettings;
import com.intellij.database.dump.dbdump.LexemeIndicators;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpCredentialsManager
implements Closeable {
    private static final Logger LOG = Logger.getInstance(DumpCredentialsManager.class);
    private static final String MESSAGE = "Enter Username and Password";
    private final LocalDataSource myDataSource;
    private final DumpConfiguration myConfiguration;
    private final Project myProject;
    private final DumpSettings mySettings;
    private Session mySession;

    public DumpCredentialsManager(@NotNull LocalDataSource source, @NotNull DumpConfiguration configuration, @NotNull Project project, @NotNull DumpSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        this.myDataSource = source;
        this.myConfiguration = configuration;
        this.myProject = project;
        this.mySettings = settings;
    }

    @NotNull
    public Pair<String, String> getCommandAndPassword() {
        Pair<String, String> pair = this.getHostPort();
        if (pair == null) {
            DumpCredentialsManager.cancelDump();
        }
        String executable = StringUtil.trim((String)(this.mySettings.getPathToExecutable() + " " + this.mySettings.getCommand()));
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.rawLexemes(executable);
        ConnectionData host = this.getData(this.myConfiguration.getHostIndicators(), (String)pair.getFirst());
        ConnectionData port = this.getData(this.myConfiguration.getPortIndicators(), (String)pair.getSecond());
        DataSourceSslConfiguration cfg = this.myDataSource.getSslCfg();
        ConnectionData sslCa = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslCaIndicators(), cfg.myCaCertPath);
        ConnectionData sslCert = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslCertIndicators(), cfg.myClientCertPath);
        ConnectionData sslKey = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslKeyIndicators(), cfg.myClientKeyPath);
        DumpCredentials credentials = this.getCredentials(this.myDataSource, lexemes);
        ConnectionData username = credentials.getUsername();
        ConnectionData password = credentials.getPassword();
        if (username.isNeedToSetManually() && username.isEmpty()) {
            DumpCredentialsManager.cancelDump();
        }
        String sanitizedCommand = this.syncCredentials(executable, credentials);
        DumpConfiguration.Parameters parameters = new DumpConfiguration.Parameters(DumpCredentialsManager.getValue(username), DumpCredentialsManager.getValue(host), DumpCredentialsManager.getValue(port), DumpCredentialsManager.getValue(sslCa), DumpCredentialsManager.getValue(sslCert), DumpCredentialsManager.getValue(sslKey));
        String command = this.myConfiguration.getCommand(sanitizedCommand, parameters);
        Pair pair2 = Pair.create((Object)command, (Object)DumpCredentialsManager.getValue(password));
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandAndPassword"));
        }
        return pair2;
    }

    @Nullable
    private Pair<String, String> getHostPort() {
        try {
            DataSourceSshTunnelConfiguration configuration = this.myDataSource.getSshConfiguration();
            if (configuration != null && configuration.isEnabled()) {
                Pair tunnel;
                boolean inUnitTest = ApplicationManager.getApplication().isUnitTestMode();
                Pair pair = tunnel = inUnitTest ? Pair.create(null, (Object)Integer.parseInt(configuration.getProxyPort())) : configuration.createTunnel(this.myDataSource);
                if (tunnel != null) {
                    this.mySession = (Session)tunnel.getFirst();
                    return Pair.create((Object)"localhost", (Object)String.valueOf(tunnel.getSecond()));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Can't create SSH tunnel. Trying to connect with default host and port", (Throwable)e);
        }
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        RawConnectionConfig config = this.myDataSource.getConnectionConfig();
        if (driver == null || config == null) {
            DumpCredentialsManager.cancelDump();
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        String url = config.getUrl();
        return JdbcUrlParserUtil.extractHostPort(parsers, url, (Ref<JdbcUrlParser>)Ref.create());
    }

    @Override
    public void close() throws IOException {
        if (this.mySession == null) {
            return;
        }
        try {
            this.mySession.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    private static String getValue(@Nullable ConnectionData data) {
        return data == null || !data.isNeedToSetManually() || data.isEmpty() ? null : data.getValue();
    }

    @NotNull
    private DumpCredentials getCredentials(@NotNull LocalDataSource source, @NotNull List<DumpCommandLineLexeme> lexemes) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCredentials"));
        }
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCredentials"));
        }
        DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
        Credentials credentials = databaseCredentials.getCredentials((DatabaseSystem)source);
        String userName = credentials == null || StringUtil.isEmpty((String)credentials.getUserName()) ? "" : credentials.getUserName();
        String pass = credentials == null || StringUtil.isEmpty((String)credentials.getPasswordAsString()) ? "" : credentials.getPasswordAsString();
        ConnectionData username = this.getData(this.myConfiguration.getUsernameIndicators(), userName);
        ConnectionData password = this.getData(this.myConfiguration.getPasswordIndicators(), pass);
        boolean differentSources = password.isNeedToSetManually() != username.isNeedToSetManually();
        boolean manualOrAskPassword = password.isNeedToSetManually() || !this.myConfiguration.getPasswordIndicators().isNoAskingIndicator();
        boolean manualOrAskUsername = username.isNeedToSetManually() || !this.myConfiguration.getUsernameIndicators().isNoAskingIndicator();
        boolean manualEmpty = password.isNeedToSetManually() && password.isEmpty() || username.isNeedToSetManually() && username.isEmpty();
        boolean ask = differentSources && manualOrAskPassword && manualOrAskUsername || manualEmpty;
        DumpCredentials dumpCredentials = !ask || ApplicationManager.getApplication().isUnitTestMode() ? new DumpCredentials(username, password, false, false) : this.askCredentials(lexemes, databaseCredentials, source, username, password);
        if (dumpCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCredentials"));
        }
        return dumpCredentials;
    }

    @NotNull
    private String syncCredentials(@NotNull String command, @NotNull DumpCredentials credentials) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "syncCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "syncCredentials"));
        }
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String string = DumpCredentialsManager.getCommandWithout(command, credentials.isUsernameRemoveNeeded() ? usernameIndicators : null, credentials.isPasswordRemoveNeeded() ? passwordIndicators : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "syncCredentials"));
        }
        return string;
    }

    @NotNull
    private static String getCommandWithout(@NotNull String command, LexemeIndicators ... indicators) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.rawLexemes(command);
        for (LexemeIndicators indicator : indicators) {
            if (indicator == null) continue;
            int lexemeIndex = DumpCredentialsManager.getIndexFromCommand(lexemes, indicator);
            while (lexemeIndex != -1 && lexemeIndex != lexemes.size() - 1) {
                lexemes.remove(lexemeIndex);
                if (indicator.hasParameter()) {
                    lexemes.remove(lexemeIndex);
                }
                lexemeIndex = DumpCredentialsManager.getIndexFromCommand(lexemes, indicator);
            }
        }
        String string = StringUtil.join(lexemes, DumpCommandLineLexeme::getText, (String)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        return string;
    }

    @NotNull
    private DumpCredentials askCredentials(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource source, @NotNull ConnectionData username, @NotNull ConnectionData password) {
        Pair<String, String> pair;
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (username == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "username", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        boolean noStore = !username.isNeedToSetManually() || !password.isNeedToSetManually();
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String usernameForDialog = !username.isNeedToSetManually() ? DumpCredentialsManager.getFromCommandLine(lexemes, usernameIndicators) : username.getValue();
        String passwordForDialog = !password.isNeedToSetManually() ? DumpCredentialsManager.getFromCommandLine(lexemes, passwordIndicators) : password.getValue();
        Pair<String, String> pair2 = pair = noStore ? DumpCredentialsManager.getNoStored(source, usernameForDialog, passwordForDialog) : this.getStored(source, credentials, usernameForDialog);
        if (pair == null) {
            DumpCredentialsManager.cancelDump();
        }
        boolean removeUsername = !username.isNeedToSetManually() && !StringUtil.equals((CharSequence)usernameForDialog, (CharSequence)((CharSequence)pair.getFirst()));
        boolean removePassword = !password.isNeedToSetManually() && !StringUtil.equals((CharSequence)passwordForDialog, (CharSequence)((CharSequence)pair.getSecond()));
        boolean needManualSetUsername = removeUsername || username.isNeedToSetManually();
        boolean needManualSetPassword = removePassword || password.isNeedToSetManually();
        DumpCredentials dumpCredentials = new DumpCredentials(new ConnectionData((String)pair.getFirst(), needManualSetUsername), new ConnectionData((String)pair.getSecond(), needManualSetPassword), removeUsername, removePassword);
        if (dumpCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        return dumpCredentials;
    }

    @Nullable
    private static Pair<String, String> getNoStored(@NotNull LocalDataSource source, @Nullable String username, @Nullable String password) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getNoStored"));
        }
        return (Pair)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "lambda$getNoStored$0"));
            }
            PasswordPromptComponent component = new PasswordPromptComponent(true, MESSAGE, true, null);
            component.setUserName(username);
            component.setPassword(password);
            DialogBuilder builder = new DialogBuilder().centerPanel(component.getComponent()).title(String.format("Dumping %s", source.getName())).okActionEnabled(true);
            builder.addCancelAction();
            builder.addOkAction();
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            if (!builder.showAndGet()) {
                return null;
            }
            return Pair.create((Object)component.getUserName(), (Object)String.valueOf(component.getPassword()));
        });
    }

    @Nullable
    private Pair<String, String> getStored(@NotNull LocalDataSource source, @NotNull DatabaseCredentials credentials, @Nullable String username) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getStored"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getStored"));
        }
        Credentials asked = credentials.askCredentialsWhenFailed(this.myProject, source, MESSAGE, username);
        return asked == null || StringUtil.isEmpty((String)asked.getUserName()) || StringUtil.isEmpty((String)asked.getPasswordAsString()) ? null : Pair.create((Object)asked.getUserName(), (Object)asked.getPasswordAsString());
    }

    @Nullable
    private static String getFromCommandLine(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getFromCommandLine"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getFromCommandLine"));
        }
        if (indicators.isNoAskingIndicator()) {
            return "";
        }
        if (!indicators.hasParameter()) {
            return null;
        }
        int index = DumpCredentialsManager.getIndexFromCommand(lexemes, indicators);
        if (index == -1 || index == lexemes.size() - 1) {
            return null;
        }
        return StringUtil.trim((String)lexemes.get(index + 1).getText());
    }

    private static int getIndexFromCommand(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getIndexFromCommand"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getIndexFromCommand"));
        }
        return ContainerUtil.lastIndexOf(lexemes, DbDumpUtil.lexemeWithParameterFinder(lexemes, indicators));
    }

    private static void cancelDump() {
        throw new ProcessCanceledException();
    }

    @NotNull
    private ConnectionData getData(@Nullable LexemeIndicators indicators, @NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getData"));
        }
        ConnectionData connectionData = new ConnectionData(string, !this.mySettings.contains(indicators));
        if (connectionData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getData"));
        }
        return connectionData;
    }

    private static class DumpCredentials {
        private final ConnectionData myUsername;
        private final ConnectionData myPassword;
        private final boolean myUsernameRemoveNeeded;
        private final boolean myPasswordRemoveNeeded;

        private DumpCredentials(@NotNull ConnectionData username, @NotNull ConnectionData password, boolean usernameRemoveNeeded, boolean passwordRemoveNeeded) {
            if (username == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "username", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "<init>"));
            }
            if (password == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "<init>"));
            }
            this.myUsername = username;
            this.myPassword = password;
            this.myUsernameRemoveNeeded = usernameRemoveNeeded;
            this.myPasswordRemoveNeeded = passwordRemoveNeeded;
        }

        public boolean isPasswordRemoveNeeded() {
            return this.myPasswordRemoveNeeded;
        }

        public boolean isUsernameRemoveNeeded() {
            return this.myUsernameRemoveNeeded;
        }

        @NotNull
        public ConnectionData getPassword() {
            ConnectionData connectionData = this.myPassword;
            if (connectionData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "getPassword"));
            }
            return connectionData;
        }

        @NotNull
        public ConnectionData getUsername() {
            ConnectionData connectionData = this.myUsername;
            if (connectionData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "getUsername"));
            }
            return connectionData;
        }
    }

    private static class ConnectionData {
        private final String myValue;
        private final boolean myNeedToSetManually;

        ConnectionData(@Nullable String value, boolean needToSetManually) {
            this.myValue = value;
            this.myNeedToSetManually = needToSetManually;
        }

        boolean isNeedToSetManually() {
            return this.myNeedToSetManually;
        }

        @Nullable
        String getValue() {
            return this.myValue;
        }

        boolean isEmpty() {
            return this.myValue != null && this.myValue.isEmpty();
        }
    }
}

