/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ui.ChooseExtractorForm;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExtractionHelper {
    @NotNull
    public CharOut createOut(@NotNull String var1, @NotNull DataExtractor var2) throws IOException;

    public boolean chooseFile(@NotNull DataExtractor var1, Project var2, String var3, boolean var4);

    public void release(@NotNull DataExtractor var1) throws IOException;

    public void after();

    @NotNull
    public String getTitleFormatString();

    @Nullable
    default public DataExtractorFactory chooseExtractorFactory(@NotNull DataContext context, @NotNull Project project) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/ExtractionHelper", "chooseExtractorFactory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/ExtractionHelper", "chooseExtractorFactory"));
        }
        return DataExtractorProperties.getCurrentExtractorFactory((Project)CommonDataKeys.PROJECT.getData(context));
    }

    public static class ClipboardExtractionHelper
    implements ExtractionHelper {
        private CharOut myOut;

        @Override
        @NotNull
        public CharOut createOut(@NotNull String name, @NotNull DataExtractor extractor) throws IOException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper", "createOut"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper", "createOut"));
            }
            CharOut charOut = this.myOut = CharOut.Util.newSink();
            if (charOut == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper", "createOut"));
            }
            return charOut;
        }

        @Override
        public boolean chooseFile(@NotNull DataExtractor extractor, Project project, String name, boolean directory) {
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper", "chooseFile"));
            }
            return true;
        }

        @Override
        public void release(@NotNull DataExtractor extractor) throws IOException {
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper", "release"));
            }
            String data = this.myOut.toString();
            this.myOut = null;
            boolean htmlNeeded = extractor.getFileExtension().contains("htm");
            Object content = htmlNeeded ? new TextTransferable(data) : new StringSelection(data);
            UIUtil.invokeLaterIfNeeded(() -> ClipboardExtractionHelper.lambda$release$0((Transferable)content));
        }

        @Override
        public void after() {
        }

        @Override
        @NotNull
        public String getTitleFormatString() {
            if ("Copy %s to clipboard" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper", "getTitleFormatString"));
            }
            return "Copy %s to clipboard";
        }

        private static /* synthetic */ void lambda$release$0(Transferable content) {
            CopyPasteManager.getInstance().setContents(content);
        }
    }

    public static class FileExtractionHelper
    implements ExtractionHelper {
        private BufferedWriter myWriter;
        protected File myFile;

        @Override
        @NotNull
        public CharOut createOut(@NotNull String name, @NotNull DataExtractor extractor) throws IOException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "createOut"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "createOut"));
            }
            File fileToWrite = this.createFileToWrite(name, extractor);
            this.myWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWrite), CharsetToolkit.UTF8_CHARSET));
            CharOut charOut = CharOut.Util.newSink(this.myWriter);
            if (charOut == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "createOut"));
            }
            return charOut;
        }

        private File createFileToWrite(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "createFileToWrite"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "createFileToWrite"));
            }
            if (this.myFile.isFile()) {
                return this.myFile;
            }
            return this.findFile(name, extractor);
        }

        private File findFile(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "findFile"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "findFile"));
            }
            File result = this.createFile(name, extractor, null);
            int index = 1;
            while (!DataExtractorProperties.isOverwriteExistingFiles() && result.exists()) {
                result = this.createFile(name, extractor, index++);
            }
            return result;
        }

        private File createFile(@NotNull String name, @NotNull DataExtractor extractor, @Nullable Integer index) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "createFile"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "createFile"));
            }
            return new File(this.myFile, FileUtil.sanitizeFileName((String)name) + (index == null ? "" : "_" + index) + "." + extractor.getFileExtension());
        }

        @Override
        public void release(@NotNull DataExtractor extractor) throws IOException {
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "release"));
            }
            try {
                this.myWriter.close();
            }
            finally {
                this.myWriter = null;
            }
        }

        @Override
        public void after() {
            if (this.myFile == null) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
        }

        @Override
        @NotNull
        public String getTitleFormatString() {
            if ("Save %s to file" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "getTitleFormatString"));
            }
            return "Save %s to file";
        }

        @Override
        public boolean chooseFile(@NotNull DataExtractor extractor, @NotNull Project project, @NotNull String name, boolean directory) {
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseFile"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseFile"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseFile"));
            }
            return this.chooseFileToDumpTo(extractor.getFileExtension(), project, name, directory);
        }

        @Override
        @Nullable
        public DataExtractorFactory chooseExtractorFactory(@NotNull DataContext context, @NotNull Project project) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseExtractorFactory"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseExtractorFactory"));
            }
            return ChooseExtractorForm.chooseExtractorFactory(project, (DataGrid)context.getData(DatabaseDataKeys.DATA_GRID_KEY));
        }

        protected boolean chooseFileToDumpTo(@NotNull String fileExtension, @NotNull Project project, @NotNull String targetName, boolean directory) {
            String defaultFileName;
            if (fileExtension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtension", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseFileToDumpTo"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseFileToDumpTo"));
            }
            if (targetName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetName", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseFileToDumpTo"));
            }
            if (directory) {
                return this.chooseDirToDumpTo(project);
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Data To File", "Save all table data to file", new String[0]);
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            VirtualFileWrapper wrapper = dialog.save(null, defaultFileName = FileUtil.sanitizeFileName((String)targetName) + "." + fileExtension);
            if (wrapper == null) {
                return false;
            }
            VirtualFile virtualFile = wrapper.getVirtualFile(true);
            if (virtualFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile})) {
                String message = "Cannot write file: " + wrapper.getFile().getPath();
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(message, MessageType.WARNING).notify(project);
                return false;
            }
            this.myFile = wrapper.getFile();
            return true;
        }

        private boolean chooseDirToDumpTo(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper", "chooseDirToDumpTo"));
            }
            FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
            this.myFile = file == null ? null : new File(file.getPath());
            return this.myFile != null;
        }
    }
}

