/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DataBus;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.IdentityDataProducer;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dump.DumpRequest;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class DumpHandler<T> {
    private static final int MAX_SYMBOLS = 40;
    @NotNull
    final Project myProject;
    @NotNull
    final List<T> mySources;
    @NotNull
    final String myTitle;
    @NotNull
    final ExtractionHelper myManager;
    @Nullable
    protected ModelIndexSet<DataConsumer.Column> mySelectedColumns;
    @Nullable
    protected CharOut myOutput;
    protected DatabaseDialectEx myDialect;
    protected String myQueryText;
    protected int myResultSetIndex;

    protected DumpHandler(@NotNull Project project, @NotNull List<T> sources, @NotNull ExtractionHelper manager, @NotNull String displayName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/DumpHandler", "<init>"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/dump/DumpHandler", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dump/DumpHandler", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/database/dump/DumpHandler", "<init>"));
        }
        this.myProject = project;
        this.myManager = manager;
        this.mySources = sources;
        this.myTitle = String.format(this.myManager.getTitleFormatString(), displayName);
    }

    @NotNull
    protected abstract DatabaseDialectEx getDialect(@NotNull T var1);

    protected abstract int getResultSetIndex(@NotNull T var1);

    @Nullable
    protected abstract String getQueryText(@NotNull T var1);

    @Nullable
    protected abstract ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull T var1);

    @Nullable
    protected abstract String getName(@NotNull T var1);

    @Nullable
    protected abstract AsyncPromise<Void> run(@NotNull T var1, @NotNull DataExtractor var2, int var3);

    @NotNull
    protected NotNullFunction<DataExtractor, DataRequest> newSimpleRunner(@NotNull DataProducer producer, DataRequest.Owner owner) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dump/DumpHandler", "newSimpleRunner"));
        }
        NotNullFunction notNullFunction = extractor -> {
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dump/DumpHandler", "lambda$newSimpleRunner$0"));
            }
            DataRequest.TxMarker txMarker = owner instanceof DataRequest.OwnerEx ? ((DataRequest.OwnerEx)owner).getCurrentTx() : DataRequest.NONE;
            DataRequest request = this.createDumpRequest(owner, txMarker, (DataExtractor)extractor, null);
            producer.processRequest(request);
            return request;
        };
        if (notNullFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler", "newSimpleRunner"));
        }
        return notNullFunction;
    }

    private void processError(@Nullable String message, @Nullable Throwable th) {
        String text = message != null ? message : (th != null ? ExceptionUtil.getUserStackTrace((Throwable)th, (Logger)DataSourceUiUtil.LOG) : null);
        DataSourceUiUtil.showNotification(this.myProject, this.myTitle, text, true);
    }

    public void performDump(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/DumpHandler", "performDump"));
        }
        String defaultName = this.getName(ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(this.mySources)));
        DataExtractorFactory factory = this.myManager.chooseExtractorFactory(context, this.myProject);
        if (defaultName == null || factory == null) {
            return;
        }
        DataExtractor extensionExtractor = factory.createExtractor(context);
        if (extensionExtractor == null || !this.myManager.chooseFile(extensionExtractor, this.myProject, defaultName, this.mySources.size() > 1)) {
            return;
        }
        ProgressManager.getInstance().run((Task)this.buildTask(factory, context));
    }

    @NotNull
    public Task.Backgroundable buildTask(@NotNull DataExtractorFactory factory, @NotNull DataContext context) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/dump/DumpHandler", "buildTask"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/DumpHandler", "buildTask"));
        }
        final List pairs = JBIterable.from(this.mySources).map(s -> {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/dump/DumpHandler", "lambda$buildTask$1"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/DumpHandler", "lambda$buildTask$1"));
            }
            return Pair.create((Object)s, (Object)factory.createExtractor(new DumpDataContext(context, s)));
        }).toList();
        Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, this.myTitle){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dump/DumpHandler$1", "run"));
                }
                indicator.setText("Initializing output...");
                indicator.setIndeterminate(true);
                try {
                    for (Pair p : pairs) {
                        indicator.checkCanceled();
                        if (p.second == null) continue;
                        DumpHandler.this.processSource(p.first, (DataExtractor)p.second, indicator);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    DumpHandler.this.myManager.after();
                }
            }
        };
        if (backgroundable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler", "buildTask"));
        }
        return backgroundable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSource(@NotNull T source, @NotNull DataExtractor extractor, @NotNull ProgressIndicator indicator) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler", "processSource"));
        }
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/DumpHandler", "processSource"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dump/DumpHandler", "processSource"));
        }
        try {
            AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
            String name = this.getName(source);
            this.myDialect = this.getDialect(source);
            this.myResultSetIndex = this.getResultSetIndex(source);
            this.mySelectedColumns = this.getSelectedColumns(source);
            this.myQueryText = this.getQueryText(source);
            if (name == null || this.myQueryText == null) {
                return;
            }
            this.myOutput = this.myManager.createOut(name, extractor);
            indicator.setText("Running query...");
            AsyncPromise<Void> promise = this.run(source, extractor, this.myResultSetIndex);
            if (promise == null) {
                return;
            }
            promise.processed(v -> result.set((Object)true));
            result.get();
        }
        catch (Exception ex) {
            this.processError(null, ex);
        }
        finally {
            this.finish(extractor);
        }
    }

    private void finish(@NotNull DataExtractor extractor) {
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/DumpHandler", "finish"));
        }
        if (this.myOutput != null) {
            try {
                this.myManager.release(extractor);
            }
            catch (Exception ex) {
                this.processError(null, ex);
            }
            finally {
                this.myOutput = null;
            }
        }
    }

    @NotNull
    DataRequest createDumpRequest(DataRequest.Owner owner, DataRequest.TxMarker txMarker, DataExtractor extractor, @Nullable String name) {
        DumpRequest dumpRequest = new DumpRequest(owner, txMarker, this.myQueryText, DataRequest.newConstraints(0, -1, this.myResultSetIndex), this.mySelectedColumns, extractor, this.myDialect, (CharOut)ObjectUtils.assertNotNull((Object)this.myOutput), name);
        if (dumpRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler", "createDumpRequest"));
        }
        return dumpRequest;
    }

    private static class DumpDataContext
    implements DataContext {
        private final DataContext myParent;
        private final Object myElement;

        DumpDataContext(@NotNull DataContext parent, @NotNull Object element) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dump/DumpHandler$DumpDataContext", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dump/DumpHandler$DumpDataContext", "<init>"));
            }
            this.myParent = parent;
            this.myElement = element;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (this.myElement instanceof PsiElement && CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return this.myElement;
            }
            return this.myParent.getData(dataId);
        }
    }

    public static class GridHandler
    extends DumpHandler<DataGrid> {
        public GridHandler(@NotNull Project project, @NotNull DataGrid target, @NotNull ExtractionHelper manager) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/DumpHandler$GridHandler", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dump/DumpHandler$GridHandler", "<init>"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dump/DumpHandler$GridHandler", "<init>"));
            }
            super(project, ContainerUtil.list((Object[])new DataGrid[]{target}), manager, target.getDisplayName());
        }

        @Override
        @NotNull
        protected DatabaseDialectEx getDialect(@NotNull DataGrid source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$GridHandler", "getDialect"));
            }
            DatabaseDialectEx databaseDialectEx = DataGridUtil.getDatabaseDialect(source);
            if (databaseDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$GridHandler", "getDialect"));
            }
            return databaseDialectEx;
        }

        @Override
        @Nullable
        protected String getName(@NotNull DataGrid target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dump/DumpHandler$GridHandler", "getName"));
            }
            String query = this.getQueryText(target);
            if (query == null) {
                return null;
            }
            return query.substring(0, Math.min(40, query.length()));
        }

        @Override
        protected int getResultSetIndex(@NotNull DataGrid source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$GridHandler", "getResultSetIndex"));
            }
            return DataGridUtil.getResultSetIndex(source);
        }

        @Override
        @Nullable
        protected String getQueryText(@NotNull DataGrid source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$GridHandler", "getQueryText"));
            }
            DataBusGridDataHookUp hookUp = DataGridUtil.getDataBusHookUp(source);
            return hookUp != null ? hookUp.getUnlimitedQueryText() : null;
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull DataGrid source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$GridHandler", "getSelectedColumns"));
            }
            return source.getVisibleColumns();
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull DataGrid source, @NotNull DataExtractor extractor, int resultSetIndex) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$GridHandler", "run"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/DumpHandler$GridHandler", "run"));
            }
            DataProducer producer = GridHandler.getProducer(source, resultSetIndex);
            DataRequest.Owner owner = GridHandler.getOwner(source);
            return producer != null ? ((DataRequest)this.newSimpleRunner(producer, owner).fun((Object)extractor)).getPromise() : null;
        }

        @Nullable
        private static DataProducer getProducer(@NotNull DataGrid grid, int myResultSetIndex) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dump/DumpHandler$GridHandler", "getProducer"));
            }
            GridPagingModel pageModel = grid.getDataHookup().getPageModel();
            DataBusGridDataHookUp hookUp = DataGridUtil.getDataBusHookUp(grid);
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            return pageModel.isFirstPage() && pageModel.isLastPage() ? new IdentityDataProducer(new DataConsumer.Composite(new DataConsumer[0]), model.getColumns(), ContainerUtil.newArrayList(model.getRows()), myResultSetIndex) : (hookUp != null ? hookUp.getMessageBus().getDataProducer() : null);
        }

        @NotNull
        private static DataRequest.Owner getOwner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dump/DumpHandler$GridHandler", "getOwner"));
            }
            GridPagingModel pageModel = grid.getDataHookup().getPageModel();
            DataRequest.Owner owner = pageModel.isFirstPage() && pageModel.isLastPage() || DataGridUtil.getDataBusHookUp(grid) == null ? DataRequest.newOwner() : DataGridUtil.getDataBusHookUp(grid);
            if (owner == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$GridHandler", "getOwner"));
            }
            return owner;
        }
    }

    public static class ConsoleHandler
    extends DumpHandler<String> {
        private final JdbcConsole myConsole;

        public ConsoleHandler(@NotNull Project project, @NotNull List<String> target, JdbcConsole console, @NotNull ExtractionHelper manager) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "<init>"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "<init>"));
            }
            super(project, target, manager, console.getDisplayName());
            this.myConsole = console;
        }

        @Override
        @NotNull
        protected DatabaseDialectEx getDialect(@NotNull String source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "getDialect"));
            }
            DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myConsole.getDataSource()), (Object)GenericDialect.INSTANCE);
            if (databaseDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "getDialect"));
            }
            return databaseDialectEx;
        }

        @Override
        protected int getResultSetIndex(@NotNull String source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "getResultSetIndex"));
            }
            return 1;
        }

        @Override
        @Nullable
        protected String getName(@NotNull String target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "getName"));
            }
            return target.substring(0, Math.min(40, target.length()));
        }

        @Override
        @Nullable
        protected String getQueryText(@NotNull String source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "getQueryText"));
            }
            return source;
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull String source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "getSelectedColumns"));
            }
            return null;
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull String source, @NotNull DataExtractor extractor, int resultSetIndex) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "run"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/DumpHandler$ConsoleHandler", "run"));
            }
            return ((DataRequest)this.newSimpleRunner(this.myConsole.getMessageBus().getDataProducer(), this.myConsole).fun((Object)extractor)).getPromise();
        }
    }

    public static class DatabaseViewHandler
    extends DumpHandler<DbTable> {
        public DatabaseViewHandler(@NotNull Project project, @NotNull List<DbTable> target, @NotNull ExtractionHelper manager) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "<init>"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "<init>"));
            }
            super(project, target, manager, DatabaseViewHandler.getName(target));
        }

        @NotNull
        private static String getName(@NotNull List<DbTable> target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getName"));
            }
            String string = target.size() == 1 ? ((DbTable)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(target))).getName() : "tables";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        protected DatabaseDialectEx getDialect(@NotNull DbTable source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getDialect"));
            }
            DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((DbElement)source);
            if (databaseDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getDialect"));
            }
            return databaseDialectEx;
        }

        @Override
        protected int getResultSetIndex(@NotNull DbTable source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getResultSetIndex"));
            }
            return 1;
        }

        @Override
        @NotNull
        protected String getName(@NotNull DbTable target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getName"));
            }
            String string = QNameUtil.getQualifiedName((DbElement)target);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getQueryText(@NotNull DbTable source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getQueryText"));
            }
            String string = DbImplUtil.createSelectAllQuery((DasTable)source, this.getDialect(source)).getStatement();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getQueryText"));
            }
            return string;
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull DbTable source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "getSelectedColumns"));
            }
            return null;
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull DbTable source, @NotNull DataExtractor extractor, int resultSetIndex) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "run"));
            }
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "run"));
            }
            return ((DataRequest)this.newEngineRunner(source).fun((Object)extractor)).getPromise();
        }

        @NotNull
        NotNullFunction<DataExtractor, DataRequest> newEngineRunner(@NotNull DbTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "newEngineRunner"));
            }
            NotNullFunction notNullFunction = extractor -> {
                if (table == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "lambda$newEngineRunner$1"));
                }
                LocalDataSource dataSource = DbImplUtil.getLocalDataSource((DatabaseSystem)table.getDataSource());
                DataRequest.OwnerEx owner = DataRequest.newOwnerEx(this.myProject);
                JdbcEngine engine = new JdbcEngine(this.myProject, DataBus.shortCircuit(owner.getMessageBus()), dataSource, null);
                Disposer.register((Disposable)owner, (Disposable)engine);
                DataRequest request = this.createDumpRequest(owner, DataRequest.AUTO_COMMIT, (DataExtractor)extractor, table.getName());
                request.getPromise().processed(v -> Disposer.dispose((Disposable)owner));
                owner.getMessageBus().getDataProducer().processRequest(request);
                return request;
            };
            if (notNullFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "newEngineRunner"));
            }
            return notNullFunction;
        }

        @Override
        @NotNull
        DataRequest createDumpRequest(DataRequest.Owner owner, DataRequest.TxMarker txMarker, DataExtractor extractor, String name) {
            DumpRequest dumpRequest = new DumpRequest(owner, txMarker, this.myQueryText, DataRequest.newConstraints(0, -1, this.myResultSetIndex), this.mySelectedColumns, extractor, this.myDialect, (CharOut)ObjectUtils.assertNotNull((Object)this.myOutput), name){

                @Override
                public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler$1", "addRows"));
                    }
                    if (rows == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler$1", "addRows"));
                    }
                    ObjectFormatter.convertRows(rows, ContainerUtil.list((Object[])this.myColumns));
                    super.addRows(context, rows);
                }
            };
            if (dumpRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpHandler$DatabaseViewHandler", "createDumpRequest"));
            }
            return dumpRequest;
        }
    }
}

