/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffSupport;
import com.intellij.database.diff.TableDiffEditor;
import com.intellij.database.diff.TableDiffSupport;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import gnu.trove.TIntFunction;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class TableSyncScrollSupport {
    @NotNull
    private static MyScrollHelper create(@NotNull TableDiffEditor master, @NotNull TableDiffEditor slave, final @NotNull SyncScrollSupport.SyncScrollable scrollable, final @NotNull Side side) {
        if (master == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/database/diff/TableSyncScrollSupport", "create"));
        }
        if (slave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/database/diff/TableSyncScrollSupport", "create"));
        }
        if (scrollable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/database/diff/TableSyncScrollSupport", "create"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/database/diff/TableSyncScrollSupport", "create"));
        }
        MyScrollHelper myScrollHelper = new MyScrollHelper(new TableDiffSupport(master), new TableDiffSupport(slave), new TIntFunction(){

            public int execute(int value) {
                return scrollable.transfer(side, value);
            }
        });
        if (myScrollHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableSyncScrollSupport", "create"));
        }
        return myScrollHelper;
    }

    private static void doScrollVertically(@NotNull ScrollingModel model, int offset) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/diff/TableSyncScrollSupport", "doScrollVertically"));
        }
        model.disableAnimation();
        try {
            model.scrollVertically(offset);
        }
        finally {
            model.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull ScrollingModel model, int offset) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/diff/TableSyncScrollSupport", "doScrollHorizontally"));
        }
        model.disableAnimation();
        try {
            model.scrollHorizontally(offset);
        }
        finally {
            model.enableAnimation();
        }
    }

    private static class MyScrollHelper
    implements VisibleAreaListener {
        @NotNull
        private final DiffSupport myMaster;
        @NotNull
        private final DiffSupport mySlave;
        @NotNull
        private final TIntFunction myConvertor;

        public MyScrollHelper(@NotNull DiffSupport master, @NotNull DiffSupport slave, @NotNull TIntFunction convertor) {
            if (master == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper", "<init>"));
            }
            if (slave == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper", "<init>"));
            }
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper", "<init>"));
            }
            this.myMaster = master;
            this.mySlave = slave;
            this.myConvertor = convertor;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (oldRectangle == null) {
                return;
            }
            this.syncVerticalScroll(newRectangle, oldRectangle);
            this.syncHorizontalScroll(newRectangle, oldRectangle);
        }

        private void syncVerticalScroll(@NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
            if (newRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRectangle", "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper", "syncVerticalScroll"));
            }
            if (oldRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRectangle", "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper", "syncVerticalScroll"));
            }
            if (newRectangle.y == oldRectangle.y) {
                return;
            }
            int masterVerticalScrollOffset = this.myMaster.getScrollingModel().getVerticalScrollOffset();
            Rectangle viewRect = this.myMaster.getScrollingModel().getVisibleArea();
            int middleY = viewRect.height / 3;
            LogicalPosition masterPos = this.myMaster.xyToLogicalPosition(new Point(viewRect.x, masterVerticalScrollOffset + middleY));
            int masterCenterLine = masterPos.line;
            int scrollToLine = this.myConvertor.execute(masterCenterLine);
            int height = this.myMaster.getLineHeight(masterCenterLine);
            int correction = height == 0 ? 0 : (masterVerticalScrollOffset + middleY) % height;
            Point point = this.mySlave.logicalPositionToXY(new LogicalPosition(scrollToLine, masterPos.column));
            int offset = point.y - middleY + correction;
            int deltaHeaderOffset = this.mySlave.getHeaderOffset() - this.myMaster.getHeaderOffset();
            TableSyncScrollSupport.doScrollVertically(this.mySlave.getScrollingModel(), offset + deltaHeaderOffset);
        }

        private void syncHorizontalScroll(@NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
            if (newRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRectangle", "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper", "syncHorizontalScroll"));
            }
            if (oldRectangle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRectangle", "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper", "syncHorizontalScroll"));
            }
            if (newRectangle.x == oldRectangle.x) {
                return;
            }
            int offset = newRectangle.x;
            TableSyncScrollSupport.doScrollHorizontally(this.mySlave.getScrollingModel(), offset);
        }
    }

    public static class TableViewerSyncScrollSupport {
        @NotNull
        private final TableDiffEditor myEditor1;
        @NotNull
        private final TableDiffEditor myEditor2;
        @NotNull
        private final SyncScrollSupport.SyncScrollable myScrollable;
        @NotNull
        private final MyScrollHelper myHelper1;
        @NotNull
        private final MyScrollHelper myHelper2;
        public boolean myDuringSyncScroll;

        public TableViewerSyncScrollSupport(@NotNull TableDiffEditor editor1, @NotNull TableDiffEditor editor2, @NotNull SyncScrollSupport.SyncScrollable scrollable) {
            if (editor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableSyncScrollSupport$TableViewerSyncScrollSupport", "<init>"));
            }
            if (editor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableSyncScrollSupport$TableViewerSyncScrollSupport", "<init>"));
            }
            if (scrollable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/database/diff/TableSyncScrollSupport$TableViewerSyncScrollSupport", "<init>"));
            }
            this.myDuringSyncScroll = false;
            this.myEditor1 = editor1;
            this.myEditor2 = editor2;
            this.myScrollable = scrollable;
            this.myHelper1 = TableSyncScrollSupport.create(this.myEditor1, this.myEditor2, this.myScrollable, Side.LEFT);
            this.myHelper2 = TableSyncScrollSupport.create(this.myEditor2, this.myEditor1, this.myScrollable, Side.RIGHT);
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!this.myScrollable.isSyncScrollEnabled() || this.myDuringSyncScroll) {
                return;
            }
            this.myDuringSyncScroll = true;
            try {
                if (e.getEditor() == this.myEditor1.getScrollingModel().getFakeEditor()) {
                    this.myHelper1.visibleAreaChanged(e);
                } else if (e.getEditor() == this.myEditor2.getScrollingModel().getFakeEditor()) {
                    this.myHelper2.visibleAreaChanged(e);
                }
            }
            finally {
                this.myDuringSyncScroll = false;
            }
        }
    }
}

