/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.diff.TableDiffEditor;
import com.intellij.database.diff.TableDiffTool;
import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableEditorHolder
extends EditorHolder {
    @NotNull
    protected final TableDiffEditor myEditor;

    public TableEditorHolder(@NotNull TableDiffEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/diff/TableEditorHolder", "<init>"));
        }
        this.myEditor = editor;
    }

    @NotNull
    public TableDiffEditor getEditor() {
        TableDiffEditor tableDiffEditor = this.myEditor;
        if (tableDiffEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableEditorHolder", "getEditor"));
        }
        return tableDiffEditor;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableEditorHolder", "getComponent"));
        }
        return jComponent;
    }

    public void installFocusListener(@NotNull FocusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/diff/TableEditorHolder", "installFocusListener"));
        }
        JComponent component = this.myEditor.getPreferredFocusedComponent();
        if (component != null) {
            component.addFocusListener(listener);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public static class TableEditorHolderFactory
    extends EditorHolderFactory<TableEditorHolder> {
        public static TableEditorHolderFactory INSTANCE = new TableEditorHolderFactory();

        @NotNull
        public TableEditorHolder create(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/diff/TableEditorHolder$TableEditorHolderFactory", "create"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableEditorHolder$TableEditorHolderFactory", "create"));
            }
            if (content instanceof TableDiffTool.TableDiffContent) {
                TableEditorHolder tableEditorHolder = new TableEditorHolder(new TableDiffEditor(context, (GridDataHookUp)ObjectUtils.assertNotNull(((TableDiffTool.TableDiffContent)content).getHookUp())));
                if (tableEditorHolder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableEditorHolder$TableEditorHolderFactory", "create"));
                }
                return tableEditorHolder;
            }
            throw new IllegalArgumentException(content.toString());
        }

        public boolean canShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/diff/TableEditorHolder$TableEditorHolderFactory", "canShowContent"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableEditorHolder$TableEditorHolderFactory", "canShowContent"));
            }
            TableDiffTool.TableDiffContent tableContent = (TableDiffTool.TableDiffContent)((Object)ObjectUtils.tryCast((Object)content, TableDiffTool.TableDiffContent.class));
            return tableContent != null && tableContent.getHookUp() != null;
        }

        public boolean wantShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/diff/TableEditorHolder$TableEditorHolderFactory", "wantShowContent"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableEditorHolder$TableEditorHolderFactory", "wantShowContent"));
            }
            TableDiffTool.TableDiffContent tableContent = (TableDiffTool.TableDiffContent)((Object)ObjectUtils.tryCast((Object)content, TableDiffTool.TableDiffContent.class));
            return tableContent != null && tableContent.getHookUp() != null;
        }
    }
}

