/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dialects.AbstractTransactSqlDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.sybase.SybaseDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDialect
extends AbstractTransactSqlDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.VIEW, ObjectKind.INDEX).put(ObjectKind.VIEW, ObjectKind.TRIGGER).put(ObjectKind.PACKAGE, ObjectKind.ROUTINE).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).build();
    public static final SybaseDialect INSTANCE = new SybaseDialect();

    public SybaseDialect() {
        super(META_MODEL, new TypeHelper.SybaseTypeHelper(), new KeywordHelper.SybaseKeywords(), Casing.create((Case)Case.EXACT, (Case)Case.EXACT));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.SYBASE;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Sybase;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Sybase" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "getDisplayName"));
        }
        return "Sybase";
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dialects/SybaseDialect", "getNameForKind"));
        }
        return kind == ObjectKind.PACKAGE ? "PROCEDURE GROUP" : (kind == ObjectKind.ROUTINE ? "FUNCTION" : super.getNameForKind(kind));
    }

    @Override
    @NotNull
    public String getLengthFunction() {
        if ("datalength" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "getLengthFunction"));
        }
        return "datalength";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/SybaseDialect", "supportsProduct"));
        }
        if (databaseProductName == null) {
            return false;
        }
        String lname = databaseProductName.trim().toLowerCase(Locale.ENGLISH);
        return lname.startsWith("sybase") || lname.startsWith("adaptive");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SybaseDialect", "sqlDropColumn"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SybaseDialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/SybaseDialect", "sqlDropTable"));
        }
        if (cascadeConstraints) {
            for (DasConstraint keyInfo : model.getExportedKeys(table)) {
                builder.keywords("ALTER", "TABLE").space();
                builder.qualifiedRef((DasObject)keyInfo.getTable());
                builder.keywords("DROP", "CONSTRAINT").space();
                builder.constraintRef((DasObject)keyInfo, keyInfo.getName());
                builder.newStatement();
            }
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new SybaseDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/SybaseDialect", "sqlAddPrimaryKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean typeChanged) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlAlterColumnTypeAndNullable"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SybaseDialect", "sqlAlterColumnTypeAndNullable"));
        }
        if (column.isNotNull() || !typeChanged) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnNullableAlterSQL(builder, column, "MODIFY", typeChanged);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlAlterColumnTypeAndNullable"));
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder, "MODIFY", "", false, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlAlterColumnTypeAndNullable"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlAlterColumnDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SybaseDialect", "sqlAlterColumnDefault"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SybaseDialect", "sqlAddColumnAutoIncrement"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlDefineColumn"));
        }
        builder.columnRef((DasObject)column);
        builder.space();
        builder.type((DasTypedObject)column);
        if (DasUtil.isAutoVal((DasColumn)column)) {
            builder.space().keyword("IDENTITY");
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        if (singlePk) {
            builder.space().keywords("PRIMARY", "KEY");
        }
        if (column.isNotNull()) {
            builder.space().keywords("NOT", "NULL");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropPackage() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlDropPackage"));
        }
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/database/dialects/SybaseDialect", "sqlDropPackage"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "PROCEDURE").space().qualifiedRef((DasObject)pkg);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlDropPackage"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SybaseDialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/SybaseDialect", "sqlDropIndex"));
        }
        builder.keywords("DROP", "INDEX").space();
        builder.qualifiedRef((DasObject)table).symbol(".").identifier((DasObject)index, indexName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlDropIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/SybaseDialect", "sqlSequenceInformation"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropType(@NotNull DdlBuilder builder, @NotNull DasUserDefinedType type) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlDropType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dialects/SybaseDialect", "sqlDropType"));
        }
        builder.keyword("EXEC").space().plain("sp_droptype").space().symbol("'");
        DdlBuilder.Marker mark = builder.mark();
        builder.qualifiedRef((DasObject)type);
        mark.replace(DbImplUtil.escapeStr(mark.extract()));
        mark.finish();
        DdlBuilder ddlBuilder = builder.symbol("'");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlDropType"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull Connection connection) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SybaseDialect", "tryToLoadTableInfo"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/SybaseDialect", "tryToLoadTableInfo"));
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr(QNameUtil.getQualifiedName((DbElement)element))), "rowtotal", "rows");
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "tryToLoadTableInfo"));
        }
        return map;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SybaseDialect", "sqlPackageBodyDefinition"));
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlPackageDefinition(element);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlPackageBodyDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SybaseDialect", "sqlPackageDefinition"));
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlPackageDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlDefineProcedure"));
        }
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/SybaseDialect", "sqlDefineProcedure"));
        }
        DasObject parent = routine2.getDbParent();
        boolean inPackage = parent != null && parent.getKind() == ObjectKind.PACKAGE;
        DasRoutine.Kind kind = inPackage ? DasRoutine.Kind.PROCEDURE : routine2.getRoutineKind();
        String type = kind.name();
        builder.keyword("create").space();
        builder.keyword(type).space().qualifiedRef((DasObject)(inPackage ? parent : routine2));
        if (inPackage) {
            builder.plain(";");
            Object base = DbImplUtil.unwrap((DasObject)routine2);
            if (base instanceof DasPositioned) {
                builder.plain(String.valueOf(((DasPositioned)base).getPosition()));
            } else {
                builder.plain(routine2.getName());
            }
        }
        this.sqlDefinePrototype(builder, routine2, true, true);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlDefineProcedure"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SybaseDialect", "sqlViewDefinition"));
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlViewDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SybaseDialect", "sqlProcedureDefinition"));
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlProcedureDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/SybaseDialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/SybaseDialect", "qualifiedIdentifier"));
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/SybaseDialect", "sqlExplainPlan"));
        }
        builder.keywords("set", "statement_cache", "off").newLine();
        builder.keywords("set", "showplan", "on").newLine();
        if (!analyze) {
            builder.keywords("set", "noexec", "on").newLine();
        }
        builder.keywords("go").newLine();
        builder.plain(statement).newLine();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SybaseDialect", "sqlPostExplainPlan"));
        }
        if (!analyze) {
            builder.keywords("set", "noexec", "off").newLine();
        }
        builder.keywords("set", "showplan", "off").newLine();
        builder.keywords("set", "statement_cache", "on").newLine();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "sqlPostExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/SybaseDialect", "tryToLoadDatabaseList"));
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "EXEC sp_helpdb", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SybaseDialect", "tryToLoadDatabaseList"));
        }
        return list;
    }
}

