/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.Db2Dialect;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum TypeConverter {
    STRING_TYPE(string -> string, new int[0]){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$1", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$1", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$1", "setParameter"));
            }
            statement.setObject(index, parameter, column.type);
        }
    }
    ,
    CLOB_TYPE(string -> string, new int[]{2005}){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$2", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$2", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$2", "setParameter"));
            }
            statement.setString(index, (String)parameter);
        }
    }
    ,
    DB2_OTHERS(String::toString, new int[0]){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$3", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$3", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$3", "setParameter"));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)"DECFLOAT", (CharSequence)column.typeName)) {
                BigDecimal decimal = new BigDecimal((String)parameter);
                statement.setBigDecimal(index, decimal);
                return;
            }
            statement.setObject(index, parameter, column.type);
        }

        @Override
        boolean isSuitable(@NotNull DatabaseDialect dialect, int type) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/TypeConverter$3", "isSuitable"));
            }
            return dialect == Db2Dialect.INSTANCE && type == 1111;
        }
    }
    ,
    ORACLE_XML(String::valueOf, new int[]{2009}){

        @Override
        void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$4", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$4", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$4", "setParameter"));
            }
            statement.setString(index, (String)parameter);
        }

        @Override
        boolean isSuitable(@NotNull DatabaseDialect dialect, int type) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/TypeConverter$4", "isSuitable"));
            }
            return super.isSuitable(dialect, type) && dialect.getFamilyId().isOracle();
        }
    }
    ,
    BINARY_DATA(String::getBytes, new int[]{-3, -2, 2004}){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$5", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$5", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$5", "setParameter"));
            }
            statement.setBytes(index, (byte[])parameter);
        }
    }
    ,
    INT_TYPE(Integer::valueOf, new int[]{4, 5, -6}){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$6", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$6", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$6", "setParameter"));
            }
            statement.setInt(index, (Integer)parameter);
        }
    }
    ,
    LONG_TYPE(Long::valueOf, new int[]{-5}){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$7", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$7", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$7", "setParameter"));
            }
            statement.setLong(index, (Long)parameter);
        }
    }
    ,
    DECIMAL_TYPE(Double::valueOf, new int[]{6, 7, 8, 3, 2}){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$8", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$8", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$8", "setParameter"));
            }
            statement.setDouble(index, (Double)parameter);
        }
    }
    ,
    BOOLEAN_TYPE(string -> StringUtil.equals((CharSequence)"1", (CharSequence)string) || Boolean.valueOf(string) != false, new int[]{16, -7}){

        @Override
        public void setParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @NotNull Object parameter, int index) throws SQLException {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter$9", "setParameter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter$9", "setParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dbimport/TypeConverter$9", "setParameter"));
            }
            statement.setBoolean(index, (Boolean)parameter);
        }
    };

    @NotNull
    private final int[] myTypes;
    @NotNull
    private final Function<String, Object> myConverter;

    private TypeConverter(Function<String, Object> converter, int ... types) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/dbimport/TypeConverter", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/dbimport/TypeConverter", "<init>"));
        }
        this.myConverter = converter;
        this.myTypes = types;
    }

    static void setStatementParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @Nullable String parameter, @NotNull DatabaseDialect dialect, int index) throws ConverterException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter", "setStatementParameter"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter", "setStatementParameter"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/TypeConverter", "setStatementParameter"));
        }
        TypeConverter converter = TypeConverter.getConverterOf(column, dialect);
        Object converted = converter.convert(parameter);
        converter.setStatementParameter(statement, column, converted, index);
    }

    private Object convert(@Nullable String toConvert) throws ConverterException {
        try {
            return toConvert == null ? null : this.myConverter.fun((Object)toConvert);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private void setStatementParameter(@NotNull PreparedStatement statement, @NotNull DataConsumer.Column column, @Nullable Object parameter, int index) throws ConverterException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/TypeConverter", "setStatementParameter"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter", "setStatementParameter"));
        }
        try {
            if (parameter == null) {
                statement.setNull(index, column.type);
            } else {
                this.setParameter(statement, column, parameter, index);
            }
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    boolean isSuitable(@NotNull DatabaseDialect dialect, int type) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/TypeConverter", "isSuitable"));
        }
        return ArrayUtil.find((int[])this.myTypes, (int)type) != -1;
    }

    @NotNull
    private static TypeConverter getConverterOf(@NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/TypeConverter", "getConverterOf"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/TypeConverter", "getConverterOf"));
        }
        for (TypeConverter converter : TypeConverter.values()) {
            if (!converter.isSuitable(dialect, column.type)) continue;
            TypeConverter typeConverter = converter;
            if (typeConverter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/TypeConverter", "getConverterOf"));
            }
            return typeConverter;
        }
        TypeConverter typeConverter = STRING_TYPE;
        if (typeConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/TypeConverter", "getConverterOf"));
        }
        return typeConverter;
    }

    abstract void setParameter(@NotNull PreparedStatement var1, @NotNull DataConsumer.Column var2, @NotNull Object var3, int var4) throws SQLException;

    public static class ConverterException
    extends Exception {
        ConverterException(Exception cause) {
            super(cause);
        }
    }
}

