/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dbimport.DeColumnWithState;
import com.intellij.database.dbimport.ImportCsvDocumentDataHookUp;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTablePreview
implements CsvFormatPreview {
    private final DataGrid myGrid;

    public ImportTablePreview(@NotNull Project project, @NotNull CsvFormat format, @NotNull CharSequence text, @NotNull Disposable parent, boolean tableExists) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportTablePreview", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportTablePreview", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dbimport/ImportTablePreview", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dbimport/ImportTablePreview", "<init>"));
        }
        Document document = EditorFactory.getInstance().createDocument(text);
        document.setReadOnly(true);
        CsvDocumentDataHookUp hookup = ImportTablePreview.createHookUp(project, format, document);
        Disposer.register((Disposable)parent, (Disposable)hookup);
        this.myGrid = DataGridUtil.createPreviewDataGrid(project, hookup, tableExists ? ActionGroup.EMPTY_GROUP : DataGridUtil.getImportColumnHeaderPopupActions());
        Disposer.register((Disposable)parent, (Disposable)this.myGrid);
    }

    @Nullable
    private static CsvDocumentDataHookUp createHookUp(@NotNull Project project, @NotNull CsvFormat format, @NotNull Document document) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportTablePreview", "createHookUp"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportTablePreview", "createHookUp"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/dbimport/ImportTablePreview", "createHookUp"));
        }
        return new ImportCsvDocumentDataHookUp(project, format, document, null);
    }

    @Override
    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportTablePreview", "setFormat"));
        }
        this.getHookUp().setFormat(format);
    }

    void setFormatAndColumns(@NotNull CsvFormat format, @NotNull List<DataConsumer.Column> consumers, @NotNull List<DeColumn> columns) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportTablePreview", "setFormatAndColumns"));
        }
        if (consumers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumers", "com/intellij/database/dbimport/ImportTablePreview", "setFormatAndColumns"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportTablePreview", "setFormatAndColumns"));
        }
        this.getHookUp().setFormatAndColumns(format, consumers);
        this.updateColumnsVisibility(columns);
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.getHookUp().getFormat();
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTablePreview", "getFormat"));
        }
        return csvFormat;
    }

    public void setColumns(@NotNull List<DataConsumer.Column> consumers, List<DeColumn> columns) {
        if (consumers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumers", "com/intellij/database/dbimport/ImportTablePreview", "setColumns"));
        }
        this.getHookUp().setColumns(consumers);
        this.updateColumnsVisibility(columns);
    }

    private void updateColumnsVisibility(@NotNull List<DeColumn> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportTablePreview", "updateColumnsVisibility"));
        }
        for (DeColumn column : columns) {
            if (!(column instanceof DeColumnWithState)) continue;
            DeColumnWithState withState = (DeColumnWithState)column;
            this.myGrid.setColumnEnabled(ModelIndex.forColumn(this.myGrid, withState.getNumber()), withState.isEnabled());
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myGrid.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTablePreview", "getComponent"));
        }
        return jComponent;
    }

    public DataGrid getGrid() {
        return this.myGrid;
    }

    @NotNull
    private ImportCsvDocumentDataHookUp getHookUp() {
        ImportCsvDocumentDataHookUp importCsvDocumentDataHookUp = (ImportCsvDocumentDataHookUp)this.myGrid.getDataHookup();
        if (importCsvDocumentDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTablePreview", "getHookUp"));
        }
        return importCsvDocumentDataHookUp;
    }
}

