/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportColumnEditorModel;
import com.intellij.database.dbimport.ImportDatabaseTableEditor;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDatabaseTableEditorWrapper {
    @NotNull
    private final List<TableEditorListener> myListenerList;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DatabaseEditorState myState;
    @NotNull
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    @NotNull
    private final Disposable myDisposable;
    @Nullable
    private DatabaseTableEditor myEditor;

    public ImportDatabaseTableEditorWrapper(@NotNull Project project, @NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull Disposable disposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper", "<init>"));
        }
        this.myProject = project;
        this.myState = state;
        this.myCaps = caps;
        this.myDisposable = disposable;
        this.myListenerList = ContainerUtil.newArrayList();
    }

    public void addEditorListener(TableEditorListener listener) {
        this.myListenerList.add(listener);
    }

    @Nullable
    public DatabaseTableEditor getEditor() {
        return this.myEditor;
    }

    public void setTable(@NotNull DeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper", "setTable"));
        }
        SqlCodeStyleSettings settings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)this.myProject));
        TableEditorModel tableEditorModel = new TableEditorModel(table, (EditorModelsCache)new ImportModelsCache(settings));
        DatabaseTableEditor old = this.myEditor;
        this.myEditor = new ImportDatabaseTableEditor(this.myState, this.myCaps, tableEditorModel);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myEditor);
        this.fireEditorChanged(old, this.myEditor);
    }

    private void fireEditorChanged(@Nullable DatabaseTableEditor old, @NotNull DatabaseTableEditor newEditor) {
        if (newEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper", "fireEditorChanged"));
        }
        this.myListenerList.forEach(listener -> {
            if (newEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper", "lambda$fireEditorChanged$0"));
            }
            listener.changed(old, newEditor);
        });
    }

    private static class ImportModelsCache
    extends EditorModelsCache {
        public ImportModelsCache(@NotNull SqlCodeStyleSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper$ImportModelsCache", "<init>"));
            }
            super(settings);
        }

        @Override
        public <M extends ObjectEditorModel> M get(@NotNull DeObject obj, @NotNull Class<? extends M> clazz) {
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper$ImportModelsCache", "get"));
            }
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dbimport/ImportDatabaseTableEditorWrapper$ImportModelsCache", "get"));
            }
            return (M)super.get(obj, clazz == ColumnEditorModel.class ? ImportColumnEditorModel.class : clazz);
        }
    }

    public static interface TableEditorListener {
        public void changed(@Nullable DatabaseTableEditor var1, @NotNull DatabaseTableEditor var2);
    }
}

