/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportCsvDocumentDataHookUp
extends CsvDocumentDataHookUp {
    public ImportCsvDocumentDataHookUp(@NotNull Project project, @NotNull CsvFormat format, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "<init>"));
        }
        super(project, format, document, range);
    }

    @Override
    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "setFormat"));
        }
        this.myParser = new CsvFormatParser(format);
        this.getLoader().reloadCurrentPage(new GridRequestSource(null, this));
    }

    public void setFormatAndColumns(@NotNull CsvFormat format, @Nullable List<DataConsumer.Column> columns) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "setFormatAndColumns"));
        }
        this.myParser = new CsvFormatParser(format);
        this.getLoader().reloadCurrentPage(new MyGridRequestSource(null, this, columns));
    }

    public void setColumns(@NotNull List<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "setColumns"));
        }
        this.getLoader().reloadCurrentPage(new MyGridRequestSource(null, this, columns));
    }

    @Override
    @Nullable
    protected CsvDocumentDataHookUp.CsvMarkup buildMarkup(@NotNull CharSequence sequence, @NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "buildMarkup"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ImportCsvDocumentDataHookUp", "buildMarkup"));
        }
        CsvDocumentDataHookUp.CsvMarkup markup = this.myParser.parse(sequence.toString());
        if (markup == null) {
            return null;
        }
        if (!(source instanceof MyGridRequestSource) || ((MyGridRequestSource)source).getColumns() == null) {
            return markup;
        }
        List<DataConsumer.Column> columns = ((MyGridRequestSource)source).getColumns();
        if (columns == null || columns.size() != markup.columns.size()) {
            return markup;
        }
        return new CsvDocumentDataHookUp.CsvMarkup(markup.getFormatter(), columns, markup.rows, markup.getRecords(), markup.getHeader());
    }

    private static class MyGridRequestSource
    extends GridRequestSource<DataConsumer.Row, DataConsumer.Column> {
        @Nullable
        private final List<DataConsumer.Column> myColumns;

        MyGridRequestSource(@Nullable DataGrid grid, @Nullable Object source, @Nullable List<DataConsumer.Column> columns) {
            super(grid, source);
            this.myColumns = columns;
        }

        @Nullable
        public List<DataConsumer.Column> getColumns() {
            return this.myColumns;
        }
    }
}

