/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BatchRecords {
    static final BatchRecords POISON = new BatchRecords();
    @Nullable
    private final List<String[]> myRecords;
    private final long myCharsCount;

    private BatchRecords() {
        this.myRecords = null;
        this.myCharsCount = 0L;
    }

    BatchRecords(@NotNull List<String[]> records, long charsCount) {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/BatchRecords", "<init>"));
        }
        this.myRecords = records;
        this.myCharsCount = charsCount;
    }

    @NotNull
    List<String[]> getRecords() {
        List list = (List)ObjectUtils.assertNotNull(this.myRecords);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/BatchRecords", "getRecords"));
        }
        return list;
    }

    int getLineCount() {
        return this.myRecords == null ? 0 : this.myRecords.size();
    }

    long getCharCount() {
        return this.myCharsCount;
    }
}

