/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.ui.CsvFormatForm;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dbimport.ExistingTableFormatMapper;
import com.intellij.database.dbimport.ImportDatabaseTableEditorWrapper;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportTablePreview;
import com.intellij.database.dbimport.NewTableFormatMapper;
import com.intellij.database.model.DasTable;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractTableFormatMapper
implements CsvFormatForm.ChangeListener {
    @NotNull
    protected final ImportTablePreview myPreview;
    @NotNull
    protected final ImportDatabaseTableEditorWrapper myEditor;
    @NotNull
    protected final CsvFormatsSelectionUI myFormats;
    @NotNull
    protected final DeModel myModel;
    @NotNull
    protected final Disposable myParent;
    private boolean adjusting;

    AbstractTableFormatMapper(@NotNull ImportTablePreview preview, @NotNull ImportDatabaseTableEditorWrapper editor, @NotNull CsvFormatsSelectionUI formats, @NotNull DeModel model, @NotNull Disposable parent) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/AbstractTableFormatMapper", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/AbstractTableFormatMapper", "<init>"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/AbstractTableFormatMapper", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/AbstractTableFormatMapper", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dbimport/AbstractTableFormatMapper", "<init>"));
        }
        this.myPreview = preview;
        this.myEditor = editor;
        this.myFormats = formats;
        this.myModel = model;
        this.myParent = parent;
    }

    public void connect() {
        this.myFormats.addFormatChangeListener(this, this.myParent);
        Disposer.register((Disposable)this.getDatabaseEditor(), (Disposable)this.createConnector());
    }

    public static void connect(@NotNull ImportTablePreview preview, @NotNull ImportDatabaseTableEditorWrapper editor, @NotNull CsvFormatsSelectionUI formats, @NotNull ImportManager manager, @NotNull DeModel model, @NotNull String name, @NotNull Disposable parent, @Nullable DeNamespace namespace, @Nullable DasTable table) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/AbstractTableFormatMapper", "connect"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/AbstractTableFormatMapper", "connect"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/AbstractTableFormatMapper", "connect"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/AbstractTableFormatMapper", "connect"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/AbstractTableFormatMapper", "connect"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/AbstractTableFormatMapper", "connect"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dbimport/AbstractTableFormatMapper", "connect"));
        }
        AbstractTableFormatMapper.getMapper(preview, editor, formats, manager, model, name, parent, namespace, table).connect();
    }

    @Override
    public final void formatChanged(@NotNull CsvFormatForm source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/AbstractTableFormatMapper", "formatChanged"));
        }
        this.run(() -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/AbstractTableFormatMapper", "lambda$formatChanged$0"));
            }
            this.onFormatChanged(source);
        });
    }

    @NotNull
    final DatabaseTableEditor getDatabaseEditor() {
        DatabaseTableEditor databaseTableEditor = (DatabaseTableEditor)ObjectUtils.assertNotNull((Object)this.myEditor.getEditor());
        if (databaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getDatabaseEditor"));
        }
        return databaseTableEditor;
    }

    final void init() {
        this.myEditor.setTable(this.createInitialTable());
    }

    void onShowNotify() {
        this.myPreview.setColumns(this.createColumnsFromEditor(), this.getDatabaseEditor().getTable().columns);
    }

    final void run(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dbimport/AbstractTableFormatMapper", "run"));
        }
        if (this.adjusting) {
            return;
        }
        try {
            this.adjusting = true;
            runnable.run();
        }
        finally {
            this.adjusting = false;
        }
    }

    final List<DataConsumer.Column> createColumnsFromEditor() {
        return this.createColumns(this.getDatabaseEditor().getTable());
    }

    protected List<DataConsumer.Column> createColumns(@NotNull DeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/AbstractTableFormatMapper", "createColumns"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        List<DeColumn> deColumns = table.columns;
        for (int i2 = 0; i2 < deColumns.size(); ++i2) {
            DeColumn column = deColumns.get(i2);
            int type = JdbcUtil.guessJdbcTypeByName((String)column.dataType);
            result.add(new DataConsumer.Column(this.getColumnNumber(column, i2), column.name, type, column.dataType, ""));
        }
        return result;
    }

    private UiNotifyConnector createConnector() {
        return new UiNotifyConnector.Once((Component)this.getDatabaseEditor().getComponent(), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                AbstractTableFormatMapper.this.onShowNotify();
            }
        });
    }

    @NotNull
    private static AbstractTableFormatMapper getMapper(@NotNull ImportTablePreview preview, @NotNull ImportDatabaseTableEditorWrapper editor, @NotNull CsvFormatsSelectionUI formats, @NotNull ImportManager manager, @NotNull DeModel model, @NotNull String name, @NotNull Disposable parent, @Nullable DeNamespace namespace, @Nullable DasTable table) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        AbstractTableFormatMapper abstractTableFormatMapper = table != null ? new ExistingTableFormatMapper(preview, editor, formats, table, model, parent) : new NewTableFormatMapper(preview, editor, formats, manager, model, name, namespace, parent);
        if (abstractTableFormatMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/AbstractTableFormatMapper", "getMapper"));
        }
        return abstractTableFormatMapper;
    }

    abstract void onFormatChanged(@NotNull CsvFormatForm var1);

    @NotNull
    abstract DeTable createInitialTable();

    abstract int getColumnNumber(@NotNull DeColumn var1, int var2);
}

