/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.mutating.ColumnUpdateData;
import com.intellij.database.datagrid.mutating.Mutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CellMutation
extends Mutation {
    private final ModelIndex<DataConsumer.Column> myColumn;
    private final Object myNewValue;

    public CellMutation(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object newValue) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/mutating/CellMutation", "<init>"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/mutating/CellMutation", "<init>"));
        }
        this(row, column, MutationType.MODIFY, newValue);
    }

    public CellMutation(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull MutationType type, @Nullable Object newValue) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/mutating/CellMutation", "<init>"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/mutating/CellMutation", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/mutating/CellMutation", "<init>"));
        }
        super(type, row);
        this.myColumn = column;
        this.myNewValue = newValue;
    }

    public boolean canMergeByRowWith(@NotNull CellMutation mutation) {
        if (mutation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutation", "com/intellij/database/datagrid/mutating/CellMutation", "canMergeByRowWith"));
        }
        return mutation.getRow().equals(this.getRow());
    }

    @Nullable
    public Object getValue() {
        return this.myNewValue;
    }

    @NotNull
    public ModelIndex<DataConsumer.Column> getColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = this.myColumn;
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/CellMutation", "getColumn"));
        }
        return modelIndex;
    }

    @Nullable
    public RowMutation createRowMutation(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/datagrid/mutating/CellMutation", "createRowMutation"));
        }
        DataConsumer.Column column = model.getColumn(this.myColumn);
        DataConsumer.Row row = model.getRow(this.getRow());
        return row == null || column == null ? null : new RowMutation(row, ContainerUtil.list((Object[])new ColumnUpdateData[]{new ColumnUpdateData(column, this.myNewValue)}));
    }

    public static class Builder {
        private ModelIndex<DataConsumer.Row> myRow;
        private ModelIndex<DataConsumer.Column> myColumn;
        private MutationType myType;
        private Object myValue;

        @NotNull
        public Builder row(@NotNull ModelIndex<DataConsumer.Row> row) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "row"));
            }
            this.myRow = row;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "row"));
            }
            return builder;
        }

        @NotNull
        public Builder column(@NotNull ModelIndex<DataConsumer.Column> column) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "column"));
            }
            this.myColumn = column;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "column"));
            }
            return builder;
        }

        @NotNull
        public Builder type(@NotNull MutationType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "type"));
            }
            this.myType = type;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "type"));
            }
            return builder;
        }

        @NotNull
        public Builder value(@Nullable Object value) {
            this.myValue = value;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "value"));
            }
            return builder;
        }

        @Nullable
        public ModelIndex<DataConsumer.Row> getRow() {
            return this.myRow;
        }

        @NotNull
        public CellMutation build() {
            CellMutation cellMutation = this.myType == null ? new CellMutation(this.myRow, this.myColumn, this.myValue) : new CellMutation(this.myRow, this.myColumn, this.myType, this.myValue);
            if (cellMutation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/CellMutation$Builder", "build"));
            }
            return cellMutation;
        }
    }
}

