/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.openapi.ui.MessageType;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationsColorLayer
implements ColorLayer {
    private final GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> myMutator;

    public MutationsColorLayer(@Nullable GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator) {
        this.myMutator = mutator;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/MutationsColorLayer", "getCellBackground"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/MutationsColorLayer", "getCellBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/MutationsColorLayer", "getCellBackground"));
        }
        MutationData mutation = this.myMutator == null ? null : this.myMutator.getMutation(row, column);
        MutationType type = mutation == null ? null : mutation.getType();
        return this.getColor(grid, type == null && this.myMutator != null && this.myMutator.isDeletedRow(row) ? MutationType.DELETE : type, color);
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/MutationsColorLayer", "getRowHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/MutationsColorLayer", "getRowHeaderBackground"));
        }
        MutationType type = this.myMutator == null ? null : this.myMutator.getMutationType(row);
        return this.getColor(grid, type, color);
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/MutationsColorLayer", "getColumnHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/MutationsColorLayer", "getColumnHeaderBackground"));
        }
        return color;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Nullable
    private Color getColor(@NotNull DataGrid grid, @Nullable MutationType type, @Nullable Color oldColor) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/MutationsColorLayer", "getColor"));
        }
        CellAttributes attributes = type == null ? null : grid.getColorsScheme().getAttributes(type.getKey());
        Color bg = attributes == null ? null : attributes.getBackgroundColor();
        return this.maybeFailed(bg, oldColor);
    }

    @Nullable
    private Color maybeFailed(@Nullable Color newColor, @Nullable Color oldColor) {
        return newColor == null ? oldColor : (this.myMutator != null && this.myMutator.isFailed() ? MutationsColorLayer.getFailedToInsertColor() : newColor);
    }

    @NotNull
    private static Color getFailedToInsertColor() {
        Color color = MessageType.ERROR.getPopupBackground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/color/MutationsColorLayer", "getFailedToInsertColor"));
        }
        return color;
    }
}

