/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IntIntFunction;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.DataAccessType;
import org.jetbrains.annotations.NotNull;

public abstract class ModelIndex<S>
extends Index {
    public static <RowType> ModelIndex<RowType> forRow(Grid<RowType, ?> grid, int row) {
        return ModelIndex.forRow(grid.getDataModel(DataAccessType.DATABASE_DATA), row);
    }

    public static <RowType> ModelIndex<RowType> forRow(GridModel<RowType, ?> model, int row) {
        return new Row(row);
    }

    public static <ColumnType> ModelIndex<ColumnType> forColumn(Grid<?, ColumnType> grid, int column) {
        return ModelIndex.forColumn(grid.getDataModel(DataAccessType.DATABASE_DATA), column);
    }

    public static <ColumnType> ModelIndex<ColumnType> forColumn(GridModel<?, ColumnType> model, int column) {
        return new Column(column);
    }

    private ModelIndex(int value) {
        super(value);
    }

    @NotNull
    public abstract ViewIndex<S> toView(@NotNull Grid<?, ?> var1);

    public abstract boolean isValid(@NotNull GridModel<?, ?> var1);

    public boolean isValid(@NotNull Grid<?, ?> grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ModelIndex", "isValid"));
        }
        return this.isValid(grid.getDataModel(DataAccessType.DATABASE_DATA));
    }

    public String toString() {
        return "Model" + this.getClass().getSimpleName() + "{" + this.value + "}";
    }

    static IntIntFunction row2View(Grid<?, ?> grid) {
        return grid.getRawIndexConverter().row2View();
    }

    static IntIntFunction col2View(Grid<?, ?> grid) {
        return grid.getRawIndexConverter().column2View();
    }

    private static class Row<RowType>
    extends ModelIndex<RowType> {
        Row(int value) {
            super(value);
        }

        @Override
        @NotNull
        public ViewIndex<RowType> toView(@NotNull Grid<?, ?> grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ModelIndex$Row", "toView"));
            }
            ViewIndex<?> viewIndex = ViewIndex.forRow(grid, Row.row2View(grid).fun(this.value));
            if (viewIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/ModelIndex$Row", "toView"));
            }
            return viewIndex;
        }

        @Override
        public boolean isValid(@NotNull GridModel<?, ?> model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/datagrid/ModelIndex$Row", "isValid"));
            }
            return model.isValidRowIdx(this);
        }
    }

    private static class Column<ColumnType>
    extends ModelIndex<ColumnType> {
        Column(int value) {
            super(value);
        }

        @Override
        @NotNull
        public ViewIndex<ColumnType> toView(@NotNull Grid<?, ?> grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ModelIndex$Column", "toView"));
            }
            ViewIndex<?> viewIndex = ViewIndex.forColumn(grid, Column.col2View(grid).fun(this.value));
            if (viewIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/ModelIndex$Column", "toView"));
            }
            return viewIndex;
        }

        @Override
        public boolean isValid(@NotNull GridModel<?, ?> model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/datagrid/ModelIndex$Column", "isValid"));
            }
            return model.isValidColumnIdx(this);
        }
    }
}

