/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IdentityDataProducer
implements DataProducer {
    private final DataConsumer myConsumer;
    private final List<DataConsumer.Column> myColumns;
    private final List<DataConsumer.Row> myRows;
    private final int myResultSetIndex;

    public IdentityDataProducer(DataConsumer consumer, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows, int resultSetIndex) {
        this.myConsumer = consumer;
        this.myColumns = columns;
        this.myRows = rows;
        this.myResultSetIndex = resultSetIndex;
    }

    @Override
    public void processRequest(@NotNull DataRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/datagrid/IdentityDataProducer", "processRequest"));
        }
        DataRequest.QueryRequest request = (DataRequest.QueryRequest)r;
        DataConsumer consumer = request instanceof DataConsumer ? new DataConsumer.Composite(Arrays.asList(this.myConsumer, (DataConsumer)((Object)request))) : this.myConsumer;
        DataRequest.Context context = new DataRequest.Context(this, request, r.txMarker){

            @Override
            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/datagrid/IdentityDataProducer$1", "reportException"));
                }
                throw th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th);
            }
        };
        int rowNum = this.myRows.isEmpty() ? 0 : this.myRows.get((int)0).rowNum;
        try {
            consumer.setColumns(context, this.myResultSetIndex, this.myColumns.toArray(new DataConsumer.Column[this.myColumns.size()]), rowNum);
            this.doAddRows(context, consumer, this.myRows);
            consumer.afterLastRowAdded(context, this.myRows.size());
            r.getPromise().setResult(null);
        }
        catch (Exception e) {
            r.getPromise().setError((Throwable)e);
        }
    }

    protected void doAddRows(DataRequest.Context context, DataConsumer handler, List<DataConsumer.Row> rows) {
        handler.addRows(context, rows);
    }
}

