/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.openapi.Disposable;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridListModelBase<Row, Column>
implements GridModel<Row, Column> {
    private final EventDispatcher<GridModel.Listener> myDispatcher = EventDispatcher.create(GridModel.Listener.class);
    private List<Column> myColumns;
    private List<Row> myRows;
    private boolean myUpdatingNow;

    public GridListModelBase() {
        this(ContainerUtil.newArrayList(), ContainerUtil.newArrayList());
    }

    public GridListModelBase(List<Column> columns, List<Row> rows) {
        this.myColumns = columns;
        this.myRows = rows;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<Row> rowIdx, ModelIndex<Column> columnIdx) {
        Row row = this.getRow(rowIdx);
        Column column = this.getColumn(columnIdx);
        return row != null && column != null ? this.getValueAt(row, column) : null;
    }

    @Override
    @Nullable
    public Row getRow(@NotNull ModelIndex<Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/GridListModelBase", "getRow"));
        }
        return this.getRow(row.asInteger());
    }

    @Override
    @Nullable
    public Column getColumn(@NotNull ModelIndex<Column> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/GridListModelBase", "getColumn"));
        }
        return this.getColumn(column.asInteger());
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull ModelIndexSet<Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/GridListModelBase", "getRows"));
        }
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)rows.size());
        for (int rowIndex : rows.asArray()) {
            result.add(this.getRow(rowIndex));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridListModelBase", "getRows"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Column> getColumns(@NotNull ModelIndexSet<Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/GridListModelBase", "getColumns"));
        }
        List list = columns.asIterable().transform(this::getColumn).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridListModelBase", "getColumns"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Column> getColumns() {
        ImmutableList immutableList = ContainerUtil.immutableList(this.myColumns);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridListModelBase", "getColumns"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<Row> getRows() {
        ImmutableList immutableList = ContainerUtil.immutableList(this.myRows);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridListModelBase", "getRows"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    public ModelIndexSet<Column> getColumnIndices() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forColumns(this, GridListModelBase.range(0, this.getColumnCount()));
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridListModelBase", "getColumnIndices"));
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<Row> getRowIndices() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forRows(this, GridListModelBase.range(0, this.getRowCount()));
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridListModelBase", "getRowIndices"));
        }
        return modelIndexSet;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.myRows.size();
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myUpdatingNow;
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<Row> rowIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/datagrid/GridListModelBase", "isValidRowIdx"));
        }
        return GridListModelBase.isValidIdx(this.myRows, rowIdx.asInteger());
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/datagrid/GridListModelBase", "isValidColumnIdx"));
        }
        return GridListModelBase.isValidIdx(this.myColumns, columnIdx.asInteger());
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<Row, Column> l, @NotNull Disposable disposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/datagrid/GridListModelBase", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/datagrid/GridListModelBase", "addListener"));
        }
        this.myDispatcher.addListener(l, disposable);
    }

    @Nullable
    protected abstract Object getValueAt(@NotNull Row var1, @NotNull Column var2);

    protected abstract void setValueAt(@NotNull Row var1, @NotNull Column var2, @Nullable Object var3);

    protected abstract boolean rowsEqual(@NotNull Row var1, @NotNull Row var2);

    void setUpdatingNow(boolean updatingNow) {
        this.myUpdatingNow = updatingNow;
    }

    void setValueAt(@NotNull ModelIndexSet<Row> rowIndices, @NotNull ModelIndexSet<Column> columnIndices, @Nullable Object value) {
        if (rowIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/GridListModelBase", "setValueAt"));
        }
        if (columnIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/GridListModelBase", "setValueAt"));
        }
        int[] rows = rowIndices.asArray();
        int[] columns = columnIndices.asArray();
        if (!GridListModelBase.areAllIndicesValid(this.myRows, rows) || !GridListModelBase.areAllIndicesValid(this.myColumns, columns)) {
            return;
        }
        for (int row : rows) {
            for (int column : columns) {
                this.setValueAt(ObjectUtils.assertNotNull(this.getRow(row)), ObjectUtils.assertNotNull(this.getColumn(column)), value);
            }
        }
        this.cellsUpdated(rows, columns);
    }

    void setValueAt(@NotNull ModelIndex<Row> row, @NotNull ModelIndex<Column> column, @Nullable Object value) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/GridListModelBase", "setValueAt"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/GridListModelBase", "setValueAt"));
        }
        int rowId = row.asInteger();
        int colId = column.asInteger();
        if (!GridListModelBase.areAllIndicesValid(this.myRows, rowId) || !GridListModelBase.areAllIndicesValid(this.myColumns, colId)) {
            return;
        }
        this.setValueAt(ObjectUtils.assertNotNull(this.getRow(rowId)), ObjectUtils.assertNotNull(this.getColumn(colId)), value);
        this.cellUpdated(rowId, colId);
    }

    void setRows(int firstRowIndex, @NotNull List<? extends Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/GridListModelBase", "setRows"));
        }
        int firstChangedRowIndex = -1;
        int rowsUpdated = 0;
        for (int i2 = firstRowIndex; i2 < this.myRows.size() && rowsUpdated < rows.size(); ++i2, ++rowsUpdated) {
            Row oldRow = this.myRows.get(i2);
            Row newRow = rows.get(rowsUpdated);
            this.myRows.set(i2, newRow);
            if (this.rowsEqual(oldRow, newRow)) {
                if (firstChangedRowIndex != -1) {
                    this.cellsUpdated(GridListModelBase.range(firstChangedRowIndex, i2 - firstChangedRowIndex), GridListModelBase.range(0, this.getColumnCount()));
                }
                firstChangedRowIndex = -1;
                continue;
            }
            if (firstChangedRowIndex != -1) continue;
            firstChangedRowIndex = i2;
        }
        if (firstChangedRowIndex != -1) {
            this.cellsUpdated(GridListModelBase.range(firstChangedRowIndex, firstRowIndex + rowsUpdated - firstChangedRowIndex), GridListModelBase.range(0, this.getColumnCount()));
        }
        this.addRows(ContainerUtil.subList(rows, (int)rowsUpdated));
    }

    void addRows(@NotNull List<? extends Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/GridListModelBase", "addRows"));
        }
        int firstRow = this.myRows.size();
        this.myRows.addAll(rows);
        this.rowsAdded(GridListModelBase.range(firstRow, rows.size()));
    }

    void removeRows(@NotNull ModelIndexSet<Row> rowIndices) {
        if (rowIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/GridListModelBase", "removeRows"));
        }
        GridListModelBase.remove(this.myRows, rowIndices, (Consumer<int[]>)((Consumer)this::rowsRemoved));
    }

    void removeRows(int firstRowIndex, int rowCount) {
        GridListModelBase.removeRange(this.myRows, firstRowIndex, rowCount);
        this.rowsRemoved(GridListModelBase.range(firstRowIndex, rowCount));
    }

    void setColumns(@NotNull List<? extends Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/GridListModelBase", "setColumns"));
        }
        int oldColumnCount = this.getColumnCount();
        int newColumnCount = columns.size();
        this.myColumns = ContainerUtil.newArrayListWithCapacity((int)newColumnCount);
        this.columnsRemoved(GridListModelBase.range(0, oldColumnCount));
        this.myColumns.addAll(columns);
        this.columnsAdded(GridListModelBase.range(0, newColumnCount));
    }

    void setColumns(int firstColumnIndex, @NotNull List<? extends Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/GridListModelBase", "setColumns"));
        }
        this.removeColumns(firstColumnIndex, Math.min(this.myColumns.size() - firstColumnIndex, columns.size()));
        this.addColumns(columns);
    }

    void removeColumns(@NotNull ModelIndexSet<Column> columnIndices) {
        if (columnIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/GridListModelBase", "removeColumns"));
        }
        GridListModelBase.remove(this.myColumns, columnIndices, (Consumer<int[]>)((Consumer)this::columnsRemoved));
    }

    void removeColumns(int firstColumnIndex, int columnCount) {
        GridListModelBase.removeRange(this.myColumns, firstColumnIndex, columnCount);
        this.columnsRemoved(GridListModelBase.range(firstColumnIndex, columnCount));
    }

    void addColumns(@NotNull List<? extends Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/GridListModelBase", "addColumns"));
        }
        int oldColumnCount = this.getColumnCount();
        this.myColumns.addAll(columns);
        this.columnsAdded(GridListModelBase.range(oldColumnCount, columns.size()));
    }

    private void cellUpdated(int row, int column) {
        this.cellsUpdated(new int[]{row}, new int[]{column});
    }

    private void cellsUpdated(int[] rows, int[] columns) {
        if (rows.length == 0 || columns.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).cellsUpdated(ModelIndexSet.forRows(this, rows), ModelIndexSet.forColumns(this, columns));
    }

    private void rowsAdded(int ... rows) {
        if (rows.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsAdded(ModelIndexSet.forRows(this, rows));
    }

    private void rowsRemoved(int ... rows) {
        if (rows.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsRemoved(ModelIndexSet.forRows(this, rows));
    }

    private void columnsAdded(int ... columns) {
        if (columns.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsAdded(ModelIndexSet.forColumns(this, columns));
    }

    private void columnsRemoved(int ... columns) {
        if (columns.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsRemoved(ModelIndexSet.forColumns(this, columns));
    }

    private Row getRow(int rowIdx) {
        return GridListModelBase.isValidIdx(this.myRows, rowIdx) ? (Row)this.myRows.get(rowIdx) : null;
    }

    private Column getColumn(int columnIdx) {
        return GridListModelBase.isValidIdx(this.myColumns, columnIdx) ? (Column)this.myColumns.get(columnIdx) : null;
    }

    private static boolean isValidIdx(@NotNull List<?> list, int idx) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/datagrid/GridListModelBase", "isValidIdx"));
        }
        return idx > -1 && idx < list.size();
    }

    private static boolean areAllIndicesValid(@NotNull List<?> list, int ... indices) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/datagrid/GridListModelBase", "areAllIndicesValid"));
        }
        for (int idx : indices) {
            if (GridListModelBase.isValidIdx(list, idx)) continue;
            return false;
        }
        return true;
    }

    private static int[] range(int first, int length) {
        int[] range = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            range[i2] = first + i2;
        }
        return range;
    }

    private static void removeRange(List<?> list, int firstIdx, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            list.remove(firstIdx + count - i2 - 1);
        }
    }

    private static void remove(List<?> items, ModelIndexSet<?> indexSet, Consumer<int[]> removedRangeConsumer) {
        int[] indicesArray = indexSet.asArray();
        Arrays.sort(indicesArray);
        int contiguousRangeEndIdx = indicesArray.length;
        for (int i2 = indicesArray.length - 2; i2 >= -1; --i2) {
            int contiguousRangeStartIdx = i2 + 1;
            int firstInRange = indicesArray[contiguousRangeStartIdx];
            if (i2 >= 0 && indicesArray[i2] + 1 == firstInRange) continue;
            int count = contiguousRangeEndIdx - contiguousRangeStartIdx;
            GridListModelBase.removeRange(items, firstInRange, count);
            removedRangeConsumer.consume((Object)GridListModelBase.range(firstInRange, count));
            contiguousRangeEndIdx = contiguousRangeStartIdx;
        }
    }
}

