/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.util.DbImplUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridListModel
extends GridListModelBase<DataConsumer.Row, DataConsumer.Column> {
    @Override
    @Nullable
    protected Object getValueAt(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DataGridListModel", "getValueAt"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/DataGridListModel", "getValueAt"));
        }
        return column.getValue(row);
    }

    @Override
    protected void setValueAt(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @Nullable Object value) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DataGridListModel", "setValueAt"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/DataGridListModel", "setValueAt"));
        }
        column.setValue(row, value);
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object what) {
        if (rowIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/DataGridListModel", "allValuesEqualTo"));
        }
        if (columnIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/DataGridListModel", "allValuesEqualTo"));
        }
        for (ModelIndex rowIdx : rowIndices.asIterable()) {
            for (ModelIndex colIdx : columnIndices.asIterable()) {
                if (DbImplUtil.isComputedColumn((DataConsumer.Column)this.getColumn(colIdx)) || DbImplUtil.valuesEqual(what, ((GridListModelBase)this).getValueAt(rowIdx, colIdx))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean allValuesEqualTo(@NotNull List<CellMutation> mutations) {
        if (mutations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutations", "com/intellij/database/datagrid/DataGridListModel", "allValuesEqualTo"));
        }
        for (CellMutation mutation : mutations) {
            ModelIndex<DataConsumer.Row> row = mutation.getRow();
            ModelIndex<DataConsumer.Column> column = mutation.getColumn();
            Object value = mutation.getValue();
            Object oldValue = ((GridListModelBase)this).getValueAt(row, column);
            if (DbImplUtil.isComputedColumn(this.getColumn(column)) || DbImplUtil.valuesEqual(value, oldValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean rowsEqual(@NotNull DataConsumer.Row row1, @NotNull DataConsumer.Row row2) {
        if (row1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row1", "com/intellij/database/datagrid/DataGridListModel", "rowsEqual"));
        }
        if (row2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row2", "com/intellij/database/datagrid/DataGridListModel", "rowsEqual"));
        }
        return Arrays.equals(row1.values, row2.values);
    }
}

