/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatParser {
    private final CsvFormat myDataFormat;
    private final Map<Object, Pattern> myCompiledPatterns;
    private LookAhead myLookAhead;

    public CsvFormatParser(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/CsvFormatParser", "<init>"));
        }
        this.myCompiledPatterns = ContainerUtil.newIdentityHashMap();
        this.myDataFormat = format;
    }

    public CsvFormat getDataFormat() {
        return this.myDataFormat;
    }

    @NotNull
    static List<String> values(final @NotNull CharSequence sequence, @NotNull List<CsvDocumentDataHookUp.ValueRange> ranges) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser", "values"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/datagrid/CsvFormatParser", "values"));
        }
        List list = ContainerUtil.map(ranges, (Function)new Function<CsvDocumentDataHookUp.ValueRange, String>(){

            public String fun(CsvDocumentDataHookUp.ValueRange range) {
                return range.value(sequence).toString();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvFormatParser", "values"));
        }
        return list;
    }

    @Nullable
    public CsvDocumentDataHookUp.CsvMarkup parse(CharSequence sequence) {
        CsvDocumentDataHookUp.CsvRecord record;
        this.myLookAhead = new LookAhead();
        List<String> columnNames = null;
        CsvDocumentDataHookUp.CsvRecord headerRow = null;
        ArrayList rows = ContainerUtil.newArrayList();
        int currentOffset = 0;
        if (this.myDataFormat.headerRecord != null) {
            CsvDocumentDataHookUp.CsvRecord headerRecord = this.parseRecordSkippingLines(sequence, currentOffset, this.myDataFormat.headerRecord, this.myDataFormat.rowNumbers);
            if (headerRecord == null) {
                return null;
            }
            headerRow = headerRecord;
            columnNames = CsvFormatParser.values(sequence, headerRecord.values);
            currentOffset = headerRecord.range.getEndOffset();
        }
        while ((record = this.parseRecordSkippingLines(sequence, currentOffset, this.myDataFormat.dataRecord, this.myDataFormat.rowNumbers)) != null) {
            if (columnNames == null) {
                columnNames = CsvFormatParser.values(sequence, record.values);
            }
            if (columnNames.size() != record.values.size()) {
                currentOffset = CsvFormatParser.skipLine(sequence, currentOffset);
                continue;
            }
            currentOffset = record.range.getEndOffset();
            rows.add(record);
        }
        return columnNames == null ? null : new CsvDocumentDataHookUp.CsvMarkup(new CsvFormatter(this.myDataFormat), sequence, rows, headerRow, this.myDataFormat.rowNumbers);
    }

    private CsvDocumentDataHookUp.CsvRecord parseRecordSkippingLines(CharSequence sequence, int startOffset, CsvRecordFormat template, boolean firstColumnIsTitle) {
        CsvDocumentDataHookUp.CsvRecord record = null;
        while (startOffset < sequence.length() && (record = this.parseRecord(sequence, startOffset, template, firstColumnIsTitle)) == null) {
            startOffset = CsvFormatParser.skipLine(sequence, startOffset);
        }
        return record;
    }

    private CsvDocumentDataHookUp.CsvRecord parseRecord(CharSequence sequence, int startOffset, CsvRecordFormat template, boolean firstColumnIsTitle) {
        Ref titleAndValuesRef = Ref.create();
        int endOffset = startOffset;
        endOffset = StringUtil.isEmpty((String)template.prefix) ? endOffset : (StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.prefix) ? endOffset + template.prefix.length() : -1);
        int n = endOffset = endOffset == -1 ? -1 : this.parseValues((Ref<List<CsvDocumentDataHookUp.ValueRange>>)titleAndValuesRef, sequence, endOffset, template);
        int n2 = endOffset == -1 ? -1 : (StringUtil.isEmpty((String)template.suffix) ? endOffset : (endOffset = StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)template.suffix) ? endOffset + template.suffix.length() : -1));
        if (endOffset == -1) {
            return null;
        }
        boolean hasRecordSeparator = false;
        if (endOffset != sequence.length() && endOffset == this.myLookAhead.nextRecordSeparatorOffset(template, sequence, endOffset)) {
            endOffset += template.recordSeparator.length();
            hasRecordSeparator = true;
        }
        TextRange recordRange = new TextRange(startOffset, endOffset);
        List titleAndValues = (List)titleAndValuesRef.get();
        return firstColumnIsTitle && titleAndValues.size() < 2 ? null : new CsvDocumentDataHookUp.CsvRecord(recordRange, titleAndValues, hasRecordSeparator);
    }

    private int parseValues(Ref<List<CsvDocumentDataHookUp.ValueRange>> valuesRef, CharSequence sequence, int startOffset, CsvRecordFormat template) {
        assert (valuesRef.isNull());
        int valuesEndOffset = startOffset;
        ArrayList values = ContainerUtil.newArrayList();
        Ref valueRef = Ref.create();
        boolean first = true;
        while (valuesEndOffset != this.myLookAhead.valuesEndOffset(template, sequence, valuesEndOffset)) {
            int valueEndOffset;
            if (!first) {
                if (valuesEndOffset != this.myLookAhead.nextValueSeparatorOffset(template, sequence, valuesEndOffset)) {
                    return -1;
                }
                valuesEndOffset += template.valueSeparator.length();
            }
            if ((valueEndOffset = this.parseValue((Ref<CsvDocumentDataHookUp.ValueRange>)valueRef, sequence, valuesEndOffset, template)) == -1) {
                return -1;
            }
            values.add(ObjectUtils.assertNotNull((Object)valueRef.get()));
            valuesEndOffset = valueEndOffset;
            first = false;
        }
        if (values.isEmpty()) {
            return -1;
        }
        valuesRef.set((Object)values);
        return valuesEndOffset;
    }

    private int parseValue(Ref<CsvDocumentDataHookUp.ValueRange> value, CharSequence sequence, int startOffset, CsvRecordFormat template) {
        int endOffset;
        int valueStartOffset = endOffset = template.trimWhitespace ? this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, startOffset) : startOffset;
        CsvRecordFormat.Quotes detectedQuotes = null;
        for (CsvRecordFormat.Quotes quotes : template.quotes) {
            if (!StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)quotes.leftQuote)) continue;
            detectedQuotes = quotes;
            break;
        }
        if (detectedQuotes == null) {
            int valueEndOffset;
            endOffset = valueEndOffset = this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, valueStartOffset);
            while (template.trimWhitespace && valueEndOffset > valueStartOffset && Character.isWhitespace(sequence.charAt(valueEndOffset - 1))) {
                --valueEndOffset;
            }
            value.set((Object)new CsvDocumentDataHookUp.ValueRange(valueStartOffset, valueEndOffset));
        } else {
            int valueEndOffset;
            Matcher matcher = this.allInQuotesPattern(detectedQuotes).matcher(sequence);
            boolean matched = matcher.find(valueStartOffset + detectedQuotes.leftQuote.length());
            assert (matched);
            endOffset = valueEndOffset = matcher.end(0);
            if (StringUtil.startsWith((CharSequence)sequence, (int)valueEndOffset, (CharSequence)detectedQuotes.rightQuote)) {
                endOffset = valueEndOffset += detectedQuotes.rightQuote.length();
                value.set((Object)new QuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
            } else {
                if (sequence.length() != endOffset) {
                    return -1;
                }
                value.set((Object)new ImproperQuotedValueRange(valueStartOffset, valueEndOffset, detectedQuotes));
            }
            if (template.trimWhitespace) {
                endOffset = this.skipWhitespaceUpToNextDelimiterOrRecordSeparator(template, sequence, endOffset);
            }
        }
        assert (!value.isNull());
        return endOffset;
    }

    @NotNull
    private Pattern allInQuotesPattern(@NotNull CsvRecordFormat.Quotes quotes) {
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvFormatParser", "allInQuotesPattern"));
        }
        Pattern pattern = this.myCompiledPatterns.get(quotes);
        if (pattern == null) {
            pattern = Pattern.compile("(?:" + Pattern.quote(quotes.rightQuoteEscaped) + "|(?!" + Pattern.quote(quotes.rightQuote) + ").)*+", 32);
            this.myCompiledPatterns.put(quotes, pattern);
        }
        Pattern pattern2 = pattern;
        if (pattern2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/CsvFormatParser", "allInQuotesPattern"));
        }
        return pattern2;
    }

    private int skipWhitespaceUpToNextDelimiterOrRecordSeparator(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvFormatParser", "skipWhitespaceUpToNextDelimiterOrRecordSeparator"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser", "skipWhitespaceUpToNextDelimiterOrRecordSeparator"));
        }
        return CsvFormatParser.skipWhitespace(sequence, offset, this.myLookAhead.nextDelimiterOrRecordSeparatorOffset(template, sequence, offset));
    }

    private static String unescapeQuotes(CharSequence s, CsvRecordFormat.Quotes quotes) {
        String[] escapedQuotes = new String[]{quotes.leftQuoteEscaped, quotes.rightQuoteEscaped};
        String[] unescapedQuotes = new String[]{quotes.leftQuote, quotes.rightQuote};
        return StringUtil.replace((String)String.valueOf(s), (String[])escapedQuotes, (String[])unescapedQuotes);
    }

    private static int skipWhitespace(CharSequence sequence, int offset, int maxOffset) {
        maxOffset = Math.min(maxOffset, sequence.length());
        while (offset < maxOffset && Character.isWhitespace(sequence.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    private static int skipLine(CharSequence sequence, int offset) {
        while (offset < sequence.length() && sequence.charAt(offset) != '\n') {
            ++offset;
        }
        if (offset < sequence.length()) {
            ++offset;
        }
        return offset;
    }

    private static class LookAhead {
        private int myNextRecordSeparatorRequestOffset = -1;
        private int myNextRecordSeparatorOffset = -1;

        private LookAhead() {
        }

        public int nextDelimiterOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextDelimiterOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextDelimiterOffset"));
            }
            int nextPartOffset = this.valuesEndOffset(template, sequence, startOffset);
            int nextValueSeparatorOffset = this.nextValueSeparatorOffset(template, sequence, startOffset);
            return Math.min(nextPartOffset, nextValueSeparatorOffset);
        }

        public int valuesEndOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "valuesEndOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "valuesEndOffset"));
            }
            String suffix = StringUtil.notNullize((String)template.suffix);
            String suffixAndSeparator = suffix + StringUtil.notNullize((String)template.recordSeparator);
            int suffixAndSeparatorIdx = LookAhead.indexOfOrEnd(sequence, startOffset, suffixAndSeparator);
            return suffixAndSeparatorIdx != sequence.length() ? suffixAndSeparatorIdx : (startOffset <= sequence.length() - suffix.length() && StringUtil.endsWith((CharSequence)sequence, (CharSequence)suffix) ? sequence.length() - suffix.length() : sequence.length());
        }

        public int nextRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextRecordSeparatorOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextRecordSeparatorOffset"));
            }
            if (startOffset >= this.myNextRecordSeparatorRequestOffset && startOffset <= this.myNextRecordSeparatorOffset) {
                return this.myNextRecordSeparatorOffset;
            }
            this.myNextRecordSeparatorRequestOffset = startOffset;
            this.myNextRecordSeparatorOffset = LookAhead.indexOfOrEnd(sequence, startOffset, template.recordSeparator);
            return this.myNextRecordSeparatorOffset;
        }

        public int nextValueSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int startOffset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextValueSeparatorOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextValueSeparatorOffset"));
            }
            return LookAhead.indexOfOrEnd(sequence, startOffset, template.valueSeparator);
        }

        public int nextDelimiterOrRecordSeparatorOffset(@NotNull CsvRecordFormat template, @NotNull CharSequence sequence, int offset) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextDelimiterOrRecordSeparatorOffset"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "nextDelimiterOrRecordSeparatorOffset"));
            }
            int nextDelimiterOffset = this.nextDelimiterOffset(template, sequence, offset);
            if (nextDelimiterOffset == offset) {
                return nextDelimiterOffset;
            }
            int recordSeparatorOffset = this.nextRecordSeparatorOffset(template, sequence, offset);
            return Math.min(nextDelimiterOffset, recordSeparatorOffset);
        }

        private static int indexOfOrEnd(@NotNull CharSequence sequence, int start, @Nullable CharSequence infix) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/CsvFormatParser$LookAhead", "indexOfOrEnd"));
            }
            int idx = StringUtil.isEmpty((CharSequence)infix) ? -1 : StringUtil.indexOf((CharSequence)sequence, (CharSequence)infix, (int)start);
            return idx == -1 ? sequence.length() : idx;
        }
    }

    private static class ImproperQuotedValueRange
    extends QuotedValueRange {
        public ImproperQuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvFormatParser$ImproperQuotedValueRange", "<init>"));
            }
            super(startOffset, endOffset, quotes);
        }

        @Override
        protected TextRange unquotedRange() {
            return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset());
        }
    }

    private static class QuotedValueRange
    extends CsvDocumentDataHookUp.ValueRange {
        protected final CsvRecordFormat.Quotes myQuotes;

        public QuotedValueRange(int startOffset, int endOffset, @NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/datagrid/CsvFormatParser$QuotedValueRange", "<init>"));
            }
            super(startOffset, endOffset);
            this.myQuotes = quotes;
        }

        @Override
        public CharSequence value(CharSequence s) {
            return CsvFormatParser.unescapeQuotes(this.unquotedRange().subSequence(s), this.myQuotes);
        }

        protected TextRange unquotedRange() {
            return new TextRange(this.getStartOffset() + this.myQuotes.leftQuote.length(), this.getEndOffset() - this.myQuotes.rightQuote.length());
        }
    }
}

