/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class SshDataSourceValidator
extends DatabaseConfigValidator.Typed<LocalDataSource> {
    public SshDataSourceValidator() {
        super(LocalDataSource.class);
    }

    @Override
    public void findProblemsTyped(@NotNull LocalDataSource dataSource, @NotNull Consumer<DataSourceProblem> problems, @NotNull DatabaseConfigValidator.Control control) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "findProblemsTyped"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "findProblemsTyped"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "findProblemsTyped"));
        }
        DataSourceSshTunnelConfiguration configuration = dataSource.getSshConfiguration();
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        String url = dataSource.getUrl();
        if (driver == null || StringUtil.isEmpty((String)url)) {
            return;
        }
        driver = control.actualize(driver, false);
        if (configuration == null || !configuration.isEnabled() || SshDataSourceValidator.isOk(driver, url)) {
            return;
        }
        String description = "Host & port not found. Fix URL or <a href=\"$ACTION0\">create template</a>";
        problems.consume((Object)new DataSourceProblem((Object)dataSource, this, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("Unable to apply SSH settings", description, description, new DataSourceProblem.NewUrlTemplate(driver, url)), null));
    }

    private static boolean isOk(@NotNull DatabaseDriver driver, @NotNull String url) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "isOk"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "isOk"));
        }
        return JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), url, null) != null;
    }
}

