/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecompositionNodes;
import com.intellij.database.dataSource.url.template.TextDecompositionUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDecomposition {
    private Boolean myMatched;
    private String myTextCache;
    private final Map<String, TextDecompositionNodes.Parameter> myParameters;
    private final StatelessTextDecomposition myStateless;
    private final TextDecompositionNodes.ListChoiceSNode myRoot;
    private List<TextRange> myInvalidRanges;
    private boolean myErroneous;

    @Nullable
    public TextRange getParameterRange(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/TextDecomposition", "getParameterRange"));
        }
        this.validateText();
        TextDecompositionNodes.Matchable matchable = (TextDecompositionNodes.Matchable)ObjectUtils.tryCast((Object)this.myParameters.get(name), TextDecompositionNodes.Matchable.class);
        return matchable != null && matchable.getFrom() != -1 ? TextRange.create((int)matchable.getFrom(), (int)matchable.getTo()) : null;
    }

    public void validateParameters() {
        this.validateText();
    }

    private static void collectParameters(@NotNull TextDecompositionNodes.SNode root2, final @NotNull Map<String, TextDecompositionNodes.Parameter> res) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecomposition", "collectParameters"));
        }
        if (res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "com/intellij/database/dataSource/url/template/TextDecomposition", "collectParameters"));
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                TextDecompositionNodes.Parameter param;
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$1", "visit"));
                }
                if (node instanceof TextDecompositionNodes.Parameter && (param = (TextDecompositionNodes.Parameter)((Object)node)).getName() != null) {
                    res.put(param.getName(), param);
                }
                node.visitChildren(this);
                return null;
            }
        }.visit(root2);
    }

    public TextDecomposition(@NotNull StatelessTextDecomposition decomposition) {
        if (decomposition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decomposition", "com/intellij/database/dataSource/url/template/TextDecomposition", "<init>"));
        }
        this.myStateless = decomposition;
        this.myRoot = TextDecompositionNodes.create(decomposition.getNode());
        this.myParameters = new HashMap<String, TextDecompositionNodes.Parameter>(1);
        TextDecomposition.collectParameters(this.myRoot, this.myParameters);
    }

    @NotNull
    public StatelessTextDecomposition getStateless() {
        StatelessTextDecomposition statelessTextDecomposition = this.myStateless;
        if (statelessTextDecomposition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecomposition", "getStateless"));
        }
        return statelessTextDecomposition;
    }

    public String getPattern() {
        return this.myRoot.getStateless().getPattern();
    }

    public boolean isValid() {
        if (this.myMatched == null) {
            this.myMatched = this.myRoot.getStateless().compilePattern().matcher(this.getText()).matches();
        }
        return this.myMatched;
    }

    public void setTextTolerantly(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecomposition", "setTextTolerantly"));
        }
        this.validateText();
        if (text.equals(this.myTextCache)) {
            return;
        }
        this.myTextCache = null;
        if (!this.matchCompletely(text)) {
            this.matchIncrementally(text);
        }
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecomposition", "setText"));
        }
        if (text.equals(this.myTextCache)) {
            return;
        }
        this.myTextCache = null;
        if (!this.matchCompletely(text)) {
            this.matchFailed(text);
        }
    }

    @NotNull
    public List<TextRange> getInvalidRanges() {
        this.validateText();
        List<TextRange> list = this.myInvalidRanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecomposition", "getInvalidRanges"));
        }
        return list;
    }

    @NotNull
    public String getText() {
        this.validateText();
        String string = this.myTextCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecomposition", "getText"));
        }
        return string;
    }

    @Nullable
    public String findProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/TextDecomposition", "findProperty"));
        }
        block0: for (TextDecompositionNodes.ListChoiceSNode node : ((JBTreeTraverser)TextDecompositionUtil.traverse(this.myRoot).expand(Conditions.alwaysTrue())).filter(TextDecompositionNodes.ListChoiceSNode.class)) {
            JBIterable leaves;
            if (node == this.myRoot || !(leaves = ((JBTreeTraverser)TextDecompositionUtil.traverse(node).expand(Conditions.alwaysTrue())).filter(TextDecompositionNodes.LeafSNode.class)).skip(3).isEmpty()) continue;
            int cnt = 0;
            for (TextDecompositionNodes.LeafSNode leaf : leaves) {
                if (++cnt == 1 && !StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)leaf.getText()) || cnt == 2 && !"=".equals(leaf.getText())) continue block0;
                if (cnt != 3) continue;
                return leaf.getText();
            }
        }
        return null;
    }

    public void setParameter(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/TextDecomposition", "setParameter"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dataSource/url/template/TextDecomposition", "setParameter"));
        }
        TextDecompositionNodes.Parameter param = this.myParameters.get(name);
        if (param == null || value.equals(param.getText())) {
            return;
        }
        param.setText(value);
        this.myErroneous = false;
        TextDecompositionUtil.purgeBadGroups(this.myRoot);
        this.myMatched = value.isEmpty() || param.getPattern().matcher(value).matches() ? null : Boolean.FALSE;
        this.myTextCache = null;
    }

    @Nullable
    public String getParameter(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/TextDecomposition", "getParameter"));
        }
        TextDecompositionNodes.Parameter node = this.myParameters.get(name);
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    private void validateText() {
        if (this.myTextCache == null) {
            this.checkOptionals();
            TextDecompositionUtil.resetDisabledMatchables(this.myRoot);
            StringBuilder builder = new StringBuilder();
            TextDecompositionUtil.buildText(builder, this.myRoot);
            this.myInvalidRanges = TextDecompositionUtil.extractBadRanges(this.myRoot);
            this.myTextCache = builder.toString();
        }
    }

    private void checkOptionals() {
        new TextDecompositionUtil.SimpleNodeVisitor<ThreeState>(){

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ParameterSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
                }
                return ThreeState.fromBoolean((!node.getText().isEmpty() || node.getBadGroup() != null ? 1 : 0) != 0);
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.TextSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
                }
                return node.getBadGroup() != null ? ThreeState.YES : ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.CompositeSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
                }
                ThreeState res = ThreeState.UNSURE;
                for (TextDecompositionNodes.SNode c : node.getChildren()) {
                    ThreeState tmp = (ThreeState)this.visit(c);
                    if (tmp == ThreeState.YES && res != ThreeState.NO) {
                        res = ThreeState.YES;
                        continue;
                    }
                    if (tmp != ThreeState.NO) continue;
                    res = ThreeState.NO;
                }
                return res;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.OptionalSNode node) {
                ThreeState res;
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
                }
                ThreeState threeState = res = node.getBadGroup() != null ? ThreeState.YES : (ThreeState)this.visit(node.getNode());
                if (res != ThreeState.UNSURE) {
                    node.setEnabled(node.isMatched() && TextDecomposition.this.myErroneous || res.toBoolean());
                } else {
                    node.setEnabled(node.isMatched());
                }
                return node.isEnabled() ? ThreeState.YES : ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.AntiSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
                }
                return ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ListSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
                }
                ThreeState res = ThreeState.NO;
                for (TextDecompositionNodes.ListChoiceSNode c : node.getMatches()) {
                    ThreeState tmp = this.visit(c);
                    if (tmp != ThreeState.YES) continue;
                    res = ThreeState.YES;
                }
                return res;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ListChoiceSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
                }
                ThreeState res = (ThreeState)this.visit(node.getRoot());
                if (res != ThreeState.UNSURE) {
                    node.setEnabled(node.isMatched() && TextDecomposition.this.myErroneous || res.toBoolean());
                } else {
                    node.setEnabled(node.isMatched());
                }
                return ThreeState.fromBoolean((boolean)node.isEnabled());
            }
        }.visit(this.myRoot);
        this.myRoot.setEnabled(true);
    }

    private boolean matchCompletely(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecomposition", "matchCompletely"));
        }
        Matcher matcher = this.myRoot.getStateless().compilePattern().matcher(text);
        boolean res = matcher.matches();
        if (res) {
            this.myRoot.setMatch(text);
        }
        this.myErroneous = !res;
        this.myMatched = res;
        return res;
    }

    private void matchIncrementally(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecomposition", "matchIncrementally"));
        }
        this.myRoot.matchIncrementally(text, null);
    }

    private void matchFailed(final @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TextDecomposition", "matchFailed"));
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){
            private final TextDecompositionNodes.BadGroup myBadGroup;
            {
                this.myBadGroup = new TextDecompositionNodes.BadGroup(text);
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$3", "visit"));
                }
                if (node instanceof TextDecompositionNodes.LeafSNode) {
                    ((TextDecompositionNodes.LeafSNode)node).setBadGroup(this.myBadGroup);
                }
                if (node instanceof TextDecompositionNodes.OptionalSNode) {
                    ((TextDecompositionNodes.OptionalSNode)node).setEnabled(false);
                    return null;
                }
                if (node instanceof TextDecompositionNodes.ListChoiceSNode && node != TextDecomposition.this.myRoot) {
                    ((TextDecompositionNodes.ListChoiceSNode)node).setEnabled(false);
                    return null;
                }
                node.visitChildren(this);
                return null;
            }
        }.visit(this.myRoot);
    }

    public static interface PatternFactory {
        @Nullable
        public Pattern getPattern(@NotNull String var1, @Nullable String var2);
    }
}

