/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TemplateJdbcUrlParser;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class StatelessTemplateJdbcUrlParser
extends StatelessParametersHolder.StatelessParametersHolderDelegate
implements StatelessJdbcUrlParser {
    private final String myName;
    private final StatelessTextDecomposition myDecomposition;
    private final EnumSet<StatelessJdbcUrlParser.LocationType> myPossibleLocations;

    public StatelessTemplateJdbcUrlParser(@NotNull String name, @NotNull StatelessTextDecomposition decomposition) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/StatelessTemplateJdbcUrlParser", "<init>"));
        }
        if (decomposition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decomposition", "com/intellij/database/dataSource/url/template/StatelessTemplateJdbcUrlParser", "<init>"));
        }
        this.myName = name;
        this.myDecomposition = decomposition;
        this.myPossibleLocations = EnumSet.noneOf(StatelessJdbcUrlParser.LocationType.class);
        if (this.getParameterType("host") != null) {
            this.myPossibleLocations.add(StatelessJdbcUrlParser.LocationType.REMOTE);
        }
        if (this.getParameterType("file") != null) {
            this.myPossibleLocations.add(StatelessJdbcUrlParser.LocationType.FILE);
        }
        if (this.getParameterType("path") != null) {
            this.myPossibleLocations.add(StatelessJdbcUrlParser.LocationType.DIRECTORY);
        }
    }

    @Override
    protected StatelessParametersHolder getParametersHolderDelegate() {
        return this.myDecomposition;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTemplateJdbcUrlParser", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public JdbcUrlParser createStatefull() {
        TemplateJdbcUrlParser templateJdbcUrlParser = new TemplateJdbcUrlParser(this);
        if (templateJdbcUrlParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTemplateJdbcUrlParser", "createStatefull"));
        }
        return templateJdbcUrlParser;
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getPossibleLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.myPossibleLocations;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTemplateJdbcUrlParser", "getPossibleLocations"));
        }
        return enumSet;
    }

    @Override
    public boolean isUrlValueValid(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/template/StatelessTemplateJdbcUrlParser", "isUrlValueValid"));
        }
        return this.myDecomposition.isTextValid(url);
    }

    @NotNull
    public StatelessTextDecomposition getDecomposition() {
        StatelessTextDecomposition statelessTextDecomposition = this.myDecomposition;
        if (statelessTextDecomposition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTemplateJdbcUrlParser", "getDecomposition"));
        }
        return statelessTextDecomposition;
    }
}

