/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.zipfs;

import com.intellij.database.dataSource.srcStorage.zipfs.ZipCoder;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipConstants;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileAttributes;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileStore;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystemProvider;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipPath;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipError;
import java.util.zip.ZipException;

public class ZipFileSystem
extends FileSystem {
    private final ZipFileSystemProvider provider;
    private final ZipPath defaultdir;
    private boolean readOnly = false;
    private final Path zfpath;
    private final ZipCoder zc;
    private final String defaultDir;
    private final String nameEncoding;
    private final boolean useTempFile;
    private final boolean createNew;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static final Set<String> supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "zip")));
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";
    private Set<InputStream> streams = Collections.synchronizedSet(new HashSet());
    private Set<ExChannelCloser> exChClosers = new HashSet<ExChannelCloser>();
    private Set<Path> tmppaths = Collections.synchronizedSet(new HashSet());
    private static byte[] ROOTPATH = new byte[0];
    private volatile boolean isOpen = true;
    private final SeekableByteChannel ch;
    final byte[] cen;
    private END end;
    private long locpos;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private LinkedHashMap<IndexNode, IndexNode> inodes;
    private boolean hasUpdate = false;
    private final IndexNode LOOKUPKEY = IndexNode.keyOf(null);
    private final int MAX_FLATER = 20;
    private final List<Inflater> inflaters = new ArrayList<Inflater>();
    private final List<Deflater> deflaters = new ArrayList<Deflater>();
    private IndexNode root;

    ZipFileSystem(ZipFileSystemProvider provider, Path zfpath, Map<String, ?> env) throws IOException {
        this.createNew = "true".equals(env.get("create"));
        this.nameEncoding = env.containsKey("encoding") ? (String)env.get("encoding") : "UTF-8";
        this.useTempFile = Boolean.TRUE.equals(env.get("useTempFile"));
        String string = this.defaultDir = env.containsKey("default.dir") ? (String)env.get("default.dir") : "/";
        if (this.defaultDir.charAt(0) != '/') {
            throw new IllegalArgumentException("default dir should be absolute");
        }
        this.provider = provider;
        this.zfpath = zfpath;
        if (Files.notExists(zfpath, new LinkOption[0])) {
            if (this.createNew) {
                try (OutputStream os = Files.newOutputStream(zfpath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    new END().write(os, 0L);
                }
            } else {
                throw new FileSystemNotFoundException(zfpath.toString());
            }
        }
        zfpath.getFileSystem().provider().checkAccess(zfpath, AccessMode.READ);
        if (!Files.isWritable(zfpath)) {
            this.readOnly = true;
        }
        this.zc = ZipCoder.get(this.nameEncoding);
        this.defaultdir = new ZipPath(this, this.getBytes(this.defaultDir));
        this.ch = Files.newByteChannel(zfpath, StandardOpenOption.READ);
        this.cen = this.initCEN();
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void checkWritable() throws IOException {
        if (this.readOnly) {
            throw new ReadOnlyFileSystemException();
        }
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ArrayList<Path> pathArr = new ArrayList<Path>();
        pathArr.add(new ZipPath(this, new byte[]{47}));
        return pathArr;
    }

    ZipPath getDefaultDir() {
        return this.defaultdir;
    }

    @Override
    public ZipPath getPath(String first, String ... more) {
        String path;
        if (more.length == 0) {
            path = first;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            for (String segment : more) {
                if (segment.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(segment);
            }
            path = sb.toString();
        }
        return new ZipPath(this, this.getBytes(path));
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    FileStore getFileStore(ZipPath path) {
        return new ZipFileStore(path);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        ArrayList<FileStore> list = new ArrayList<FileStore>(1);
        list.add(new ZipFileStore(new ZipPath(this, new byte[]{47})));
        return list;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    public String toString() {
        return this.zfpath.toString();
    }

    Path getZipFile() {
        return this.zfpath;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndInput) {
        String expr;
        int pos = syntaxAndInput.indexOf(58);
        if (pos <= 0 || pos == syntaxAndInput.length()) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        if (syntax.equals(GLOB_SYNTAX)) {
            expr = ZipUtils.toRegexPattern(input);
        } else if (syntax.equals(REGEX_SYNTAX)) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        final Pattern pattern = Pattern.compile(expr);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.beginWrite();
        try {
            if (!this.isOpen) {
                return;
            }
            this.isOpen = false;
        }
        finally {
            this.endWrite();
        }
        try {
            Collection<Object> copy;
            if (!this.streams.isEmpty()) {
                copy = new HashSet<InputStream>(this.streams);
                for (InputStream is : copy) {
                    is.close();
                }
            }
            this.beginWrite();
            try {
                this.sync();
                this.ch.close();
            }
            finally {
                this.endWrite();
            }
            copy = this.inflaters;
            synchronized (copy) {
                for (Inflater inf : this.inflaters) {
                    inf.end();
                }
            }
            copy = this.deflaters;
            synchronized (copy) {
                for (Deflater def : this.deflaters) {
                    def.end();
                }
            }
            IOException ioe = null;
            Set<Path> set = this.tmppaths;
            synchronized (set) {
                for (Path p : this.tmppaths) {
                    try {
                        Files.deleteIfExists(p);
                    }
                    catch (IOException x) {
                        if (ioe == null) {
                            ioe = x;
                            continue;
                        }
                        ioe.addSuppressed(x);
                    }
                }
            }
            if (ioe != null) {
                throw ioe;
            }
        }
        finally {
            this.provider.removeFileSystem(this.zfpath, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZipFileAttributes getFileAttributes(byte[] path) throws IOException {
        Entry e;
        this.beginRead();
        try {
            this.ensureOpen();
            e = this.getEntry0(path);
            if (e == null) {
                IndexNode inode = this.getInode(path);
                if (inode == null) {
                    ZipFileAttributes zipFileAttributes = null;
                    return zipFileAttributes;
                }
                e = new Entry(inode.name);
                e.method = 0;
                e.ctime = -1L;
                e.atime = -1L;
                e.mtime = -1L;
            }
        }
        finally {
            this.endRead();
        }
        return new ZipFileAttributes(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimes(byte[] path, FileTime mtime, FileTime atime, FileTime ctime) throws IOException {
        this.checkWritable();
        this.beginWrite();
        try {
            this.ensureOpen();
            Entry e = this.getEntry0(path);
            if (e == null) {
                throw new NoSuchFileException(this.getString(path));
            }
            if (e.type == 1) {
                e.type = 4;
            }
            if (mtime != null) {
                e.mtime = mtime.toMillis();
            }
            if (atime != null) {
                e.atime = atime.toMillis();
            }
            if (ctime != null) {
                e.ctime = ctime.toMillis();
            }
            this.update(e);
        }
        finally {
            this.endWrite();
        }
    }

    boolean exists(byte[] path) throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            boolean bl = this.getInode(path) != null;
            return bl;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirectory(byte[] path) throws IOException {
        this.beginRead();
        try {
            IndexNode n = this.getInode(path);
            boolean bl = n != null && n.isDir();
            return bl;
        }
        finally {
            this.endRead();
        }
    }

    private ZipPath toZipPath(byte[] path) {
        byte[] p = new byte[path.length + 1];
        p[0] = 47;
        System.arraycopy(path, 0, p, 1, path.length);
        return new ZipPath(this, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Path> iteratorOf(byte[] path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            IndexNode inode = this.getInode(path);
            if (inode == null) {
                throw new NotDirectoryException(this.getString(path));
            }
            ArrayList<ZipPath> list = new ArrayList<ZipPath>();
            IndexNode child = inode.child;
            while (child != null) {
                ZipPath zp = this.toZipPath(child.name);
                if (filter == null || filter.accept(zp)) {
                    list.add(zp);
                }
                child = child.sibling;
            }
            Iterator<Path> iterator = list.iterator();
            return iterator;
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDirectory(byte[] dir, FileAttribute<?> ... attrs) throws IOException {
        this.checkWritable();
        dir = ZipUtils.toDirectoryPath(dir);
        this.beginWrite();
        try {
            this.ensureOpen();
            if (dir.length == 0 || this.exists(dir)) {
                throw new FileAlreadyExistsException(this.getString(dir));
            }
            this.checkParents(dir);
            Entry e = new Entry(dir, 2);
            e.method = 0;
            this.update(e);
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyFile(boolean deletesrc, byte[] src, byte[] dst, CopyOption ... options) throws IOException {
        this.checkWritable();
        if (Arrays.equals(src, dst)) {
            return;
        }
        this.beginWrite();
        try {
            this.ensureOpen();
            Entry eSrc = this.getEntry0(src);
            if (eSrc == null) {
                throw new NoSuchFileException(this.getString(src));
            }
            if (eSrc.isDir()) {
                this.createDirectory(dst, new FileAttribute[0]);
                return;
            }
            boolean hasReplace = false;
            boolean hasCopyAttrs = false;
            for (CopyOption opt : options) {
                if (opt == StandardCopyOption.REPLACE_EXISTING) {
                    hasReplace = true;
                    continue;
                }
                if (opt != StandardCopyOption.COPY_ATTRIBUTES) continue;
                hasCopyAttrs = true;
            }
            Entry eDst = this.getEntry0(dst);
            if (eDst != null) {
                if (!hasReplace) {
                    throw new FileAlreadyExistsException(this.getString(dst));
                }
            } else {
                this.checkParents(dst);
            }
            Entry u = new Entry(eSrc, 4);
            u.name(dst);
            if (eSrc.type == 2 || eSrc.type == 3) {
                u.type = eSrc.type;
                if (deletesrc) {
                    u.bytes = eSrc.bytes;
                    u.file = eSrc.file;
                } else if (eSrc.bytes != null) {
                    u.bytes = Arrays.copyOf(eSrc.bytes, eSrc.bytes.length);
                } else if (eSrc.file != null) {
                    u.file = this.getTempPathForEntry(null);
                    Files.copy(eSrc.file, u.file, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            if (!hasCopyAttrs) {
                u.atime = u.ctime = System.currentTimeMillis();
                u.mtime = u.ctime;
            }
            this.update(u);
            if (deletesrc) {
                this.updateDelete(eSrc);
            }
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream newOutputStream(byte[] path, OpenOption ... options) throws IOException {
        this.checkWritable();
        boolean hasCreateNew = false;
        boolean hasCreate = false;
        boolean hasAppend = false;
        for (OpenOption opt : options) {
            if (opt == StandardOpenOption.READ) {
                throw new IllegalArgumentException("READ not allowed");
            }
            if (opt == StandardOpenOption.CREATE_NEW) {
                hasCreateNew = true;
            }
            if (opt == StandardOpenOption.CREATE) {
                hasCreate = true;
            }
            if (opt != StandardOpenOption.APPEND) continue;
            hasAppend = true;
        }
        this.beginRead();
        try {
            this.ensureOpen();
            Entry e = this.getEntry0(path);
            if (e != null) {
                if (e.isDir() || hasCreateNew) {
                    throw new FileAlreadyExistsException(this.getString(path));
                }
                if (hasAppend) {
                    InputStream is = this.getInputStream(e);
                    OutputStream os = this.getOutputStream(new Entry(e, 2));
                    ZipFileSystem.copyStream(is, os);
                    is.close();
                    OutputStream outputStream = os;
                    return outputStream;
                }
                OutputStream outputStream = this.getOutputStream(new Entry(e, 2));
                return outputStream;
            }
            if (!hasCreate && !hasCreateNew) {
                throw new NoSuchFileException(this.getString(path));
            }
            this.checkParents(path);
            OutputStream outputStream = this.getOutputStream(new Entry(path, 2));
            return outputStream;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream newInputStream(byte[] path) throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            Entry e = this.getEntry0(path);
            if (e == null) {
                throw new NoSuchFileException(this.getString(path));
            }
            if (e.isDir()) {
                throw new FileSystemException(this.getString(path), "is a directory", null);
            }
            InputStream inputStream = this.getInputStream(e);
            return inputStream;
        }
        finally {
            this.endRead();
        }
    }

    private void checkOptions(Set<? extends OpenOption> options) {
        for (OpenOption openOption : options) {
            if (openOption == null) {
                throw new NullPointerException();
            }
            if (openOption instanceof StandardOpenOption) continue;
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SeekableByteChannel newByteChannel(byte[] path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        this.checkOptions(options);
        if (options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND)) {
            this.checkWritable();
            this.beginRead();
            try {
                Entry e;
                final WritableByteChannel wbc = Channels.newChannel(this.newOutputStream(path, options.toArray(new OpenOption[0])));
                long leftover = 0L;
                if (options.contains(StandardOpenOption.APPEND) && (e = this.getEntry0(path)) != null && e.size >= 0L) {
                    leftover = e.size;
                }
                final long offset = leftover;
                SeekableByteChannel seekableByteChannel = new SeekableByteChannel(){
                    long written;
                    {
                        this.written = offset;
                    }

                    @Override
                    public boolean isOpen() {
                        return wbc.isOpen();
                    }

                    @Override
                    public long position() throws IOException {
                        return this.written;
                    }

                    @Override
                    public SeekableByteChannel position(long pos) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int read(ByteBuffer dst) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public SeekableByteChannel truncate(long size) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int write(ByteBuffer src) throws IOException {
                        int n = wbc.write(src);
                        this.written += (long)n;
                        return n;
                    }

                    @Override
                    public long size() throws IOException {
                        return this.written;
                    }

                    @Override
                    public void close() throws IOException {
                        wbc.close();
                    }
                };
                return seekableByteChannel;
            }
            finally {
                this.endRead();
            }
        }
        this.beginRead();
        try {
            this.ensureOpen();
            Entry e = this.getEntry0(path);
            if (e == null || e.isDir()) {
                throw new NoSuchFileException(this.getString(path));
            }
            final ReadableByteChannel rbc = Channels.newChannel(this.getInputStream(e));
            final long size = e.size;
            SeekableByteChannel seekableByteChannel = new SeekableByteChannel(){
                long read = 0L;

                @Override
                public boolean isOpen() {
                    return rbc.isOpen();
                }

                @Override
                public long position() throws IOException {
                    return this.read;
                }

                @Override
                public SeekableByteChannel position(long pos) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    int n = rbc.read(dst);
                    if (n > 0) {
                        this.read += (long)n;
                    }
                    return n;
                }

                @Override
                public SeekableByteChannel truncate(long size2) throws IOException {
                    throw new NonWritableChannelException();
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    throw new NonWritableChannelException();
                }

                @Override
                public long size() throws IOException {
                    return size;
                }

                @Override
                public void close() throws IOException {
                    rbc.close();
                }
            };
            return seekableByteChannel;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileChannel newFileChannel(byte[] path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        this.checkOptions(options);
        final boolean forWrite = options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND);
        this.beginRead();
        try {
            Entry u;
            this.ensureOpen();
            Entry e = this.getEntry0(path);
            if (forWrite) {
                this.checkWritable();
                if (e == null) {
                    if (!options.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new NoSuchFileException(this.getString(path));
                    }
                } else {
                    if (options.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new FileAlreadyExistsException(this.getString(path));
                    }
                    if (e.isDir()) {
                        throw new FileAlreadyExistsException("directory <" + this.getString(path) + "> exists");
                    }
                }
                options.remove(StandardOpenOption.CREATE_NEW);
            } else if (e == null || e.isDir()) {
                throw new NoSuchFileException(this.getString(path));
            }
            final boolean isFCH = e != null && e.type == 3;
            final Path tmpfile = isFCH ? e.file : this.getTempPathForEntry(path);
            final FileChannel fch = tmpfile.getFileSystem().provider().newFileChannel(tmpfile, options, attrs);
            Entry entry = u = isFCH ? e : new Entry(path, tmpfile, 3);
            if (forWrite) {
                u.flag = 8;
                u.method = 8;
            }
            FileChannel fileChannel = new FileChannel(){

                @Override
                public int write(ByteBuffer src) throws IOException {
                    return fch.write(src);
                }

                @Override
                public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                    return fch.write(srcs, offset, length);
                }

                @Override
                public long position() throws IOException {
                    return fch.position();
                }

                @Override
                public FileChannel position(long newPosition) throws IOException {
                    fch.position(newPosition);
                    return this;
                }

                @Override
                public long size() throws IOException {
                    return fch.size();
                }

                @Override
                public FileChannel truncate(long size) throws IOException {
                    fch.truncate(size);
                    return this;
                }

                @Override
                public void force(boolean metaData) throws IOException {
                    fch.force(metaData);
                }

                @Override
                public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
                    return fch.transferTo(position, count, target);
                }

                @Override
                public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
                    return fch.transferFrom(src, position, count);
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    return fch.read(dst);
                }

                @Override
                public int read(ByteBuffer dst, long position) throws IOException {
                    return fch.read(dst, position);
                }

                @Override
                public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
                    return fch.read(dsts, offset, length);
                }

                @Override
                public int write(ByteBuffer src, long position) throws IOException {
                    return fch.write(src, position);
                }

                @Override
                public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public FileLock lock(long position, long size, boolean shared) throws IOException {
                    return fch.lock(position, size, shared);
                }

                @Override
                public FileLock tryLock(long position, long size, boolean shared) throws IOException {
                    return fch.tryLock(position, size, shared);
                }

                @Override
                protected void implCloseChannel() throws IOException {
                    fch.close();
                    if (forWrite) {
                        u.mtime = System.currentTimeMillis();
                        u.size = Files.size(u.file);
                        ZipFileSystem.this.update(u);
                    } else if (!isFCH) {
                        ZipFileSystem.this.removeTempPathForEntry(tmpfile);
                    }
                }
            };
            return fileChannel;
        }
        finally {
            this.endRead();
        }
    }

    private Path getTempPathForEntry(byte[] path) throws IOException {
        Entry e;
        Path tmpPath = this.createTempFileInSameDirectoryAs(this.zfpath);
        if (path != null && (e = this.getEntry0(path)) != null) {
            try (InputStream is = this.newInputStream(path);){
                Files.copy(is, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return tmpPath;
    }

    private void removeTempPathForEntry(Path path) throws IOException {
        Files.delete(path);
        this.tmppaths.remove(path);
    }

    private void checkParents(byte[] path) throws IOException {
        this.beginRead();
        try {
            while ((path = ZipFileSystem.getParent(path)) != null && path.length != 0) {
                if (this.inodes.containsKey(IndexNode.keyOf(path))) continue;
                throw new NoSuchFileException(this.getString(path));
            }
        }
        finally {
            this.endRead();
        }
    }

    private static byte[] getParent(byte[] path) {
        int off = path.length - 1;
        if (off > 0 && path[off] == 47) {
            --off;
        }
        while (off > 0 && path[off] != 47) {
            --off;
        }
        if (off <= 0) {
            return ROOTPATH;
        }
        return Arrays.copyOf(path, off + 1);
    }

    private final void beginWrite() {
        this.rwlock.writeLock().lock();
    }

    private final void endWrite() {
        this.rwlock.writeLock().unlock();
    }

    private final void beginRead() {
        this.rwlock.readLock().lock();
    }

    private final void endRead() {
        this.rwlock.readLock().unlock();
    }

    final byte[] getBytes(String name) {
        return this.zc.getBytes(name);
    }

    final String getString(byte[] name) {
        return this.zc.toString(name);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private long getDataPos(Entry e) throws IOException {
        byte[] buf;
        if (e.locoff == -1L) {
            Entry e2 = this.getEntry0(e.name);
            if (e2 == null) {
                throw new ZipException("invalid loc for entry <" + e.name + ">");
            }
            e.locoff = e2.locoff;
        }
        if (this.readFullyAt(buf = new byte[30], 0, buf.length, e.locoff) != (long)buf.length) {
            throw new ZipException("invalid loc for entry <" + e.name + ">");
        }
        return this.locpos + e.locoff + 30L + (long)ZipConstants.LOCNAM(buf) + (long)ZipConstants.LOCEXT(buf);
    }

    final long readFullyAt(byte[] buf, int off, long len, long pos) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.position(off);
        bb.limit((int)((long)off + len));
        return this.readFullyAt(bb, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long readFullyAt(ByteBuffer bb, long pos) throws IOException {
        SeekableByteChannel seekableByteChannel = this.ch;
        synchronized (seekableByteChannel) {
            return this.ch.position(pos).read(bb);
        }
    }

    private END findEND() throws IOException {
        byte[] buf = new byte[128];
        long ziplen = this.ch.size();
        long minHDR = ziplen - 65557L > 0L ? ziplen - 65557L : 0L;
        long minPos = minHDR - (long)(buf.length - 22);
        for (long pos = ziplen - (long)buf.length; pos >= minPos; pos -= (long)(buf.length - 22)) {
            int len;
            int off = 0;
            if (pos < 0L) {
                off = (int)(-pos);
                Arrays.fill(buf, 0, off, (byte)0);
            }
            if (this.readFullyAt(buf, off, len = buf.length - off, pos + (long)off) != (long)len) {
                ZipFileSystem.zerror("zip END header not found");
            }
            for (int i2 = buf.length - 22; i2 >= 0; --i2) {
                if (buf[i2 + 0] != 80 || buf[i2 + 1] != 75 || buf[i2 + 2] != 5 || buf[i2 + 3] != 6 || pos + (long)i2 + 22L + (long)ZipConstants.ENDCOM(buf, i2) != ziplen) continue;
                buf = Arrays.copyOfRange(buf, i2, i2 + 22);
                END end = new END();
                end.endsub = ZipConstants.ENDSUB(buf);
                end.centot = ZipConstants.ENDTOT(buf);
                end.cenlen = ZipConstants.ENDSIZ(buf);
                end.cenoff = ZipConstants.ENDOFF(buf);
                end.comlen = ZipConstants.ENDCOM(buf);
                end.endpos = pos + (long)i2;
                if (end.cenlen == 0xFFFFFFFFL || end.cenoff == 0xFFFFFFFFL || end.centot == 65535) {
                    byte[] loc64 = new byte[20];
                    if (this.readFullyAt(loc64, 0, loc64.length, end.endpos - 20L) != (long)loc64.length) {
                        return end;
                    }
                    byte[] end64buf = new byte[56];
                    long end64pos = ZipConstants.ZIP64_LOCOFF(loc64);
                    if (this.readFullyAt(end64buf, 0, end64buf.length, end64pos) != (long)end64buf.length) {
                        return end;
                    }
                    end.cenlen = ZipConstants.ZIP64_ENDSIZ(end64buf);
                    end.cenoff = ZipConstants.ZIP64_ENDOFF(end64buf);
                    end.centot = (int)ZipConstants.ZIP64_ENDTOT(end64buf);
                    end.endpos = end64pos;
                }
                return end;
            }
        }
        ZipFileSystem.zerror("zip END header not found");
        return null;
    }

    private byte[] initCEN() throws IOException {
        int pos;
        int clen;
        int elen;
        int nlen;
        byte[] cen;
        this.end = this.findEND();
        if (this.end.endpos == 0L) {
            this.inodes = new LinkedHashMap(10);
            this.locpos = 0L;
            this.buildNodeTree();
            return null;
        }
        if (this.end.cenlen > this.end.endpos) {
            ZipFileSystem.zerror("invalid END header (bad central directory size)");
        }
        long cenpos = this.end.endpos - this.end.cenlen;
        this.locpos = cenpos - this.end.cenoff;
        if (this.locpos < 0L) {
            ZipFileSystem.zerror("invalid END header (bad central directory offset)");
        }
        if (this.readFullyAt(cen = new byte[(int)(this.end.cenlen + 22L)], 0, cen.length, cenpos) != this.end.cenlen + 22L) {
            ZipFileSystem.zerror("read CEN tables failed");
        }
        this.inodes = new LinkedHashMap(this.end.centot + 1);
        int limit = cen.length - 22;
        for (pos = 0; pos < limit; pos += 46 + nlen + elen + clen) {
            if (ZipConstants.CENSIG(cen, pos) != ZipConstants.CENSIG) {
                ZipFileSystem.zerror("invalid CEN header (bad signature)");
            }
            int method = ZipConstants.CENHOW(cen, pos);
            nlen = ZipConstants.CENNAM(cen, pos);
            elen = ZipConstants.CENEXT(cen, pos);
            clen = ZipConstants.CENCOM(cen, pos);
            if ((ZipConstants.CENFLG(cen, pos) & 1) != 0) {
                ZipFileSystem.zerror("invalid CEN header (encrypted entry)");
            }
            if (method != 0 && method != 8) {
                ZipFileSystem.zerror("invalid CEN header (unsupported compression method: " + method + ")");
            }
            if (pos + 46 + nlen > limit) {
                ZipFileSystem.zerror("invalid CEN header (bad header size)");
            }
            byte[] name = Arrays.copyOfRange(cen, pos + 46, pos + 46 + nlen);
            IndexNode inode = new IndexNode(name, pos);
            this.inodes.put(inode, inode);
        }
        if (pos + 22 != cen.length) {
            ZipFileSystem.zerror("invalid CEN header (bad header size)");
        }
        this.buildNodeTree();
        return cen;
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new ClosedFileSystemException();
        }
    }

    private Path createTempFileInSameDirectoryAs(Path path) throws IOException {
        Path parent = path.toAbsolutePath().getParent();
        Path dir = parent == null ? path.getFileSystem().getPath(".", new String[0]) : parent;
        Path tmpPath = Files.createTempFile(dir, "zipfstmp", null, new FileAttribute[0]);
        this.tmppaths.add(tmpPath);
        return tmpPath;
    }

    private void updateDelete(IndexNode inode) {
        this.beginWrite();
        try {
            this.removeFromTree(inode);
            this.inodes.remove(inode);
            this.hasUpdate = true;
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Entry e) {
        this.beginWrite();
        try {
            IndexNode old = this.inodes.put(e, e);
            if (old != null) {
                this.removeFromTree(old);
            }
            if (e.type == 2 || e.type == 3 || e.type == 4) {
                IndexNode parent = this.inodes.get(this.LOOKUPKEY.as(ZipFileSystem.getParent(e.name)));
                e.sibling = parent.child;
                parent.child = e;
            }
            this.hasUpdate = true;
        }
        finally {
            this.endWrite();
        }
    }

    private long copyLOCEntry(Entry e, boolean updateHeader, OutputStream os, long written, byte[] buf) throws IOException {
        int n;
        long locoff = e.locoff;
        e.locoff = written;
        long size = 0L;
        if ((e.flag & 8) != 0) {
            size = e.size >= 0xFFFFFFFFL || e.csize >= 0xFFFFFFFFL ? 24L : 16L;
        }
        if (this.readFullyAt(buf, 0, 30L, locoff) != 30L) {
            throw new ZipException("loc: reading failed");
        }
        if (updateHeader) {
            locoff += (long)(30 + ZipConstants.LOCNAM(buf) + ZipConstants.LOCEXT(buf));
            written = (long)e.writeLOC(os) + (size += e.csize);
        } else {
            os.write(buf, 0, 30);
            locoff += 30L;
            written = 30L + (size += (long)(ZipConstants.LOCNAM(buf) + ZipConstants.LOCEXT(buf)) + e.csize);
        }
        while (size > 0L && (n = (int)this.readFullyAt(buf, 0, buf.length, locoff)) != -1) {
            if (size < (long)n) {
                n = (int)size;
            }
            os.write(buf, 0, n);
            size -= (long)n;
            locoff += (long)n;
        }
        return written;
    }

    public void sync() throws IOException {
        if (!this.exChClosers.isEmpty()) {
            for (ExChannelCloser ecc : this.exChClosers) {
                if (!ecc.streams.isEmpty()) continue;
                ecc.ch.close();
                Files.delete(ecc.path);
                this.exChClosers.remove(ecc);
            }
        }
        if (!this.hasUpdate) {
            return;
        }
        Path tmpFile = this.createTempFileInSameDirectoryAs(this.zfpath);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tmpFile, StandardOpenOption.WRITE));){
            ArrayList<Entry> elist = new ArrayList<Entry>(this.inodes.size());
            long written = 0L;
            byte[] buf = new byte[8192];
            Entry e = null;
            for (IndexNode inode : this.inodes.values()) {
                if (inode instanceof Entry) {
                    e = (Entry)inode;
                    try {
                        if (e.type == 4) {
                            written += this.copyLOCEntry(e, true, os, written, buf);
                        } else {
                            e.locoff = written;
                            written += (long)e.writeLOC(os);
                            if (e.bytes != null) {
                                ((OutputStream)os).write(e.bytes);
                                written += (long)e.bytes.length;
                            } else if (e.file != null) {
                                block57: {
                                    try (InputStream is = Files.newInputStream(e.file, new OpenOption[0]);){
                                        if (e.type == 2) {
                                            int n;
                                            while ((n = is.read(buf)) != -1) {
                                                ((OutputStream)os).write(buf, 0, n);
                                                written += (long)n;
                                            }
                                            break block57;
                                        }
                                        if (e.type != 3) break block57;
                                        try (EntryOutputStream os2 = new EntryOutputStream(e, os);){
                                            int n;
                                            while ((n = is.read(buf)) != -1) {
                                                ((OutputStream)os2).write(buf, 0, n);
                                            }
                                        }
                                        written += e.csize;
                                        if ((e.flag & 8) != 0) {
                                            written += (long)e.writeEXT(os);
                                        }
                                    }
                                }
                                Files.delete(e.file);
                                this.tmppaths.remove(e.file);
                            }
                        }
                        elist.add(e);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                    continue;
                }
                if (inode.pos == -1) continue;
                e = Entry.readCEN(this, inode.pos);
                try {
                    written += this.copyLOCEntry(e, false, os, written, buf);
                    elist.add(e);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
            this.end.cenoff = written;
            for (Entry entry : elist) {
                written += (long)entry.writeCEN(os);
            }
            this.end.centot = elist.size();
            this.end.cenlen = written - this.end.cenoff;
            this.end.write(os, written);
        }
        if (!this.streams.isEmpty()) {
            ExChannelCloser ecc;
            ecc = new ExChannelCloser(this.createTempFileInSameDirectoryAs(this.zfpath), this.ch, this.streams);
            Files.move(this.zfpath, ecc.path, StandardCopyOption.REPLACE_EXISTING);
            this.exChClosers.add(ecc);
            this.streams = Collections.synchronizedSet(new HashSet());
        } else {
            this.ch.close();
            Files.delete(this.zfpath);
        }
        Files.move(tmpFile, this.zfpath, StandardCopyOption.REPLACE_EXISTING);
        this.hasUpdate = false;
    }

    private IndexNode getInode(byte[] path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        IndexNode key = IndexNode.keyOf(path);
        IndexNode inode = this.inodes.get(key);
        if (inode == null && (path.length == 0 || path[path.length - 1] != 47)) {
            path = Arrays.copyOf(path, path.length + 1);
            path[path.length - 1] = 47;
            inode = this.inodes.get(key.as(path));
        }
        return inode;
    }

    private Entry getEntry0(byte[] path) throws IOException {
        IndexNode inode = this.getInode(path);
        if (inode instanceof Entry) {
            return (Entry)inode;
        }
        if (inode == null || inode.pos == -1) {
            return null;
        }
        return Entry.readCEN(this, inode.pos);
    }

    public void deleteFile(byte[] path, boolean failIfNotExists) throws IOException {
        this.checkWritable();
        IndexNode inode = this.getInode(path);
        if (inode == null) {
            if (path != null && path.length == 0) {
                throw new ZipException("root directory </> can't not be delete");
            }
            if (failIfNotExists) {
                throw new NoSuchFileException(this.getString(path));
            }
        } else {
            if (inode.isDir() && inode.child != null) {
                throw new DirectoryNotEmptyException(this.getString(path));
            }
            this.updateDelete(inode);
        }
    }

    private static void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] copyBuf = new byte[8192];
        while ((n = is.read(copyBuf)) != -1) {
            os.write(copyBuf, 0, n);
        }
    }

    private OutputStream getOutputStream(Entry e) throws IOException {
        OutputStream os;
        if (e.mtime == -1L) {
            e.mtime = System.currentTimeMillis();
        }
        if (e.method == -1) {
            e.method = 8;
        }
        e.flag = 0;
        if (this.zc.isUTF8()) {
            e.flag |= 0x800;
        }
        if (this.useTempFile) {
            e.file = this.getTempPathForEntry(null);
            os = Files.newOutputStream(e.file, StandardOpenOption.WRITE);
        } else {
            os = new ByteArrayOutputStream(e.size > 0L ? (int)e.size : 8192);
        }
        return new EntryOutputStream(e, os);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getInputStream(Entry e) throws IOException {
        void var2_9;
        Object var2_2 = null;
        if (e.type == 2) {
            if (e.bytes != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(e.bytes);
            } else {
                if (e.file == null) throw new ZipException("update entry data is missing");
                InputStream inputStream = Files.newInputStream(e.file, new OpenOption[0]);
            }
        } else {
            if (e.type == 3) {
                return Files.newInputStream(e.file, new OpenOption[0]);
            }
            EntryInputStream entryInputStream = new EntryInputStream(e, this.ch);
        }
        if (e.method == 8) {
            void var2_7;
            long bufSize = e.size + 2L;
            if (bufSize > 65536L) {
                bufSize = 8192L;
            }
            final long size = e.size;
            InflaterInputStream inflaterInputStream = new InflaterInputStream((InputStream)var2_7, this.getInflater(), (int)bufSize){
                private boolean isClosed;
                private boolean eof;
                {
                    super(x0, x1, x2);
                    this.isClosed = false;
                }

                @Override
                public void close() throws IOException {
                    if (!this.isClosed) {
                        ZipFileSystem.this.releaseInflater(this.inf);
                        this.in.close();
                        this.isClosed = true;
                        ZipFileSystem.this.streams.remove(this);
                    }
                }

                @Override
                protected void fill() throws IOException {
                    if (this.eof) {
                        throw new EOFException("Unexpected end of ZLIB input stream");
                    }
                    this.len = this.in.read(this.buf, 0, this.buf.length);
                    if (this.len == -1) {
                        this.buf[0] = 0;
                        this.len = 1;
                        this.eof = true;
                    }
                    this.inf.setInput(this.buf, 0, this.len);
                }

                @Override
                public int available() throws IOException {
                    if (this.isClosed) {
                        return 0;
                    }
                    long avail = size - this.inf.getBytesWritten();
                    return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
                }
            };
        } else if (e.method != 0) throw new ZipException("invalid compression method");
        this.streams.add((InputStream)var2_9);
        return var2_9;
    }

    static void zerror(String msg) {
        throw new ZipError(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        List<Inflater> list = this.inflaters;
        synchronized (list) {
            int size = this.inflaters.size();
            if (size > 0) {
                Inflater inf = this.inflaters.remove(size - 1);
                return inf;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inf) {
        List<Inflater> list = this.inflaters;
        synchronized (list) {
            if (this.inflaters.size() < 20) {
                inf.reset();
                this.inflaters.add(inf);
            } else {
                inf.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deflater getDeflater() {
        List<Deflater> list = this.deflaters;
        synchronized (list) {
            int size = this.deflaters.size();
            if (size > 0) {
                Deflater def = this.deflaters.remove(size - 1);
                return def;
            }
            return new Deflater(-1, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDeflater(Deflater def) {
        List<Deflater> list = this.deflaters;
        synchronized (list) {
            if (this.inflaters.size() < 20) {
                def.reset();
                this.deflaters.add(def);
            } else {
                def.end();
            }
        }
    }

    private void addToTree(IndexNode inode, HashSet<IndexNode> dirs) {
        IndexNode parent;
        if (dirs.contains(inode)) {
            return;
        }
        byte[] name = inode.name;
        byte[] pname = ZipFileSystem.getParent(name);
        if (this.inodes.containsKey(this.LOOKUPKEY.as(pname))) {
            parent = this.inodes.get(this.LOOKUPKEY);
        } else {
            parent = new IndexNode(pname, -1);
            this.inodes.put(parent, parent);
        }
        this.addToTree(parent, dirs);
        inode.sibling = parent.child;
        parent.child = inode;
        if (name[name.length - 1] == 47) {
            dirs.add(inode);
        }
    }

    private void removeFromTree(IndexNode inode) {
        IndexNode parent = this.inodes.get(this.LOOKUPKEY.as(ZipFileSystem.getParent(inode.name)));
        IndexNode child = parent.child;
        if (child.equals(inode)) {
            parent.child = child.sibling;
        } else {
            IndexNode last = child;
            while ((child = child.sibling) != null) {
                if (child.equals(inode)) {
                    last.sibling = child.sibling;
                    break;
                }
                last = child;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNodeTree() throws IOException {
        this.beginWrite();
        try {
            HashSet<IndexNode> dirs = new HashSet<IndexNode>();
            IndexNode root2 = new IndexNode(ROOTPATH, -1);
            this.inodes.put(root2, root2);
            dirs.add(root2);
            for (IndexNode node : this.inodes.keySet().toArray(new IndexNode[0])) {
                this.addToTree(node, dirs);
            }
        }
        finally {
            this.endWrite();
        }
    }

    private static class ExChannelCloser {
        Path path;
        SeekableByteChannel ch;
        Set<InputStream> streams;

        ExChannelCloser(Path path, SeekableByteChannel ch, Set<InputStream> streams) {
            this.path = path;
            this.ch = ch;
            this.streams = streams;
        }
    }

    static class Entry
    extends IndexNode {
        static final int CEN = 1;
        static final int NEW = 2;
        static final int FILECH = 3;
        static final int COPY = 4;
        byte[] bytes;
        Path file;
        int type = 1;
        int version;
        int flag;
        int method = -1;
        long mtime = -1L;
        long atime = -1L;
        long ctime = -1L;
        long crc = -1L;
        long csize = -1L;
        long size = -1L;
        byte[] extra;
        int versionMade;
        int disk;
        int attrs;
        long attrsEx;
        long locoff;
        byte[] comment;

        Entry() {
        }

        Entry(byte[] name) {
            this.name(name);
            this.ctime = this.atime = System.currentTimeMillis();
            this.mtime = this.atime;
            this.crc = 0L;
            this.size = 0L;
            this.csize = 0L;
            this.method = 8;
        }

        Entry(byte[] name, int type) {
            this(name);
            this.type = type;
        }

        Entry(Entry e, int type) {
            this.name(e.name);
            this.version = e.version;
            this.ctime = e.ctime;
            this.atime = e.atime;
            this.mtime = e.mtime;
            this.crc = e.crc;
            this.size = e.size;
            this.csize = e.csize;
            this.method = e.method;
            this.extra = e.extra;
            this.versionMade = e.versionMade;
            this.disk = e.disk;
            this.attrs = e.attrs;
            this.attrsEx = e.attrsEx;
            this.locoff = e.locoff;
            this.comment = e.comment;
            this.type = type;
        }

        Entry(byte[] name, Path file, int type) {
            this(name, type);
            this.file = file;
            this.method = 0;
        }

        int version() throws ZipException {
            if (this.method == 8) {
                return 20;
            }
            if (this.method == 0) {
                return 10;
            }
            throw new ZipException("unsupported compression method");
        }

        static Entry readCEN(ZipFileSystem zipfs, int pos) throws IOException {
            return new Entry().cen(zipfs, pos);
        }

        private Entry cen(ZipFileSystem zipfs, int pos) throws IOException {
            byte[] cen = zipfs.cen;
            if (ZipConstants.CENSIG(cen, pos) != ZipConstants.CENSIG) {
                ZipFileSystem.zerror("invalid CEN header (bad signature)");
            }
            this.versionMade = ZipConstants.CENVEM(cen, pos);
            this.version = ZipConstants.CENVER(cen, pos);
            this.flag = ZipConstants.CENFLG(cen, pos);
            this.method = ZipConstants.CENHOW(cen, pos);
            this.mtime = ZipUtils.dosToJavaTime(ZipConstants.CENTIM(cen, pos));
            this.crc = ZipConstants.CENCRC(cen, pos);
            this.csize = ZipConstants.CENSIZ(cen, pos);
            this.size = ZipConstants.CENLEN(cen, pos);
            int nlen = ZipConstants.CENNAM(cen, pos);
            int elen = ZipConstants.CENEXT(cen, pos);
            int clen = ZipConstants.CENCOM(cen, pos);
            this.disk = ZipConstants.CENDSK(cen, pos);
            this.attrs = ZipConstants.CENATT(cen, pos);
            this.attrsEx = ZipConstants.CENATX(cen, pos);
            this.locoff = ZipConstants.CENOFF(cen, pos);
            this.name(Arrays.copyOfRange(cen, pos += 46, pos + nlen));
            pos += nlen;
            if (elen > 0) {
                this.extra = Arrays.copyOfRange(cen, pos, pos + elen);
                pos += elen;
                this.readExtra(zipfs);
            }
            if (clen > 0) {
                this.comment = Arrays.copyOfRange(cen, pos, pos + clen);
            }
            return this;
        }

        int writeCEN(OutputStream os) throws IOException {
            int clen;
            int written = 46;
            int version0 = this.version();
            long csize0 = this.csize;
            long size0 = this.size;
            long locoff0 = this.locoff;
            int elen64 = 0;
            int elenNTFS = 0;
            int elenEXTT = 0;
            boolean foundExtraTime = false;
            int nlen = this.name != null ? this.name.length : 0;
            int elen = this.extra != null ? this.extra.length : 0;
            int eoff = 0;
            int n = clen = this.comment != null ? this.comment.length : 0;
            if (this.csize >= 0xFFFFFFFFL) {
                csize0 = 0xFFFFFFFFL;
                elen64 += 8;
            }
            if (this.size >= 0xFFFFFFFFL) {
                size0 = 0xFFFFFFFFL;
                elen64 += 8;
            }
            if (this.locoff >= 0xFFFFFFFFL) {
                locoff0 = 0xFFFFFFFFL;
                elen64 += 8;
            }
            if (elen64 != 0) {
                elen64 += 4;
            }
            while (eoff + 4 < elen) {
                int tag = ZipConstants.SH(this.extra, eoff);
                int sz = ZipConstants.SH(this.extra, eoff + 2);
                if (tag == 21589 || tag == 10) {
                    foundExtraTime = true;
                }
                eoff += 4 + sz;
            }
            if (!foundExtraTime) {
                if (isWindows) {
                    elenNTFS = 36;
                } else {
                    elenEXTT = 9;
                }
            }
            ZipUtils.writeInt(os, ZipConstants.CENSIG);
            if (elen64 != 0) {
                ZipUtils.writeShort(os, 45);
                ZipUtils.writeShort(os, 45);
            } else {
                ZipUtils.writeShort(os, version0);
                ZipUtils.writeShort(os, version0);
            }
            ZipUtils.writeShort(os, this.flag);
            ZipUtils.writeShort(os, this.method);
            ZipUtils.writeInt(os, (int)ZipUtils.javaToDosTime(this.mtime));
            ZipUtils.writeInt(os, this.crc);
            ZipUtils.writeInt(os, csize0);
            ZipUtils.writeInt(os, size0);
            ZipUtils.writeShort(os, this.name.length);
            ZipUtils.writeShort(os, elen + elen64 + elenNTFS + elenEXTT);
            if (this.comment != null) {
                ZipUtils.writeShort(os, Math.min(clen, 65535));
            } else {
                ZipUtils.writeShort(os, 0);
            }
            ZipUtils.writeShort(os, 0);
            ZipUtils.writeShort(os, 0);
            ZipUtils.writeInt(os, 0L);
            ZipUtils.writeInt(os, locoff0);
            ZipUtils.writeBytes(os, this.name);
            if (elen64 != 0) {
                ZipUtils.writeShort(os, 1);
                ZipUtils.writeShort(os, elen64 - 4);
                if (size0 == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(os, this.size);
                }
                if (csize0 == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(os, this.csize);
                }
                if (locoff0 == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(os, this.locoff);
                }
            }
            if (elenNTFS != 0) {
                ZipUtils.writeShort(os, 10);
                ZipUtils.writeShort(os, elenNTFS - 4);
                ZipUtils.writeInt(os, 0L);
                ZipUtils.writeShort(os, 1);
                ZipUtils.writeShort(os, 24);
                ZipUtils.writeLong(os, ZipUtils.javaToWinTime(this.mtime));
                ZipUtils.writeLong(os, ZipUtils.javaToWinTime(this.atime));
                ZipUtils.writeLong(os, ZipUtils.javaToWinTime(this.ctime));
            }
            if (elenEXTT != 0) {
                ZipUtils.writeShort(os, 21589);
                ZipUtils.writeShort(os, elenEXTT - 4);
                if (this.ctime == -1L) {
                    os.write(3);
                } else {
                    os.write(7);
                }
                ZipUtils.writeInt(os, ZipUtils.javaToUnixTime(this.mtime));
            }
            if (this.extra != null) {
                ZipUtils.writeBytes(os, this.extra);
            }
            if (this.comment != null) {
                ZipUtils.writeBytes(os, this.comment);
            }
            return 46 + nlen + elen + clen + elen64 + elenNTFS + elenEXTT;
        }

        static Entry readLOC(ZipFileSystem zipfs, long pos) throws IOException {
            return Entry.readLOC(zipfs, pos, new byte[1024]);
        }

        static Entry readLOC(ZipFileSystem zipfs, long pos, byte[] buf) throws IOException {
            return new Entry().loc(zipfs, pos, buf);
        }

        Entry loc(ZipFileSystem zipfs, long pos, byte[] buf) throws IOException {
            assert (buf.length >= 30);
            if (zipfs.readFullyAt(buf, 0, 30L, pos) != 30L) {
                throw new ZipException("loc: reading failed");
            }
            if (ZipConstants.LOCSIG(buf) != ZipConstants.LOCSIG) {
                throw new ZipException("loc: wrong sig ->" + Long.toString(ZipConstants.LOCSIG(buf), 16));
            }
            this.version = ZipConstants.LOCVER(buf);
            this.flag = ZipConstants.LOCFLG(buf);
            this.method = ZipConstants.LOCHOW(buf);
            this.mtime = ZipUtils.dosToJavaTime(ZipConstants.LOCTIM(buf));
            this.crc = ZipConstants.LOCCRC(buf);
            this.csize = ZipConstants.LOCSIZ(buf);
            this.size = ZipConstants.LOCLEN(buf);
            int nlen = ZipConstants.LOCNAM(buf);
            int elen = ZipConstants.LOCEXT(buf);
            this.name = new byte[nlen];
            if (zipfs.readFullyAt(this.name, 0, nlen, pos + 30L) != (long)nlen) {
                throw new ZipException("loc: name reading failed");
            }
            if (elen > 0) {
                this.extra = new byte[elen];
                if (zipfs.readFullyAt(this.extra, 0, elen, pos + 30L + (long)nlen) != (long)elen) {
                    throw new ZipException("loc: ext reading failed");
                }
            }
            pos += (long)(30 + nlen + elen);
            if ((this.flag & 8) != 0) {
                Entry e = zipfs.getEntry0(this.name);
                if (e == null) {
                    throw new ZipException("loc: name not found in cen");
                }
                this.size = e.size;
                this.csize = e.csize;
                pos += this.method == 0 ? this.size : this.csize;
                pos = this.size >= 0xFFFFFFFFL || this.csize >= 0xFFFFFFFFL ? (pos += 24L) : (pos += 16L);
            } else {
                if (this.extra != null && (this.size == 0xFFFFFFFFL || this.csize == 0xFFFFFFFFL)) {
                    int off = 0;
                    while (off + 20 < elen) {
                        int sz = ZipConstants.SH(this.extra, off + 2);
                        if (ZipConstants.SH(this.extra, off) == 1 && sz == 16) {
                            this.size = ZipConstants.LL(this.extra, off + 4);
                            this.csize = ZipConstants.LL(this.extra, off + 12);
                            break;
                        }
                        off += sz + 4;
                    }
                }
                pos += this.method == 0 ? this.size : this.csize;
            }
            return this;
        }

        int writeLOC(OutputStream os) throws IOException {
            ZipUtils.writeInt(os, ZipConstants.LOCSIG);
            int version = this.version();
            int nlen = this.name != null ? this.name.length : 0;
            int elen = this.extra != null ? this.extra.length : 0;
            boolean foundExtraTime = false;
            int eoff = 0;
            int elen64 = 0;
            int elenEXTT = 0;
            int elenNTFS = 0;
            if ((this.flag & 8) != 0) {
                ZipUtils.writeShort(os, this.version());
                ZipUtils.writeShort(os, this.flag);
                ZipUtils.writeShort(os, this.method);
                ZipUtils.writeInt(os, (int)ZipUtils.javaToDosTime(this.mtime));
                ZipUtils.writeInt(os, 0L);
                ZipUtils.writeInt(os, 0L);
                ZipUtils.writeInt(os, 0L);
            } else {
                if (this.csize >= 0xFFFFFFFFL || this.size >= 0xFFFFFFFFL) {
                    elen64 = 20;
                    ZipUtils.writeShort(os, 45);
                } else {
                    ZipUtils.writeShort(os, this.version());
                }
                ZipUtils.writeShort(os, this.flag);
                ZipUtils.writeShort(os, this.method);
                ZipUtils.writeInt(os, (int)ZipUtils.javaToDosTime(this.mtime));
                ZipUtils.writeInt(os, this.crc);
                if (elen64 != 0) {
                    ZipUtils.writeInt(os, 0xFFFFFFFFL);
                    ZipUtils.writeInt(os, 0xFFFFFFFFL);
                } else {
                    ZipUtils.writeInt(os, this.csize);
                    ZipUtils.writeInt(os, this.size);
                }
            }
            while (eoff + 4 < elen) {
                int tag = ZipConstants.SH(this.extra, eoff);
                int sz = ZipConstants.SH(this.extra, eoff + 2);
                if (tag == 21589 || tag == 10) {
                    foundExtraTime = true;
                }
                eoff += 4 + sz;
            }
            if (!foundExtraTime) {
                if (isWindows) {
                    elenNTFS = 36;
                } else {
                    elenEXTT = 9;
                    if (this.atime != -1L) {
                        elenEXTT += 4;
                    }
                    if (this.ctime != -1L) {
                        elenEXTT += 4;
                    }
                }
            }
            ZipUtils.writeShort(os, this.name.length);
            ZipUtils.writeShort(os, elen + elen64 + elenNTFS + elenEXTT);
            ZipUtils.writeBytes(os, this.name);
            if (elen64 != 0) {
                ZipUtils.writeShort(os, 1);
                ZipUtils.writeShort(os, 16);
                ZipUtils.writeLong(os, this.size);
                ZipUtils.writeLong(os, this.csize);
            }
            if (elenNTFS != 0) {
                ZipUtils.writeShort(os, 10);
                ZipUtils.writeShort(os, elenNTFS - 4);
                ZipUtils.writeInt(os, 0L);
                ZipUtils.writeShort(os, 1);
                ZipUtils.writeShort(os, 24);
                ZipUtils.writeLong(os, ZipUtils.javaToWinTime(this.mtime));
                ZipUtils.writeLong(os, ZipUtils.javaToWinTime(this.atime));
                ZipUtils.writeLong(os, ZipUtils.javaToWinTime(this.ctime));
            }
            if (elenEXTT != 0) {
                ZipUtils.writeShort(os, 21589);
                ZipUtils.writeShort(os, elenEXTT - 4);
                int fbyte = 1;
                if (this.atime != -1L) {
                    fbyte |= 2;
                }
                if (this.ctime != -1L) {
                    fbyte |= 4;
                }
                os.write(fbyte);
                ZipUtils.writeInt(os, ZipUtils.javaToUnixTime(this.mtime));
                if (this.atime != -1L) {
                    ZipUtils.writeInt(os, ZipUtils.javaToUnixTime(this.atime));
                }
                if (this.ctime != -1L) {
                    ZipUtils.writeInt(os, ZipUtils.javaToUnixTime(this.ctime));
                }
            }
            if (this.extra != null) {
                ZipUtils.writeBytes(os, this.extra);
            }
            return 30 + this.name.length + elen + elen64 + elenNTFS + elenEXTT;
        }

        int writeEXT(OutputStream os) throws IOException {
            ZipUtils.writeInt(os, ZipConstants.EXTSIG);
            ZipUtils.writeInt(os, this.crc);
            if (this.csize >= 0xFFFFFFFFL || this.size >= 0xFFFFFFFFL) {
                ZipUtils.writeLong(os, this.csize);
                ZipUtils.writeLong(os, this.size);
                return 24;
            }
            ZipUtils.writeInt(os, this.csize);
            ZipUtils.writeInt(os, this.size);
            return 16;
        }

        void readExtra(ZipFileSystem zipfs) throws IOException {
            if (this.extra == null) {
                return;
            }
            int elen = this.extra.length;
            int off = 0;
            int newOff = 0;
            while (off + 4 < elen) {
                int sz;
                int pos = off;
                int tag = ZipConstants.SH(this.extra, pos);
                if ((pos += 4) + (sz = ZipConstants.SH(this.extra, pos + 2)) > elen) break;
                block0 : switch (tag) {
                    case 1: {
                        if (this.size == 0xFFFFFFFFL) {
                            if (pos + 8 > elen) break;
                            this.size = ZipConstants.LL(this.extra, pos);
                            pos += 8;
                        }
                        if (this.csize == 0xFFFFFFFFL) {
                            if (pos + 8 > elen) break;
                            this.csize = ZipConstants.LL(this.extra, pos);
                            pos += 8;
                        }
                        if (this.locoff != 0xFFFFFFFFL || pos + 8 > elen) break;
                        this.locoff = ZipConstants.LL(this.extra, pos);
                        pos += 8;
                        break;
                    }
                    case 10: {
                        if (sz < 32 || ZipConstants.SH(this.extra, pos += 4) != 1 || ZipConstants.SH(this.extra, pos + 2) != 24) break;
                        this.mtime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, pos + 4));
                        this.atime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, pos + 12));
                        this.ctime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, pos + 20));
                        break;
                    }
                    case 21589: {
                        byte[] buf = new byte[30];
                        if (zipfs.readFullyAt(buf, 0, buf.length, this.locoff) != (long)buf.length) {
                            throw new ZipException("loc: reading failed");
                        }
                        if (ZipConstants.LOCSIG(buf) != ZipConstants.LOCSIG) {
                            throw new ZipException("loc: wrong sig ->" + Long.toString(ZipConstants.LOCSIG(buf), 16));
                        }
                        int locElen = ZipConstants.LOCEXT(buf);
                        if (locElen < 9) break;
                        buf = new byte[locElen];
                        int locNlen = ZipConstants.LOCNAM(buf);
                        if (zipfs.readFullyAt(buf, 0, buf.length, this.locoff + 30L + (long)locNlen) != (long)buf.length) {
                            throw new ZipException("loc extra: reading failed");
                        }
                        int locPos = 0;
                        while (locPos + 4 < buf.length) {
                            int flag;
                            int locTag = ZipConstants.SH(buf, locPos);
                            int locSZ = ZipConstants.SH(buf, locPos + 2);
                            locPos += 4;
                            if (locTag != 21589) {
                                locPos += locSZ;
                                continue;
                            }
                            if (((flag = ZipConstants.CH(buf, locPos++)) & 1) != 0) {
                                this.mtime = ZipUtils.unixToJavaTime(ZipConstants.LG(buf, locPos));
                                locPos += 4;
                            }
                            if ((flag & 2) != 0) {
                                this.atime = ZipUtils.unixToJavaTime(ZipConstants.LG(buf, locPos));
                                locPos += 4;
                            }
                            if ((flag & 4) == 0) break block0;
                            this.ctime = ZipUtils.unixToJavaTime(ZipConstants.LG(buf, locPos));
                            locPos += 4;
                            break block0;
                        }
                        break;
                    }
                    default: {
                        System.arraycopy(this.extra, off, this.extra, newOff, sz + 4);
                        newOff += sz + 4;
                    }
                }
                off += sz + 4;
            }
            this.extra = (byte[])(newOff != 0 && newOff != this.extra.length ? Arrays.copyOf(this.extra, newOff) : null);
        }
    }

    static class IndexNode {
        byte[] name;
        int hashcode;
        int pos = -1;
        IndexNode sibling;
        IndexNode child;

        IndexNode(byte[] name, int pos) {
            this.name(name);
            this.pos = pos;
        }

        static final IndexNode keyOf(byte[] name) {
            return new IndexNode(name, -1);
        }

        final void name(byte[] name) {
            this.name = name;
            this.hashcode = Arrays.hashCode(name);
        }

        final IndexNode as(byte[] name) {
            this.name(name);
            return this;
        }

        boolean isDir() {
            return this.name != null && (this.name.length == 0 || this.name[this.name.length - 1] == 47);
        }

        public boolean equals(Object other) {
            if (!(other instanceof IndexNode)) {
                return false;
            }
            return Arrays.equals(this.name, ((IndexNode)other).name);
        }

        public int hashCode() {
            return this.hashcode;
        }

        IndexNode() {
        }
    }

    static class END {
        int disknum;
        int sdisknum;
        int endsub;
        int centot;
        long cenlen;
        long cenoff;
        int comlen;
        byte[] comment;
        int diskNum;
        long endpos;
        int disktot;

        END() {
        }

        void write(OutputStream os, long offset) throws IOException {
            int count;
            boolean hasZip64 = false;
            long xlen = this.cenlen;
            long xoff = this.cenoff;
            if (xlen >= 0xFFFFFFFFL) {
                xlen = 0xFFFFFFFFL;
                hasZip64 = true;
            }
            if (xoff >= 0xFFFFFFFFL) {
                xoff = 0xFFFFFFFFL;
                hasZip64 = true;
            }
            if ((count = this.centot) >= 65535) {
                count = 65535;
                hasZip64 = true;
            }
            if (hasZip64) {
                long off64 = offset;
                ZipUtils.writeInt(os, 101075792L);
                ZipUtils.writeLong(os, 44L);
                ZipUtils.writeShort(os, 45);
                ZipUtils.writeShort(os, 45);
                ZipUtils.writeInt(os, 0L);
                ZipUtils.writeInt(os, 0L);
                ZipUtils.writeLong(os, this.centot);
                ZipUtils.writeLong(os, this.centot);
                ZipUtils.writeLong(os, this.cenlen);
                ZipUtils.writeLong(os, this.cenoff);
                ZipUtils.writeInt(os, 117853008L);
                ZipUtils.writeInt(os, 0L);
                ZipUtils.writeLong(os, off64);
                ZipUtils.writeInt(os, 1L);
            }
            ZipUtils.writeInt(os, ZipConstants.ENDSIG);
            ZipUtils.writeShort(os, 0);
            ZipUtils.writeShort(os, 0);
            ZipUtils.writeShort(os, count);
            ZipUtils.writeShort(os, count);
            ZipUtils.writeInt(os, xlen);
            ZipUtils.writeInt(os, xoff);
            if (this.comment != null) {
                ZipUtils.writeShort(os, this.comment.length);
                ZipUtils.writeBytes(os, this.comment);
            } else {
                ZipUtils.writeShort(os, 0);
            }
        }
    }

    class EntryOutputStream
    extends DeflaterOutputStream {
        private CRC32 crc;
        private Entry e;
        private long written;

        EntryOutputStream(Entry e, OutputStream os) throws IOException {
            super(os, ZipFileSystem.this.getDeflater());
            if (e == null) {
                throw new NullPointerException("Zip entry is null");
            }
            this.e = e;
            this.crc = new CRC32();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.e.type != 3) {
                ZipFileSystem.this.ensureOpen();
            }
            if (off < 0 || len < 0 || off > b.length - len) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            switch (this.e.method) {
                case 8: {
                    super.write(b, off, len);
                    break;
                }
                case 0: {
                    this.written += (long)len;
                    this.out.write(b, off, len);
                    break;
                }
                default: {
                    throw new ZipException("invalid compression method");
                }
            }
            this.crc.update(b, off, len);
        }

        @Override
        public void close() throws IOException {
            switch (this.e.method) {
                case 8: {
                    this.finish();
                    this.e.size = this.def.getBytesRead();
                    this.e.csize = this.def.getBytesWritten();
                    this.e.crc = this.crc.getValue();
                    break;
                }
                case 0: {
                    this.e.size = this.e.csize = this.written;
                    this.e.crc = this.crc.getValue();
                    break;
                }
                default: {
                    throw new ZipException("invalid compression method");
                }
            }
            if (this.out instanceof ByteArrayOutputStream) {
                this.e.bytes = ((ByteArrayOutputStream)this.out).toByteArray();
            }
            if (this.e.type == 3) {
                ZipFileSystem.this.releaseDeflater(this.def);
                return;
            }
            super.close();
            ZipFileSystem.this.releaseDeflater(this.def);
            ZipFileSystem.this.update(this.e);
        }
    }

    private class EntryInputStream
    extends InputStream {
        private final SeekableByteChannel zfch;
        private long pos;
        protected long rem;
        protected final long size;

        EntryInputStream(Entry e, SeekableByteChannel zfch) throws IOException {
            this.zfch = zfch;
            this.rem = e.csize;
            this.size = e.size;
            this.pos = ZipFileSystem.this.getDataPos(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ZipFileSystem.this.ensureOpen();
            if (this.rem == 0L) {
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.rem) {
                len = (int)this.rem;
            }
            long n = 0L;
            ByteBuffer bb = ByteBuffer.wrap(b);
            bb.position(off);
            bb.limit(off + len);
            SeekableByteChannel seekableByteChannel = this.zfch;
            synchronized (seekableByteChannel) {
                n = this.zfch.position(this.pos).read(bb);
            }
            if (n > 0L) {
                this.pos += n;
                this.rem -= n;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return (int)n;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public long skip(long n) throws IOException {
            ZipFileSystem.this.ensureOpen();
            if (n > this.rem) {
                n = this.rem;
            }
            this.pos += n;
            this.rem -= n;
            if (this.rem == 0L) {
                this.close();
            }
            return n;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        @Override
        public void close() {
            this.rem = 0L;
            ZipFileSystem.this.streams.remove(this);
        }
    }
}

