/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.zipfs;

import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileAttributeView;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystem;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipPath;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;

public class ZipFileStore
extends FileStore {
    private final ZipFileSystem zfs;

    ZipFileStore(ZipPath zpath) {
        this.zfs = zpath.getFileSystem();
    }

    @Override
    public String name() {
        return this.zfs.toString() + "/";
    }

    @Override
    public String type() {
        return "zipfs";
    }

    @Override
    public boolean isReadOnly() {
        return this.zfs.isReadOnly();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return type == BasicFileAttributeView.class || type == ZipFileAttributeView.class;
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return name.equals("basic") || name.equals("zip");
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return (V)((FileStoreAttributeView)null);
    }

    @Override
    public long getTotalSpace() throws IOException {
        return new ZipFileStoreAttributes(this).totalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return new ZipFileStoreAttributes(this).usableSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return new ZipFileStoreAttributes(this).unallocatedSpace();
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        if (attribute.equals("totalSpace")) {
            return this.getTotalSpace();
        }
        if (attribute.equals("usableSpace")) {
            return this.getUsableSpace();
        }
        if (attribute.equals("unallocatedSpace")) {
            return this.getUnallocatedSpace();
        }
        throw new UnsupportedOperationException("does not support the given attribute");
    }

    private static class ZipFileStoreAttributes {
        final FileStore fstore;
        final long size;

        public ZipFileStoreAttributes(ZipFileStore fileStore) throws IOException {
            Path path = FileSystems.getDefault().getPath(fileStore.name(), new String[0]);
            this.size = Files.size(path);
            this.fstore = Files.getFileStore(path);
        }

        public long totalSpace() {
            return this.size;
        }

        public long usableSpace() throws IOException {
            if (!this.fstore.isReadOnly()) {
                return this.fstore.getUsableSpace();
            }
            return 0L;
        }

        public long unallocatedSpace() throws IOException {
            if (!this.fstore.isReadOnly()) {
                return this.fstore.getUnallocatedSpace();
            }
            return 0L;
        }
    }
}

