/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageDsMetadata
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbSrcStorageDsMetadata.class);
    private final PersistentHashMap<DbSrcPath, MetaData> myObjects;

    public DbSrcStorageDsMetadata(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "<init>"));
        }
        this.myObjects = DbSrcStorageDsMetadata.createMapOrRecreate(file);
    }

    @NotNull
    private static PersistentHashMap<DbSrcPath, MetaData> createMapOrRecreate(@NotNull File file) throws IOException {
        PersistentHashMap<DbSrcPath, MetaData> persistentHashMap;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMapOrRecreate"));
        }
        try {
            FileUtil.createParentDirs((File)file.getParentFile());
            persistentHashMap = DbSrcStorageDsMetadata.createMap(file);
        }
        catch (PersistentEnumeratorBase.CorruptedException e) {
            FileUtil.delete((File)file);
            PersistentHashMap<DbSrcPath, MetaData> persistentHashMap2 = DbSrcStorageDsMetadata.createMap(file);
            if (persistentHashMap2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMapOrRecreate"));
            }
            return persistentHashMap2;
        }
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMapOrRecreate"));
        }
        return persistentHashMap;
    }

    @NotNull
    private static PersistentHashMap<DbSrcPath, MetaData> createMap(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMap"));
        }
        PersistentHashMap persistentHashMap = new PersistentHashMap(file, (KeyDescriptor)new KeyDescriptor<DbSrcPath>(){

            public int getHashCode(DbSrcPath value) {
                return Comparing.hashcode((Object)value);
            }

            public boolean isEqual(DbSrcPath val1, DbSrcPath val2) {
                return Comparing.equal((Object)val1, (Object)val2);
            }

            public void save(@NotNull DataOutput out, DbSrcPath value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$1", "save"));
                }
                int size = value.size();
                out.write(size);
                for (int i2 = 0; i2 < size; ++i2) {
                    out.writeUTF(value.name(i2));
                    out.writeUTF(value.kind(i2));
                }
                String d = value.getDisambiguator();
                out.writeBoolean(d != null);
                if (d != null) {
                    out.writeUTF(d);
                }
            }

            public DbSrcPath read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$1", "read"));
                }
                int size = in.readInt();
                ArrayList names = ContainerUtil.newArrayListWithCapacity((int)size);
                ArrayList kinds = ContainerUtil.newArrayListWithCapacity((int)size);
                for (int i2 = 0; i2 < size; ++i2) {
                    names.add(DbUtil.intern((String)in.readUTF()));
                    kinds.add(DbUtil.intern((String)in.readUTF()));
                }
                String disambiguator = in.readBoolean() ? in.readUTF() : null;
                return new DbSrcPath(names, kinds, disambiguator);
            }
        }, (DataExternalizer)new DataExternalizer<MetaData>(){

            public void save(@NotNull DataOutput out, MetaData value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$2", "save"));
                }
                out.writeBoolean(value.srcVersion != null);
                if (value.srcVersion != null) {
                    out.writeLong(value.srcVersion);
                }
                out.writeInt(value.contentHash);
            }

            public MetaData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$2", "read"));
                }
                return new MetaData(in.readBoolean() ? Long.valueOf(in.readLong()) : null, in.readInt());
            }
        });
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMap"));
        }
        return persistentHashMap;
    }

    @Nullable
    public MetaData getMetaData(@NotNull DbSrcPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "getMetaData"));
        }
        try {
            return (MetaData)this.myObjects.get((Object)path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void putMetaData(@NotNull DbSrcPath object, @Nullable MetaData data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "putMetaData"));
        }
        try {
            if (data == null || data.equals(MetaData.EMPTY)) {
                this.myObjects.remove((Object)object);
            } else {
                this.myObjects.put((Object)object, (Object)data);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.myObjects.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static final class MetaData {
        private static MetaData EMPTY = new MetaData(null, 0);
        public final Long srcVersion;
        public final int contentHash;

        public MetaData(Long srcVersion, int contentHash) {
            this.srcVersion = srcVersion;
            this.contentHash = contentHash;
        }

        @NotNull
        public static MetaData modContentHash(@Nullable MetaData data, int contentHash) {
            MetaData metaData = new MetaData(data == null ? null : data.srcVersion, contentHash);
            if (metaData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MetaData", "modContentHash"));
            }
            return metaData;
        }

        @NotNull
        public static MetaData modSrcVersion(@Nullable MetaData data, @Nullable Long srcVersion) {
            MetaData metaData = new MetaData(srcVersion, data == null ? 0 : data.contentHash);
            if (metaData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MetaData", "modSrcVersion"));
            }
            return metaData;
        }
    }
}

