/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BitDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.SizeDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.MysqlDialect;

public class MysqlDomains
extends DomainRegistry {
    private static final int MIN_MYSQL_MEDIUM_INT = -16777216;
    private static final int MAX_MYSQL_MEDIUM_INT = 0xFFFFFF;
    private static final short MAX_PRECISION = 30;
    private static final int MAX_CHAR = 255;
    private static final long MAX_LONG = 0x800000L;
    private static final int MAX_VAR = 65535;
    private static final int PRECISION = 53;

    public MysqlDomains() {
        super(MysqlDialect.INSTANCE);
        this.add(new SizeDomain.LessOrEqual(new BooleanDomain("bit", ConversionPoint.BOOLEAN), 1));
        this.add(new SizeDomain.Greater(new BitDomain("bit", ConversionPoint.BINARY, 64L, -1L, true), 1));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add(new IntegerDomain("mediumint", ConversionPoint.NUMBER, -1.6777216E7, 1.6777215E7));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new Number2Domain("double precision", ConversionPoint.DOUBLE_PRECISION, 30, 30, true));
        this.add(new Number2Domain("double", ConversionPoint.DOUBLE_PRECISION, 30, 30, true));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 30, 30, true));
        this.add(new Number2Domain("dec", ConversionPoint.BIG_DECIMAL, 30, 30, true));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, false));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, false));
        this.add(new TextDomain("tinytext", ConversionPoint.VARCHAR, 127L));
        this.add(new TextDomain("text", ConversionPoint.TEXT, 65535L));
        this.add(new TextDomain("longtext", ConversionPoint.CLOB, 0x800000L));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 255L, -1L, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 65535L, -1L, true));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 255L, -1L, true));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, 65535L));
        this.add(new BinaryDomain("tinyblob", ConversionPoint.BLOB, 127L));
        this.add(new BinaryDomain("longblob", ConversionPoint.BLOB, 0x800000L));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 65535L, -1L, true));
        this.add(new IntegerDomain("integer unsigned", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("int unsigned", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("bigint unsigned", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new Number2Domain("float", ConversionPoint.SINGLE_PRECISION, 53, 53, true));
        this.add(new Number2Domain("real", ConversionPoint.SINGLE_PRECISION, 53, 53, true));
    }
}

