/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.TextDomain;
import org.jetbrains.annotations.NotNull;

public class TextMaxDomain
extends TextDomain {
    private final long myMaxValue;

    /*
     * WARNING - void declaration
     */
    public TextMaxDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength, long maxValue, long l) {
        void defaultValue;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/TextMaxDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/TextMaxDomain", "<init>"));
        }
        super(name, descriptor, maxLength, (long)defaultValue, true);
        this.myMaxValue = maxValue;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.getLength() > this.myMaxValue ? this.simpleName() + "(MAX)" : super.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextMaxDomain", "name"));
        }
        return string;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/TextMaxDomain", "narrow"));
        }
        TextMaxDomain textMaxDomain = domain instanceof TextDomain ? new TextMaxDomain(this.simpleName(), this.getPoint(), Math.min(((TextDomain)domain).getLength(), this.getLength()), this.myMaxValue, this.getDefaultValue()) : this;
        if (textMaxDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextMaxDomain", "narrow"));
        }
        return textMaxDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/TextMaxDomain", "narrow"));
        }
        TextMaxDomain textMaxDomain = new TextMaxDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.getLength()), this.myMaxValue, this.getDefaultValue());
        if (textMaxDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextMaxDomain", "narrow"));
        }
        return textMaxDomain;
    }
}

