/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.DomainWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadOnlyDomain
extends Domain
implements DomainWrapper {
    private final Domain myDelegate;

    public ReadOnlyDomain(@NotNull Domain delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/data/types/domain/ReadOnlyDomain", "<init>"));
        }
        super(delegate.getPoint(), delegate.getDomainType(), delegate.simpleName());
        this.myDelegate = delegate;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality cardinality = this.myDelegate.cardinality();
        if (cardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/ReadOnlyDomain", "cardinality"));
        }
        return cardinality;
    }

    @Override
    @NotNull
    public Domain unwrap() {
        Domain domain = this.myDelegate;
        if (domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/ReadOnlyDomain", "unwrap"));
        }
        return domain;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/ReadOnlyDomain", "getCompatibility"));
        }
        Compatibility compatibility = Compatibility.uncompatible();
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/ReadOnlyDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/ReadOnlyDomain", "trim"));
        }
        return o;
    }
}

