/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.NumberDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Number2Domain
extends Domain {
    private final Cardinality.ScalableCardinality myCardinality;
    private final boolean myNarrowable;
    private final int myMaxPrecision;
    private final int myMaxScale;

    public Number2Domain(@NotNull String name, @NotNull ConversionPoint descriptor, int maxPrecision, int maxScale, boolean narrowable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/Number2Domain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/Number2Domain", "<init>"));
        }
        super(descriptor, PhysicalDomainType.NUMBER, name);
        this.myMaxPrecision = maxPrecision;
        this.myMaxScale = maxScale;
        this.myCardinality = new Cardinality.ScalableCardinality(maxPrecision);
        this.myNarrowable = narrowable;
    }

    public int getMaxPrecision() {
        return this.myMaxPrecision;
    }

    public int getMaxScale() {
        return this.myMaxScale;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Number2Domain", "getCompatibility"));
        }
        if (!(domain instanceof NumberDomain) && !(domain instanceof Number2Domain)) {
            Compatibility compatibility = Compatibility.uncompatible();
            if (compatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Number2Domain", "getCompatibility"));
            }
            return compatibility;
        }
        Compatibility compatibility = domain instanceof NumberDomain || !this.checkTwoParameter((Number2Domain)domain) ? Compatibility.compatibleLossy(this.cardinality(), this.getLogicType(), domain.getLogicType()) : Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Number2Domain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.ScalableCardinality scalableCardinality = this.myCardinality;
        if (scalableCardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Number2Domain", "cardinality"));
        }
        return scalableCardinality;
    }

    private boolean checkTwoParameter(@NotNull Number2Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Number2Domain", "checkTwoParameter"));
        }
        return domain.getMaxScale() <= this.myMaxScale && domain.getMaxPrecision() <= this.myMaxPrecision;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Number2Domain", "trim"));
        }
        DecimalFormat format = new DecimalFormat();
        format.setMaximumIntegerDigits(this.getMaxPrecision() - this.getMaxScale());
        format.setMaximumFractionDigits(this.getMaxScale());
        try {
            String formatted = format.format(o);
            return format.parse(formatted);
        }
        catch (IllegalArgumentException | ParseException exception) {
            return null;
        }
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/Number2Domain", "narrow"));
        }
        Number2Domain number2Domain = this.myNarrowable ? new Number2Domain(this.simpleName(), this.getPoint(), Math.min(provider.getSize(), Integer.MAX_VALUE), Math.min(provider.getScale(), Integer.MAX_VALUE), true) : this;
        if (number2Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Number2Domain", "narrow"));
        }
        return number2Domain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Number2Domain", "narrow"));
        }
        Number2Domain number2Domain = this.myNarrowable && domain instanceof Number2Domain ? new Number2Domain(this.simpleName(), this.getPoint(), Math.min(((Number2Domain)domain).getMaxPrecision(), this.getMaxPrecision()), Math.min(((Number2Domain)domain).getMaxScale(), this.getMaxScale()), true) : (this.myNarrowable && domain instanceof IntegerDomain ? new Number2Domain(this.simpleName(), this.getPoint(), this.getMaxPrecision(), 0, true) : (this.myNarrowable && domain instanceof NumberDomain ? new Number2Domain(this.simpleName(), this.getPoint(), this.getMaxPrecision(), this.getMaxScale() / 2, true) : this));
        if (number2Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Number2Domain", "narrow"));
        }
        return number2Domain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myNarrowable && this.getMaxPrecision() > 0 && this.getMaxScale() >= 0 ? this.simpleName() + "(" + this.getMaxPrecision() + "," + this.getMaxScale() + ")" : super.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Number2Domain", "name"));
        }
        return string;
    }
}

