/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Domain;
import org.jetbrains.annotations.NotNull;

public class BinaryMaxDomain
extends BinaryDomain {
    private final long myMaxValue;

    /*
     * WARNING - void declaration
     */
    public BinaryMaxDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long upperBound, long maxValue, long l) {
        void defaultValue;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/BinaryMaxDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/BinaryMaxDomain", "<init>"));
        }
        super(name, descriptor, upperBound, (long)defaultValue, true);
        this.myMaxValue = maxValue;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.getUpperBound() > this.myMaxValue ? this.simpleName() + "(MAX)" : super.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryMaxDomain", "name"));
        }
        return string;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/BinaryMaxDomain", "narrow"));
        }
        BinaryMaxDomain binaryMaxDomain = domain instanceof BinaryDomain ? new BinaryMaxDomain(this.simpleName(), this.getPoint(), Math.min(((BinaryDomain)domain).getUpperBound(), this.getUpperBound()), this.myMaxValue, this.getDefaultValue()) : this;
        if (binaryMaxDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryMaxDomain", "narrow"));
        }
        return binaryMaxDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/BinaryMaxDomain", "narrow"));
        }
        BinaryMaxDomain binaryMaxDomain = new BinaryMaxDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.myMaxValue), this.myMaxValue, this.getDefaultValue());
        if (binaryMaxDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryMaxDomain", "narrow"));
        }
        return binaryMaxDomain;
    }
}

