/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.datagrid.DataConsumer;
import org.jetbrains.annotations.NotNull;

public interface SizeProvider {
    public int getScale();

    public int getSize();

    public static class ColumnSizeProvider
    implements SizeProvider {
        private final DataConsumer.Column myColumn;

        public ColumnSizeProvider(@NotNull DataConsumer.Column column) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/data/types/SizeProvider$ColumnSizeProvider", "<init>"));
            }
            this.myColumn = column;
        }

        @Override
        public int getScale() {
            return this.myColumn.scale;
        }

        @Override
        public int getSize() {
            return this.myColumn.precision;
        }
    }
}

