/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.registry.Db2Domains;
import com.intellij.database.data.types.registry.DerbyDomains;
import com.intellij.database.data.types.registry.GenericDomains;
import com.intellij.database.data.types.registry.H2Domains;
import com.intellij.database.data.types.registry.HsqldbDomains;
import com.intellij.database.data.types.registry.MsSql05Domains;
import com.intellij.database.data.types.registry.MsSql08Domains;
import com.intellij.database.data.types.registry.MysqlDomains;
import com.intellij.database.data.types.registry.OracleDomains;
import com.intellij.database.data.types.registry.PostgresDomains;
import com.intellij.database.data.types.registry.SqliteDomains;
import com.intellij.database.data.types.registry.SybaseDomains;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomainRegistry {
    private static final SimpleDomain OBJECT_DOMAIN = new SimpleDomain("OBJECT_DOMAIN", ConversionPoint.UNKNOWN, PhysicalDomainType.UNKNOWN);
    private static final List<DomainRegistry> ourDomains = ContainerUtil.newArrayList();
    public static final Function<Domain, Comparator<Domain>> COMPARATOR_GENERATOR = domain -> (o1, o2) -> {
        Compatibility first = o1.getCompatibility((Domain)domain);
        Compatibility second = o2.getCompatibility((Domain)domain);
        return first.compareTo(second);
    };
    private final DatabaseDialect myDialect;
    private final Set<Domain> mySet;

    protected DomainRegistry(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/DomainRegistry", "<init>"));
        }
        this.myDialect = dialect;
        this.mySet = ContainerUtil.newLinkedHashSet();
        this.mySet.add(OBJECT_DOMAIN);
    }

    @NotNull
    public DatabaseDialect getDialect() {
        DatabaseDialect databaseDialect = this.myDialect;
        if (databaseDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DomainRegistry", "getDialect"));
        }
        return databaseDialect;
    }

    @Nullable
    public Domain getDomain(@NotNull ColumnDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/DomainRegistry", "getDomain"));
        }
        return (Domain)ContainerUtil.find(this.mySet, domain -> {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/DomainRegistry", "lambda$getDomain$2"));
            }
            return domain.isSuitable(descriptor);
        });
    }

    @NotNull
    public Collection<Domain> getDomains() {
        Set<Domain> set = Collections.unmodifiableSet(this.mySet);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DomainRegistry", "getDomains"));
        }
        return set;
    }

    public boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/DomainRegistry", "isSuitable"));
        }
        return this.myDialect == dialect;
    }

    protected final void add(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/DomainRegistry", "add"));
        }
        this.mySet.add(domain);
    }

    public static void init() {
        if (!ourDomains.isEmpty()) {
            return;
        }
        ourDomains.add(new Db2Domains());
        ourDomains.add(new DerbyDomains());
        ourDomains.add(new GenericDomains());
        ourDomains.add(new H2Domains());
        ourDomains.add(new HsqldbDomains());
        ourDomains.add(new MsSql05Domains());
        ourDomains.add(new MsSql08Domains());
        ourDomains.add(new MysqlDomains());
        ourDomains.add(new OracleDomains());
        ourDomains.add(new PostgresDomains());
        ourDomains.add(new SqliteDomains());
        ourDomains.add(new SybaseDomains());
    }

    @NotNull
    public static Domain getMostRecentDomain(@NotNull Domain domain, @NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/DomainRegistry", "getMostRecentDomain"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/DomainRegistry", "getMostRecentDomain"));
        }
        DomainRegistry.init();
        DomainRegistry resolver = DomainRegistry.get(dialect, productVersion);
        if (resolver == null) {
            Domain domain2 = Domain.EMPTY;
            if (domain2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DomainRegistry", "getMostRecentDomain"));
            }
            return domain2;
        }
        Collection<Domain> domains = resolver.getDomains();
        Domain unwrapped = DataGridUtil.unwrap(domain);
        List filtered = ContainerUtil.filter(domains, current -> current.contains(unwrapped));
        Comparator domainComparator = (Comparator)COMPARATOR_GENERATOR.fun((Object)unwrapped);
        ContainerUtil.sort((List)filtered, (Comparator)domainComparator);
        Domain item = (Domain)ContainerUtil.getFirstItem((List)filtered);
        Domain domain3 = item == null ? Domain.EMPTY : item.narrow(unwrapped);
        if (domain3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DomainRegistry", "getMostRecentDomain"));
        }
        return domain3;
    }

    @Nullable
    public static DomainRegistry get(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/DomainRegistry", "get"));
        }
        DomainRegistry.init();
        for (DomainRegistry resolver : ourDomains) {
            if (!resolver.isSuitable(dialect, productVersion)) continue;
            return resolver;
        }
        return null;
    }

    public static class Limit {
        private final Number myMaxParameter;
        private final Number myMaxValue;
        private final Number myMinValue;

        public Limit(@NotNull Number maxParameter, @NotNull Number minValue, @NotNull Number maxValue) {
            if (maxParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxParameter", "com/intellij/database/data/types/DomainRegistry$Limit", "<init>"));
            }
            if (minValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minValue", "com/intellij/database/data/types/DomainRegistry$Limit", "<init>"));
            }
            if (maxValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxValue", "com/intellij/database/data/types/DomainRegistry$Limit", "<init>"));
            }
            this.myMaxParameter = maxParameter;
            this.myMaxValue = maxValue;
            this.myMinValue = minValue;
        }

        @NotNull
        public Number getMaxParameter() {
            Number number = this.myMaxParameter;
            if (number == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DomainRegistry$Limit", "getMaxParameter"));
            }
            return number;
        }

        @NotNull
        public Number getMaxValue() {
            Number number = this.myMaxValue;
            if (number == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DomainRegistry$Limit", "getMaxValue"));
            }
            return number;
        }

        @NotNull
        public Number getMinValue() {
            Number number = this.myMinValue;
            if (number == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DomainRegistry$Limit", "getMinValue"));
            }
            return number;
        }
    }
}

