/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataTypeConversion {
    private final DatabaseDialect myFirstDialect;
    private final DatabaseSystem myFirstSystem;
    private final DataConsumer.Column myFirstColumn;
    private final Object myObject;
    private final DatabaseDialect mySecondDialect;
    private final DatabaseSystem mySecondSystem;
    private final DataGrid mySecondGrid;
    private final ModelIndex<DataConsumer.Column> mySecondColumnIdx;
    private final ModelIndex<DataConsumer.Row> mySecondRowIdx;

    public DataTypeConversion(@NotNull DatabaseDialect firstDialect, @Nullable DatabaseSystem firstSystem, @NotNull DataConsumer.Column firstColumn, @NotNull DatabaseDialect secondDialect, @Nullable DatabaseSystem secondSystem, @NotNull ModelIndex<DataConsumer.Column> secondColIdx, @NotNull ModelIndex<DataConsumer.Row> secondRowIdx, @NotNull DataGrid grid, @Nullable Object object) {
        if (firstDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstDialect", "com/intellij/database/data/types/DataTypeConversion", "<init>"));
        }
        if (firstColumn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstColumn", "com/intellij/database/data/types/DataTypeConversion", "<init>"));
        }
        if (secondDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondDialect", "com/intellij/database/data/types/DataTypeConversion", "<init>"));
        }
        if (secondColIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondColIdx", "com/intellij/database/data/types/DataTypeConversion", "<init>"));
        }
        if (secondRowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondRowIdx", "com/intellij/database/data/types/DataTypeConversion", "<init>"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/data/types/DataTypeConversion", "<init>"));
        }
        this.myFirstDialect = firstDialect;
        this.myFirstSystem = firstSystem;
        this.myFirstColumn = firstColumn;
        this.mySecondSystem = secondSystem;
        this.myObject = object;
        this.mySecondDialect = secondDialect;
        this.mySecondColumnIdx = secondColIdx;
        this.mySecondRowIdx = secondRowIdx;
        this.mySecondGrid = grid;
    }

    @NotNull
    public CellMutation.Builder convert() {
        Object unwrapped = ObjectFormatter.unwrap(this.myObject);
        CellMutation.Builder builder = new CellMutation.Builder().row(this.mySecondRowIdx).column(this.mySecondColumnIdx).value(null);
        DataConsumer.Column column = this.mySecondGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(this.mySecondColumnIdx);
        DomainRegistry firstResolver = DomainRegistry.get(this.myFirstDialect, DataTypeConversion.version(this.myFirstSystem));
        DomainRegistry secondResolver = DomainRegistry.get(this.mySecondDialect, DataTypeConversion.version(this.mySecondSystem));
        if (column == null || firstResolver == null || secondResolver == null) {
            CellMutation.Builder builder2 = builder;
            if (builder2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion", "convert"));
            }
            return builder2;
        }
        Domain firstDomain = firstResolver.getDomain(this.myFirstColumn);
        Domain secondDomain = secondResolver.getDomain(column);
        if (firstDomain == null || secondDomain == null) {
            CellMutation.Builder builder3 = builder;
            if (builder3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion", "convert"));
            }
            return builder3;
        }
        Function<Object, Object> converter = ConversionGraph.getConverter(unwrapped, firstDomain, secondDomain = secondDomain.narrow(new SizeProvider.ColumnSizeProvider(column)));
        CellMutation.Builder builder4 = converter == null ? builder : builder.value(converter.fun(unwrapped));
        if (builder4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion", "convert"));
        }
        return builder4;
    }

    public boolean isValid() {
        return this.mySecondColumnIdx.isValid(this.mySecondGrid) && this.mySecondRowIdx.isValid(this.mySecondGrid);
    }

    @Nullable
    private static String version(@Nullable DatabaseSystem system) {
        return system == null ? null : system.getDatabaseProductVersion();
    }

    public static class Builder {
        private DatabaseDialect myFirstDialect;
        private DataConsumer.Column myFirstColumn;
        private ViewIndex<DataConsumer.Row> myFirstRowIdx;
        private ViewIndex<DataConsumer.Column> myFirstColumnIdx;
        private DatabaseSystem myFirstSystem;
        private Object myObject;
        private DatabaseDialect mySecondDialect;
        private DataGrid mySecondGrid;
        private DatabaseSystem mySecondSystem;
        private ModelIndex<DataConsumer.Column> mySecondColumnIdx;
        private ModelIndex<DataConsumer.Row> mySecondRowIdx;

        @NotNull
        public Builder firstDialect(@NotNull DatabaseDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstDialect"));
            }
            this.myFirstDialect = dialect;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstDialect"));
            }
            return builder;
        }

        @NotNull
        public Builder firstColumn(@NotNull DataConsumer.Column column) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstColumn"));
            }
            this.myFirstColumn = column;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstColumn"));
            }
            return builder;
        }

        @NotNull
        public Builder firstRowIdx(@NotNull ViewIndex<DataConsumer.Row> rowIdx) {
            if (rowIdx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstRowIdx"));
            }
            this.myFirstRowIdx = rowIdx;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstRowIdx"));
            }
            return builder;
        }

        @NotNull
        public Builder firstColumnIdx(@NotNull ViewIndex<DataConsumer.Column> columnIdx) {
            if (columnIdx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstColumnIdx"));
            }
            this.myFirstColumnIdx = columnIdx;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstColumnIdx"));
            }
            return builder;
        }

        public Builder value(@Nullable Object value) {
            this.myObject = value;
            return this;
        }

        public Builder secondDialect(@NotNull DatabaseDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/DataTypeConversion$Builder", "secondDialect"));
            }
            this.mySecondDialect = dialect;
            return this;
        }

        @NotNull
        public Builder secondGrid(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/data/types/DataTypeConversion$Builder", "secondGrid"));
            }
            this.mySecondGrid = grid;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "secondGrid"));
            }
            return builder;
        }

        public Builder secondColumnIndex(@NotNull ModelIndex<DataConsumer.Column> idx) {
            if (idx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idx", "com/intellij/database/data/types/DataTypeConversion$Builder", "secondColumnIndex"));
            }
            this.mySecondColumnIdx = idx;
            return this;
        }

        @NotNull
        public Builder secondRowIdx(@NotNull ModelIndex<DataConsumer.Row> idx) {
            if (idx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idx", "com/intellij/database/data/types/DataTypeConversion$Builder", "secondRowIdx"));
            }
            this.mySecondRowIdx = idx;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "secondRowIdx"));
            }
            return builder;
        }

        @NotNull
        public Builder offset(int rows, int columns) {
            this.secondRowIdx(ViewIndex.forRow(this.mySecondGrid, (this.myFirstRowIdx == null ? 0 : this.myFirstRowIdx.asInteger()) + rows).toModel(this.mySecondGrid));
            Builder builder = this.secondColumnIndex(ViewIndex.forColumn(this.mySecondGrid, (this.myFirstColumnIdx == null ? 0 : this.myFirstColumnIdx.asInteger()) + columns).toModel(this.mySecondGrid));
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "offset"));
            }
            return builder;
        }

        @NotNull
        public Builder firstSystem(@Nullable DatabaseSystem system) {
            this.myFirstSystem = system;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "firstSystem"));
            }
            return builder;
        }

        @NotNull
        public Builder secondSystem(@Nullable DatabaseSystem system) {
            this.mySecondSystem = system;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "secondSystem"));
            }
            return builder;
        }

        @NotNull
        public DataTypeConversion build() {
            DataTypeConversion dataTypeConversion = new DataTypeConversion(this.myFirstDialect, this.myFirstSystem, this.myFirstColumn, this.mySecondDialect, this.mySecondSystem, this.mySecondColumnIdx, this.mySecondRowIdx, this.mySecondGrid, this.myObject);
            if (dataTypeConversion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataTypeConversion$Builder", "build"));
            }
            return dataTypeConversion;
        }
    }
}

