/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.Formatter;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;

public class ConverterSupport {
    private static final Formatter TIMESTAMP_FORMATTER = FormatterCreator.newEraZonedTsFormat(new TimestampDelegate(), null, 6);
    private static final Formatter DATE_FORMATTER = FormatterCreator.newEraDateFormatter(new DateDelegate(), null, null);
    private static final Formatter TIME_FORMATTER = new CompositeFormatter(FormatterCreator.newZonedTimeFormat(new TimeDelegate()), FormatterCreator.newZonedTimeFormat(new TimeDelegate()), FormatterCreator.newTimeFormat(new TimeDelegate()));

    private ConverterSupport() {
    }

    @NotNull
    public static Formatter getTimestampFormatter() {
        Formatter formatter = TIMESTAMP_FORMATTER;
        if (formatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/ConverterSupport", "getTimestampFormatter"));
        }
        return formatter;
    }

    @NotNull
    public static Formatter getTimeFormatter() {
        Formatter formatter = TIME_FORMATTER;
        if (formatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/ConverterSupport", "getTimeFormatter"));
        }
        return formatter;
    }

    @NotNull
    public static Formatter getDateFormatter() {
        Formatter formatter = DATE_FORMATTER;
        if (formatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/ConverterSupport", "getDateFormatter"));
        }
        return formatter;
    }

    private static class DateDelegate
    extends DateAndTimeFormatterDelegate<java.util.Date, LocalDate> {
        DateDelegate() {
            super(LocalDate::from);
        }

        @Override
        protected LocalDate toTemporalAccessor(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/ConverterSupport$DateDelegate", "toTemporalAccessor"));
            }
            if (!(value instanceof java.util.Date)) {
                throw new IllegalArgumentException(String.format("Value class is not Date: %s", value.getClass()));
            }
            return value instanceof Date ? ((Date)value).toLocalDate() : LocalDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)value).getTime()), ZoneId.systemDefault()).toLocalDate();
        }

        @Override
        protected java.util.Date create(@NotNull LocalDate value, @NotNull String stringRepresentation) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/ConverterSupport$DateDelegate", "create"));
            }
            if (stringRepresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/data/types/ConverterSupport$DateDelegate", "create"));
            }
            return Date.valueOf(value);
        }
    }

    private static class TimeDelegate
    extends DateAndTimeFormatterDelegate<TemporalAccessor, TemporalAccessor> {
        TimeDelegate() {
            super(OffsetTime::from, temporal -> LocalTime.from(temporal).atOffset(OffsetDateTime.now().getOffset()));
        }

        @Override
        protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/ConverterSupport$TimeDelegate", "toTemporalAccessor"));
            }
            if (!(value instanceof TemporalAccessor)) {
                throw new IllegalArgumentException(String.format("Value class is not TemporalAccessor: %s", value.getClass()));
            }
            return (TemporalAccessor)value;
        }

        @Override
        protected TemporalAccessor create(@NotNull TemporalAccessor value, @NotNull String stringRepresentation) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/ConverterSupport$TimeDelegate", "create"));
            }
            if (stringRepresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/data/types/ConverterSupport$TimeDelegate", "create"));
            }
            return value;
        }
    }

    private static class TimestampDelegate
    extends DateAndTimeFormatterDelegate<TemporalAccessor, TemporalAccessor> {
        TimestampDelegate() {
            super(OffsetDateTime::from, LocalDateTime::from, temporal -> LocalDate.from(temporal).atTime(0, 0, 0));
        }

        @Override
        protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/ConverterSupport$TimestampDelegate", "toTemporalAccessor"));
            }
            if (!(value instanceof TemporalAccessor)) {
                throw new IllegalArgumentException(String.format("Value class is not TemporalAccessor: %s", value.getClass()));
            }
            return value instanceof LocalDateTime ? ((LocalDateTime)value).atOffset(ZoneOffset.UTC) : (TemporalAccessor)value;
        }

        @Override
        protected TemporalAccessor create(@NotNull TemporalAccessor value, @NotNull String stringRepresentation) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/ConverterSupport$TimestampDelegate", "create"));
            }
            if (stringRepresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/data/types/ConverterSupport$TimestampDelegate", "create"));
            }
            return value instanceof ZonedDateTime ? ((ZonedDateTime)value).toOffsetDateTime() : value;
        }
    }
}

