/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtilRt;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextView {
    private final Editor myEditor;

    public TextView(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/preview/TextView", "<init>"));
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)""), parent);
    }

    public TextView(@NotNull Document document, @NotNull Disposable parent) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/csv/ui/preview/TextView", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/preview/TextView", "<init>"));
        }
        this.myEditor = EditorFactory.getInstance().createEditor(document);
        this.myEditor.getSettings().setRightMarginShown(false);
        this.myEditor.getSettings().setLineNumbersShown(true);
        this.myEditor.getSettings().setLineMarkerAreaShown(false);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                EditorFactory.getInstance().releaseEditor(TextView.this.myEditor);
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/preview/TextView", "getComponent"));
        }
        return jComponent;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/csv/ui/preview/TextView", "setText"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/csv/ui/preview/TextView", "lambda$setText$0"));
            }
            this.myEditor.getDocument().setText((CharSequence)StringUtilRt.convertLineSeparators((String)text));
        });
    }
}

