/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpConfigurationImpl;
import com.intellij.database.dump.dbdump.DumpDialog;
import com.intellij.database.dump.dbdump.DumpManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeDumpAction
extends DumbAwareAction {
    private static final String TEXT_PATTERN = "Dump with \"%s\"";

    public void update(AnActionEvent e) {
        boolean enabled = NativeDumpAction.isEnabled(e);
        e.getPresentation().setEnabledAndVisible(enabled);
        if (!enabled) {
            return;
        }
        DbDataSource dataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)NativeDumpAction.getDataSource(e));
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)ObjectUtils.assertNotNull((Object)dataSource));
        DumpConfigurationImpl configuration = DumpConfigurationImpl.of(dialect);
        if (configuration == null) {
            return;
        }
        e.getPresentation().setText(String.format(TEXT_PATTERN, StringUtil.escapeMnemonics((String)configuration.getName())));
    }

    public void actionPerformed(AnActionEvent e) {
        DumpManager manager;
        if (!NativeDumpAction.isEnabled(e)) {
            return;
        }
        DbDataSource dataSource = NativeDumpAction.getDataSource(e);
        if (dataSource == null) {
            return;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        DumpConfigurationImpl configuration = DumpConfigurationImpl.of(dialect);
        if (configuration == null) {
            return;
        }
        Collection<DbElement> selected = NativeDumpAction.getProcessedElements(e, configuration);
        Project project = (Project)ObjectUtils.assertNotNull((Object)e.getProject());
        DumpDialog dialog = new DumpDialog(dataSource, project, manager = new DumpManager(dataSource, selected, project, configuration), configuration);
        if (dialog.showAndGet()) {
            manager.dump();
        }
        Disposer.dispose((Disposable)manager);
    }

    @NotNull
    private static Collection<DbElement> getSelectedElements(@Nullable Project project) {
        if (project == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
            }
            return list;
        }
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        if (view2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
            }
            return list;
        }
        Set elements = view2.getTreeBuilder().getSelectedElements();
        HashSet result = ContainerUtil.newHashSet(NativeDumpAction.expandFolders(elements));
        result.addAll(NativeDumpAction.getDbElements(elements));
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
        }
        return hashSet;
    }

    @NotNull
    private static Collection<? extends DbElement> expandFolders(@NotNull Collection<Object> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/actions/NativeDumpAction", "expandFolders"));
        }
        List list = JBIterable.from(elements).filter(DatabaseStructure.GroupElement.class).filter(element -> element.getParent() instanceof DbNamespaceImpl).flatMap(element -> {
            DbElement parent = (DbElement)element.getParent();
            ObjectKind kind = element.getChildKind();
            return DbImplUtil.isDataTable(kind) ? parent.getDbChildren(DbTable.class, kind) : JBIterable.of((Object)parent);
        }).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "expandFolders"));
        }
        return list;
    }

    @NotNull
    private static Collection<DbElement> getDbElements(@NotNull Collection<Object> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/actions/NativeDumpAction", "getDbElements"));
        }
        List list = JBIterable.from(elements).filter(DbElement.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getDbElements"));
        }
        return list;
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "isEnabled"));
        }
        DbDataSource dataSource = NativeDumpAction.getDataSource(e);
        if (dataSource == null || !(dataSource.getDelegate() instanceof LocalDataSource)) {
            return false;
        }
        LocalDataSource local = (LocalDataSource)dataSource.getDelegate();
        if (!NativeDumpAction.isHostAndPortExists(local)) {
            return false;
        }
        DumpConfigurationImpl configuration = DumpConfigurationImpl.of(DbImplUtil.getDatabaseDialect((DbElement)dataSource));
        return configuration != null && !NativeDumpAction.getProcessedElements(e, configuration).isEmpty() && e.getProject() != null;
    }

    @NotNull
    private static Collection<DbElement> getProcessedElements(@NotNull AnActionEvent e, @NotNull DumpConfiguration configuration) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "getProcessedElements"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/actions/NativeDumpAction", "getProcessedElements"));
        }
        List selected = ContainerUtil.filter(NativeDumpAction.getSelectedElements(e.getProject()), DbImplUtil::canConnectTo);
        Collection<DbElement> collection = configuration.filterElements(selected);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getProcessedElements"));
        }
        return collection;
    }

    private static boolean isHostAndPortExists(@NotNull LocalDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/actions/NativeDumpAction", "isHostAndPortExists"));
        }
        DatabaseDriver driver = source.getDatabaseDriver();
        RawConnectionConfig config = source.getConnectionConfig();
        if (config == null || driver == null) {
            return false;
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(parsers, config.getUrl(), (Ref<JdbcUrlParser>)Ref.create());
        return hostPort != null && hostPort.first != null && hostPort.second != null;
    }

    @Nullable
    private static DbDataSource getDataSource(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "getDataSource"));
        }
        Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        HashSet sources = ContainerUtil.newHashSet();
        elements.forEach(element -> sources.add(element.getDataSource()));
        return sources.size() == 1 ? (DbDataSource)ContainerUtil.getFirstItem((Collection)sources) : null;
    }
}

