/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;

public abstract class ColumnsWidthAction
extends DumbAwareAction
implements GridAction {
    private static final int DELTA = 8;

    public void update(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid != null) {
            ModelIndexSet<Object> columns;
            ModelIndexSet<Object> modelIndexSet = columns = dataGrid.isTransposed() ? dataGrid.getSelectionModel().getSelectedRows() : dataGrid.getSelectionModel().getSelectedColumns();
            if (columns.size() != 0) {
                e.getPresentation().setEnabledAndVisible(true);
            }
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid != null) {
            dataGrid.changeSelectedColumnsWidth(this.getDelta());
        }
    }

    abstract int getDelta();

    public static class IncreaseColumnsWidthAction
    extends ColumnsWidthAction {
        @Override
        int getDelta() {
            return 8;
        }
    }

    public static class DecreaseColumnsWidthAction
    extends ColumnsWidthAction {
        @Override
        int getDelta() {
            return -8;
        }
    }
}

