/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coding;

import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class CodeTextBuilder {
    @NotNull
    private String myIndentation = "\t";
    @NotNull
    private String myCurrentIndent = "";
    @NotNull
    private LinkedList<String> myIndentStack = new LinkedList();
    @NotNull
    private StringBuilder myTextBuffer = new StringBuilder(1024);

    @NotNull
    public String getIndentation() {
        String string = this.myIndentation;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coding/CodeTextBuilder", "getIndentation"));
        }
        return string;
    }

    public void setIndentation(@NotNull String indentation) {
        if (indentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentation", "com/intellij/coding/CodeTextBuilder", "setIndentation"));
        }
        this.myIndentation = indentation;
    }

    public void indent() {
        this.indent(this.myIndentation);
    }

    public void indent(@NotNull String indent) {
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/coding/CodeTextBuilder", "indent"));
        }
        this.myIndentStack.push(this.myCurrentIndent);
        this.myCurrentIndent = this.myCurrentIndent + indent;
    }

    public void unindent() {
        if (this.myIndentStack.isEmpty()) {
            throw new IllegalStateException("Unmatched unindent.");
        }
        this.myCurrentIndent = this.myIndentStack.pop();
    }

    public void addText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/coding/CodeTextBuilder", "addText"));
        }
        this.myTextBuffer.append(this.myCurrentIndent);
        int pos = this.myTextBuffer.length();
        this.myTextBuffer.append(text);
        while (this.myTextBuffer.charAt(this.myTextBuffer.length() - 1) == '\n') {
            this.myTextBuffer.deleteCharAt(this.myTextBuffer.length() - 1);
        }
        for (int i2 = this.myTextBuffer.length() - 1; i2 >= pos; --i2) {
            char c = this.myTextBuffer.charAt(i2);
            if (c != '\n') continue;
            this.myTextBuffer.insert(i2 + 1, this.myCurrentIndent);
        }
        this.myTextBuffer.append('\n');
    }

    @NotNull
    public String getText() {
        String string = this.myTextBuffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coding/CodeTextBuilder", "getText"));
        }
        return string;
    }

    public String toString() {
        return this.getText();
    }

    public void clearAll() {
        this.myIndentStack.clear();
        this.myCurrentIndent = "";
        this.myTextBuffer.delete(0, this.myTextBuffer.length());
    }
}

