/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DiagramNodeHeaderComponent
extends GradientFilledPanel {
    public DiagramNodeHeaderComponent(DiagramNode node, DiagramBuilder builder) {
        super(DiagramNodeHeaderComponent.getColor(node, builder));
        int style;
        Object element = node.getIdentifyingElement();
        SimpleColoredComponent label = new SimpleColoredComponent(){

            protected boolean shouldDrawMacShadow() {
                return !GraphViewUtil.isPrintMode() && (super.shouldDrawMacShadow() || UIUtil.isUnderDarcula());
            }
        };
        label.setIcon(node.getIcon());
        if (GraphViewUtil.isPrintMode()) {
            label.setForeground((Color)JBColor.BLACK);
        }
        DiagramElementManager manager = builder.getProvider().getElementManager();
        String presentableName = manager.getElementTitle(element);
        int n = style = manager instanceof AbstractDiagramElementManager ? ((AbstractDiagramElementManager)manager).getTitleAttributes(element) : 0;
        if (presentableName != null) {
            if (GraphViewUtil.isPrintMode()) {
                label.append(presentableName, new SimpleTextAttributes(style, (Color)JBColor.BLACK));
            } else {
                label.append(presentableName, new SimpleTextAttributes(style, null));
            }
        }
        label.setAlignmentX(0.0f);
        label.setOpaque(false);
        label.setIconOpaque(false);
        JPanel wrap = new JPanel(new BorderLayout());
        wrap.add((Component)label, "Center");
        wrap.setOpaque(false);
        wrap.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        this.setLayout(new BorderLayout());
        this.add(wrap, "Center");
        label.setForeground(DiagramNodeHeaderComponent.getElementColor(node.getIdentifyingElement()));
        this.setFocusable(false);
    }

    @NotNull
    protected static Color getElementColor(@NotNull Object element) {
        PsiFile containingFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/diagram/components/DiagramNodeHeaderComponent", "getElementColor"));
        }
        Color color = null;
        if (element instanceof PsiElement && ((PsiElement)element).isValid() && (containingFile = ((PsiElement)element).getContainingFile()) != null) {
            VirtualFile file = containingFile.getVirtualFile();
            if (file == null) {
                Color color2 = JBColor.foreground();
                if (color2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/components/DiagramNodeHeaderComponent", "getElementColor"));
                }
                return color2;
            }
            color = FileStatusManager.getInstance((Project)((PsiElement)element).getProject()).getStatus(file).getColor();
        }
        Color color3 = color == null ? JBColor.foreground() : color;
        if (color3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/components/DiagramNodeHeaderComponent", "getElementColor"));
        }
        return color3;
    }

    private static Color getColor(DiagramNode node, DiagramBuilder builder) {
        return builder.getProvider().getColorManager().getNodeHeaderColor(builder, node);
    }
}

