/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.SdkConstants;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.PackageParserUtils;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.OptionalLibraryImpl;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlatformTarget
implements IAndroidTarget {
    public static final String PLATFORM_VENDOR = "Android Open Source Project";
    private static final String PLATFORM_NAME = "Android %s";
    private static final String PLATFORM_NAME_PREVIEW = "Android %s (Preview)";
    private LocalPackage mPackage;
    private DetailsTypes.PlatformDetailsType mDetails;
    private List<IAndroidTarget.OptionalLibrary> mOptionalLibraries = ImmutableList.of();
    private Set<File> mSkins;
    private Map<String, String> mBuildProps;
    private BuildToolInfo mBuildToolInfo;
    private File mSourcesPath = null;

    public PlatformTarget(LocalPackage p, AndroidSdkHandler sdkHandler, FileOp fop, ProgressIndicator progress) {
        File buildProp;
        File optionalJson;
        this.mPackage = p;
        TypeDetails details = p.getTypeDetails();
        assert (details instanceof DetailsTypes.PlatformDetailsType);
        this.mDetails = (DetailsTypes.PlatformDetailsType)details;
        File optionalDir = new File(p.getLocation(), "optional");
        if (optionalDir.isDirectory() && (optionalJson = new File(optionalDir, "optional.json")).isFile()) {
            this.mOptionalLibraries = PlatformTarget.getLibsFromJson(optionalJson);
        }
        if (!fop.isFile(buildProp = new File(this.getLocation(), "build.prop"))) {
            String message = "Build properties not found for package " + p.getDisplayName();
            progress.logWarning(message);
            throw new IllegalArgumentException(message);
        }
        try {
            this.mBuildProps = ProjectProperties.parsePropertyStream(fop.newFileInputStream(buildProp), buildProp.getPath(), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mBuildProps == null) {
            this.mBuildProps = Maps.newHashMap();
        }
        this.mBuildToolInfo = sdkHandler.getLatestBuildTool(progress, this.getVersion().isPreview());
        this.mSkins = Sets.newTreeSet(PackageParserUtils.parseSkinFolder(this.getFile(5), fop));
    }

    public void setSources(File location) {
        this.mSourcesPath = location;
    }

    static List<IAndroidTarget.OptionalLibrary> getLibsFromJson(File jsonFile) {
        Gson gson = new Gson();
        try {
            Type collectionType = new TypeToken<Collection<Library>>(){}.getType();
            Collection libs = (Collection)gson.fromJson((Reader)Files.newReader((File)jsonFile, (Charset)Charsets.UTF_8), collectionType);
            ArrayList optionalLibraries = Lists.newArrayListWithCapacity((int)libs.size());
            File rootFolder = jsonFile.getParentFile();
            for (Library lib : libs) {
                optionalLibraries.add(new OptionalLibraryImpl(lib.name, new File(rootFolder, lib.jar), lib.name, lib.manifest));
            }
            return optionalLibraries;
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public String getLocation() {
        return this.mPackage.getLocation().getPath() + File.separator;
    }

    @Override
    public String getVendor() {
        return PLATFORM_VENDOR;
    }

    @Override
    public String getName() {
        AndroidVersion version = this.getVersion();
        if (version.isPreview()) {
            return String.format(PLATFORM_NAME_PREVIEW, version);
        }
        return String.format(PLATFORM_NAME, version);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mDetails.getAndroidVersion();
    }

    @Override
    public String getVersionName() {
        return SdkVersionInfo.getVersionString(this.mDetails.getApiLevel());
    }

    @Override
    public int getRevision() {
        return this.mPackage.getVersion().getMajor();
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public String getPath(int pathId) {
        switch (pathId) {
            case 1: {
                return this.getLocation() + "android.jar";
            }
            case 27: {
                return this.getLocation() + "uiautomator.jar";
            }
            case 18: {
                if (this.mSourcesPath != null) {
                    return this.mSourcesPath.getPath();
                }
                return this.getLocation() + "sources";
            }
            case 2: {
                return this.getLocation() + "framework.aidl";
            }
            case 4: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_SAMPLES_FOLDER;
            }
            case 5: {
                return this.getLocation() + SdkConstants.OS_SKINS_FOLDER;
            }
            case 6: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_TEMPLATES_FOLDER;
            }
            case 7: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER;
            }
            case 8: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_ATTRS_XML;
            }
            case 9: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_ATTRS_MANIFEST_XML;
            }
            case 11: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_RESOURCES_FOLDER;
            }
            case 12: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_FONTS_FOLDER;
            }
            case 10: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + "layoutlib.jar";
            }
            case 13: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + "widgets.txt";
            }
            case 14: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + "activity_actions.txt";
            }
            case 15: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + "broadcast_actions.txt";
            }
            case 16: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + "service_actions.txt";
            }
            case 17: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + "categories.txt";
            }
            case 24: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_ANT_FOLDER;
            }
        }
        return this.getLocation();
    }

    @Override
    public File getFile(int pathId) {
        return new File(this.getPath(pathId));
    }

    @Override
    public BuildToolInfo getBuildToolInfo() {
        return this.mBuildToolInfo;
    }

    @Override
    public List<String> getBootClasspath() {
        return ImmutableList.of((Object)this.getPath(1));
    }

    @Override
    public List<IAndroidTarget.OptionalLibrary> getOptionalLibraries() {
        return this.mOptionalLibraries;
    }

    @Override
    public List<IAndroidTarget.OptionalLibrary> getAdditionalLibraries() {
        return ImmutableList.of();
    }

    @Override
    public boolean hasRenderingLibrary() {
        return true;
    }

    @Override
    public File[] getSkins() {
        return this.mSkins.toArray(new File[this.mSkins.size()]);
    }

    public int getLayoutlibApi() {
        return this.mDetails.getLayoutlib().getApi();
    }

    @Override
    public File getDefaultSkin() {
        if (this.mSkins.size() == 1) {
            return this.mSkins.iterator().next();
        }
        String skinName = this.getVersion().getApiLevel() >= 11 && this.getVersion().getApiLevel() <= 13 ? "WXGA" : (this.getVersion().getApiLevel() >= 4 ? "WVGA800" : "HVGA");
        return new File(this.getFile(5), skinName);
    }

    @Override
    public String[] getPlatformLibraries() {
        return new String[]{"android.test.runner"};
    }

    @Override
    public String getProperty(String name) {
        return this.mBuildProps.get(name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mBuildProps;
    }

    @Override
    public String getShortClasspathName() {
        return this.getName();
    }

    @Override
    public String getClasspathName() {
        return this.getName();
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        if (this.getVersion().isPreview()) {
            return target.getVersion().equals((Object)this.getVersion());
        }
        return target.getVersion().getApiLevel() > this.getVersion().getApiLevel();
    }

    @Override
    public String hashString() {
        return AndroidTargetHash.getPlatformHashString(this.getVersion());
    }

    @Override
    public int compareTo(IAndroidTarget o) {
        int res = this.getVersion().compareTo(o.getVersion());
        if (res != 0) {
            return res;
        }
        return o.isPlatform() ? 0 : -1;
    }

    public boolean equals(Object obj) {
        return obj instanceof PlatformTarget && this.compareTo((PlatformTarget)obj) == 0;
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }

    public static class Library {
        String name;
        String jar;
        boolean manifest;
    }
}

