/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.expr.SymbolExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import com.google.common.collect.Lists;
import java.util.List;

public class MathExpr
extends Expr {
    static final String DYNAMIC_UTIL = "android.databinding.DynamicUtil";
    final String mOp;

    MathExpr(Expr left, String op, Expr right) {
        super(left, right);
        this.mOp = op;
    }

    @Override
    protected String computeUniqueKey() {
        return MathExpr.join(this.getLeft().getUniqueKey(), this.mOp, this.getRight().getUniqueKey());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if ("+".equals(this.mOp) && (this.getLeft().getResolvedType().isString() || this.getRight().getResolvedType().isString())) {
            return modelAnalyzer.findClass(String.class);
        }
        return modelAnalyzer.findCommonParentOf(this.getLeft().getResolvedType(), this.getRight().getResolvedType());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public Expr getLeft() {
        return this.getChildren().get(0);
    }

    public Expr getRight() {
        return this.getChildren().get(1);
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("(", this.getLeft().toCode()).app(") ").app(this.mOp).app(" (", this.getRight().toCode()).app(")");
    }

    @Override
    public String getInvertibleError() {
        Expr dyn;
        if (this.mOp.equals("%")) {
            return "The modulus operator (%) is not supported in two-way binding.";
        }
        Expr left = this.getLeft();
        Expr right = this.getRight();
        if (left.isDynamic() == right.isDynamic()) {
            return "Two way binding with operator " + this.mOp + " supports only a single dynamic expressions.";
        }
        Expr expr = dyn = left.isDynamic() ? left : right;
        if (this.getResolvedType().isString()) {
            Expr constExpr;
            Expr expr2 = constExpr = left.isDynamic() ? right : left;
            if (!(constExpr instanceof SymbolExpr) || !"\"\"".equals(((SymbolExpr)constExpr).getText())) {
                return "Two-way binding with string concatenation operator (+) only supports the empty string constant (`` or \"\")";
            }
            if (!dyn.getResolvedType().unbox().isPrimitive()) {
                return "Two-way binding with string concatenation operator (+) only supports primitives";
            }
        }
        return dyn.getInvertibleError();
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        Expr newValue;
        Expr left = this.getLeft();
        Expr right = this.getRight();
        Preconditions.check(left.isDynamic() ^ right.isDynamic(), "Two-way binding of a math operations requires A single dynamic expression. Neither or both sides are dynamic: (%s) %s (%s)", left, this.mOp, right);
        Expr constExpr = (left.isDynamic() ? right : left).cloneToModel(model);
        Expr varExpr = left.isDynamic() ? left : right;
        switch (this.mOp.charAt(0)) {
            case '+': {
                if (this.getResolvedType().isString()) {
                    newValue = this.parseInverse(model, value, varExpr);
                    break;
                }
                newValue = model.math(value, "-", constExpr);
                break;
            }
            case '*': {
                newValue = model.math(value, "/", constExpr);
                break;
            }
            case '-': {
                if (!left.isDynamic()) {
                    newValue = model.math(constExpr, "-", value);
                    break;
                }
                newValue = model.math(value, "+", constExpr);
                break;
            }
            case '/': {
                if (!left.isDynamic()) {
                    newValue = model.math(constExpr, "/", value);
                    break;
                }
                newValue = model.math(value, "*", constExpr);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid math operation is not invertible: " + this.mOp);
            }
        }
        return varExpr.generateInverse(model, newValue, bindingClassName);
    }

    private Expr parseInverse(ExprModel model, Expr value, Expr prev) {
        StaticIdentifierExpr dynamicUtil = model.staticIdentifier(DYNAMIC_UTIL);
        dynamicUtil.setUserDefinedType(DYNAMIC_UTIL);
        return model.methodCall(dynamicUtil, "parse", Lists.newArrayList((Object[])new Expr[]{value, prev}));
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.math(this.getLeft().cloneToModel(model), this.mOp, this.getRight().cloneToModel(model));
    }

    @Override
    public String toString() {
        return "(" + this.getLeft() + ") " + this.mOp + " (" + this.getRight() + ")";
    }
}

