/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.DataBinder;
import android.databinding.tool.LayoutBinder;
import android.databinding.tool.reflection.InjectedClass;
import android.databinding.tool.reflection.InjectedMethod;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.BRWriter;
import android.databinding.tool.writer.DataBinderWriter;
import android.databinding.tool.writer.DynamicUtilWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.HashMap;
import java.util.Set;

public class CompilerChef {
    private static final String[] VERSION_CODES = new String[]{"BASE", "BASE_1_1", "CUPCAKE", "DONUT", "ECLAIR", "ECLAIRE_0_1", "ECLAIR_MR1", "FROYO", "GINGERBREAD", "GINGERBREAD_MR1", "HONEYCOMB", "HONEYCOMB_MR1", "HONEYCOMB_MR2", "ICE_CREAM_SANDWICH", "ICE_CREAM_SANDWICH_MR1", "JELLY_BEAN", "JELLY_BEAN_MR1", "JELLY_BEAN_MR2", "KITKAT", "KITKAT_WATCH", "LOLLIPOP", "LOLLIPOP_MR1", "M"};
    private JavaFileWriter mFileWriter;
    private ResourceBundle mResourceBundle;
    private DataBinder mDataBinder;

    private CompilerChef() {
    }

    public static CompilerChef createChef(ResourceBundle bundle, JavaFileWriter fileWriter) {
        CompilerChef chef = new CompilerChef();
        chef.mResourceBundle = bundle;
        chef.mFileWriter = fileWriter;
        chef.mResourceBundle.validateMultiResLayouts();
        chef.pushClassesToAnalyzer();
        chef.pushDynamicUtilToAnalyzer();
        return chef;
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public void ensureDataBinder() {
        if (this.mDataBinder == null) {
            this.mDataBinder = new DataBinder(this.mResourceBundle);
            this.mDataBinder.setFileWriter(this.mFileWriter);
        }
    }

    public boolean hasAnythingToGenerate() {
        L.d("checking if we have anything to generate. bundle size: %s", this.mResourceBundle == null ? -1 : this.mResourceBundle.getLayoutBundles().size());
        return this.mResourceBundle != null && this.mResourceBundle.getLayoutBundles().size() > 0;
    }

    private void pushClassesToAnalyzer() {
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        for (String layoutName : this.mResourceBundle.getLayoutBundles().keySet()) {
            ResourceBundle.LayoutFileBundle layoutFileBundle = this.mResourceBundle.getLayoutBundles().get(layoutName).get(0);
            HashMap<String, String> imports = new HashMap<String, String>();
            for (ResourceBundle.NameTypeLocation nameTypeLocation : layoutFileBundle.getImports()) {
                imports.put(nameTypeLocation.name, nameTypeLocation.type);
            }
            HashMap<String, String> variables2 = new HashMap<String, String>();
            for (ResourceBundle.VariableDeclaration variableDeclaration : layoutFileBundle.getVariables()) {
                String variableName = variableDeclaration.name;
                String type = variableDeclaration.type;
                if (imports.containsKey(type)) {
                    type = (String)imports.get(type);
                }
                variables2.put(variableName, type);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (ResourceBundle.BindingTargetBundle bindingTargetBundle : layoutFileBundle.getBindingTargetBundles()) {
                if (bindingTargetBundle.getId() == null) continue;
                hashMap.put(bindingTargetBundle.getId(), bindingTargetBundle.getInterfaceType());
            }
            String string = layoutFileBundle.getBindingClassPackage() + "." + layoutFileBundle.getBindingClassName();
            analyzer.injectViewDataBinding(string, variables2, hashMap);
        }
    }

    public static InjectedClass pushDynamicUtilToAnalyzer() {
        InjectedClass injectedClass = new InjectedClass("android.databinding.DynamicUtil", "java.lang.Object");
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "getColorFromResource", "int", "android.view.View", "int"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "getColorStateListFromResource", "android.content.res.ColorStateList", "android.view.View", "int"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "getDrawableFromResource", "android.graphics.drawable.Drawable", "android.view.View", "int"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "parse", "boolean", "java.lang.String", "boolean"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "parse", "short", "java.lang.String", "short"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "parse", "int", "java.lang.String", "int"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "parse", "long", "java.lang.String", "long"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "parse", "float", "java.lang.String", "float"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "parse", "double", "java.lang.String", "double"));
        injectedClass.addMethod(new InjectedMethod(injectedClass, true, "parse", "char", "java.lang.String", "char"));
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        analyzer.injectClass(injectedClass);
        return injectedClass;
    }

    public void writeDataBinderMapper(int minSdk, BRWriter brWriter) {
        this.ensureDataBinder();
        String pkg = "android.databinding";
        DataBinderWriter dbr = new DataBinderWriter("android.databinding", this.mResourceBundle.getAppPackage(), "DataBinderMapper", this.mDataBinder.getLayoutBinders(), minSdk);
        this.mFileWriter.writeToFile("android.databinding." + dbr.getClassName(), dbr.write(brWriter));
    }

    public void writeDynamicUtil() {
        DynamicUtilWriter dynamicUtil = new DynamicUtilWriter();
        ModelClass versionCodes = ModelAnalyzer.getInstance().findClass("android.os.Build.VERSION_CODES", null);
        Preconditions.checkNotNull(versionCodes, "Could not find compile SDK", new Object[0]);
        int compileVersion = 1;
        for (int i = VERSION_CODES.length - 1; i >= 0; --i) {
            if (versionCodes.findGetterOrField(VERSION_CODES[i], true) == null) continue;
            compileVersion = i + 1;
            break;
        }
        this.mFileWriter.writeToFile("android.databinding.DynamicUtil", dynamicUtil.write(compileVersion).generate());
    }

    public void addBRVariables(BindableHolder bindables) {
        this.ensureDataBinder();
        for (LayoutBinder layoutBinder : this.mDataBinder.mLayoutBinders) {
            for (String variableName : layoutBinder.getUserDefinedVariables().keySet()) {
                bindables.addVariable(variableName, layoutBinder.getClassName());
            }
        }
    }

    public void sealModels() {
        this.ensureDataBinder();
        this.mDataBinder.sealModels();
    }

    public void writeViewBinderInterfaces(boolean isLibrary) {
        this.ensureDataBinder();
        this.mDataBinder.writerBaseClasses(isLibrary);
    }

    public void writeViewBinders(int minSdk) {
        this.ensureDataBinder();
        this.mDataBinder.writeBinders(minSdk);
    }

    public void writeComponent() {
        this.ensureDataBinder();
        this.mDataBinder.writeComponent();
    }

    public Set<String> getWrittenClassNames() {
        this.ensureDataBinder();
        return this.mDataBinder.getWrittenClassNames();
    }

    public static interface BindableHolder {
        public void addVariable(String var1, String var2);
    }
}

