/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dataSource.DataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DasUtil {
    public static final Function<DasObject, String> TO_NAME = o -> o == null ? null : o.getName();
    public static final Function<DasObject, ObjectKind> TO_KIND = DasObject::getKind;
    public static final Function<DasObject, Iterable<DasObject>> ALL_CHILDREN = t -> t.getDbChildren(DasObject.class, ObjectKind.NONE);
    public static final Function<DasObject, DasObject> TO_PARENT = t -> {
        DasObject o = t.getDbParent();
        return DasUtil.getKind(o) == ObjectKind.NONE ? null : o;
    };
    public static final Condition<DasArgument> OUTPUT_ARGUMENT = definition -> definition.getArgumentDirection().isOut();
    public static final Condition<DasArgument> INPUT_ARGUMENT = definition -> {
        DasArgument.Direction type = definition.getArgumentDirection();
        return type.isIn() || type == DasArgument.Direction.SELF;
    };
    public static final Condition<DasArgument> PARAMETER = definition -> !definition.getArgumentDirection().isReturnOrResult();
    public static final Condition<Object> CHECK_CANCELLED = o -> {
        DasUtil.checkCancelled();
        return true;
    };
    public static final String NO_NAME = new String("");
    public static final Set<DasColumn.Attribute> NO_ATTRS = Collections.emptySet();
    public static final Casing CASING_MIXED = Casing.create(Case.MIXED, Case.EXACT);
    public static final Casing CASING_EXACT = Casing.create(Case.EXACT, Case.EXACT);
    public static final CasingProvider NO_CASING_PROVIDER = (kind, context) -> CASING_MIXED;
    private static final Function<DasObject, Iterable<? extends DasObject>> DAS_STRUCTURE = o -> o.getDbChildren(DasObject.class, ObjectKind.NONE);
    private static final JBTreeTraverser<DasObject> DAS_TRAVERSER = new JBTreeTraverser(DAS_STRUCTURE);

    private DasUtil() {
    }

    private static void checkCancelled() {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return;
        }
        ProgressManager.checkCanceled();
    }

    @NotNull
    public static <V> Map<String, V> newCaseAwareMap(boolean sensitive) {
        THashMap tHashMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)(sensitive ? TObjectHashingStrategy.CANONICAL : CaseInsensitiveStringHashingStrategy.INSTANCE));
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "newCaseAwareMap"));
        }
        return tHashMap;
    }

    @NotNull
    public static Set<String> newCaseAwareSet(boolean sensitive) {
        THashSet tHashSet = ContainerUtil.newTroveSet((TObjectHashingStrategy)(sensitive ? TObjectHashingStrategy.CANONICAL : CaseInsensitiveStringHashingStrategy.INSTANCE));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "newCaseAwareSet"));
        }
        return tHashSet;
    }

    @NotNull
    public static JBTreeTraverser<DasObject> dasTraverser() {
        JBTreeTraverser<DasObject> jBTreeTraverser = DAS_TRAVERSER;
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "dasTraverser"));
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static ObjectKind getKind(@Nullable DasObject o) {
        ObjectKind objectKind = o == null ? ObjectKind.NONE : o.getKind();
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public static <C> Condition<C> byKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DasUtil", "byKind"));
        }
        Condition condition = kind == ObjectKind.NONE ? Conditions.alwaysTrue() : object -> {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DasUtil", "lambda$byKind$9"));
            }
            return DasUtil.getKind((DasObject)object) == kind;
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "byKind"));
        }
        return condition;
    }

    @NotNull
    public static <C> Condition<C> byKindNot(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DasUtil", "byKindNot"));
        }
        Condition condition = kind == ObjectKind.NONE ? Conditions.alwaysTrue() : object -> {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DasUtil", "lambda$byKindNot$10"));
            }
            return DasUtil.getKind((DasObject)object) != kind;
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "byKindNot"));
        }
        return condition;
    }

    @NotNull
    public static <C> Condition<C> byName(@Nullable String name) {
        Condition<C> condition = DasUtil.byName(name, NO_CASING_PROVIDER);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "byName"));
        }
        return condition;
    }

    @NotNull
    public static <C> Condition<C> byName(@Nullable String name, @NotNull CasingProvider casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DasUtil", "byName"));
        }
        if (name == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "byName"));
            }
            return condition;
        }
        Condition condition = object -> {
            if (casing == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DasUtil", "lambda$byName$11"));
            }
            return DasUtil.nameEqual((DasObject)object, name, casing);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "byName"));
        }
        return condition;
    }

    @NotNull
    public static <C> Condition<C> byClass(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/util/DasUtil", "byClass"));
        }
        Condition condition = Conditions.instanceOf((Class)clazz);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "byClass"));
        }
        return condition;
    }

    @NotNull
    public static DasModel emptyModel() {
        EmptyModel emptyModel = EmptyModel.INSTANCE;
        if (emptyModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "emptyModel"));
        }
        return emptyModel;
    }

    @Deprecated
    public static DasModel loadingModel() {
        return EmptyModel.LOADING;
    }

    public static boolean nameEqual(@Nullable DasObject obj, @Nullable String name, @NotNull CasingProvider casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DasUtil", "nameEqual"));
        }
        return DasUtil.nameEqual(obj, name, casing.getCasing(obj == null ? ObjectKind.NONE : obj.getKind(), obj));
    }

    public static boolean nameEqual(@Nullable DasObject obj, @Nullable String name, @NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DasUtil", "nameEqual"));
        }
        return obj != null && DasUtil.equal(obj.getName(), name, casing);
    }

    public static boolean isCaseSensitive(@NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DasUtil", "isCaseSensitive"));
        }
        return casing.plain == Case.EXACT;
    }

    public static boolean equal(@Nullable String name1, @Nullable String name2, @NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DasUtil", "equal"));
        }
        return Comparing.equal((String)name1, (String)name2, (boolean)DasUtil.isCaseSensitive(casing));
    }

    @NotNull
    public static <T> MultiRef<T> emptyMultiRef() {
        EmptyMultiRef emptyMultiRef = EmptyMultiRef.INSTANCE;
        if (emptyMultiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "emptyMultiRef"));
        }
        return emptyMultiRef;
    }

    @NotNull
    public static <S, T> MultiRef<? extends T> transform(@NotNull MultiRef<S> ref, @NotNull Function<? super S, T> fun) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/util/DasUtil", "transform"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/database/util/DasUtil", "transform"));
        }
        MappedMultiRef mappedMultiRef = new MappedMultiRef(ref, fun);
        if (mappedMultiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "transform"));
        }
        return mappedMultiRef;
    }

    @NotNull
    public static <T> MultiRef.It<T> emptyMultiRefIterator() {
        MultiRef.It it = EmptyMultiRef.INSTANCE.iterate();
        if (it == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "emptyMultiRefIterator"));
        }
        return it;
    }

    @Nullable
    public static DasObject getParentOfKind(@Nullable DasObject object, @Nullable ObjectKind kind, boolean strict) {
        DasObject o;
        if (kind == null) {
            return null;
        }
        DasObject dasObject = o = strict && object != null ? object.getDbParent() : object;
        while (o != null) {
            if (o.getKind() == kind) {
                return o;
            }
            o = o.getDbParent();
        }
        return null;
    }

    @Nullable
    public static <T> T getParentOfClass(@Nullable DasObject object, @Nullable Class<? extends T> clazz, boolean strict) {
        DasObject o;
        if (clazz == null) {
            return null;
        }
        DasObject dasObject = o = strict && object != null ? object.getDbParent() : object;
        while (o != null) {
            if (clazz.isInstance(o)) {
                return (T)o;
            }
            o = o.getDbParent();
        }
        return null;
    }

    @Nullable
    public static DasNamespace getNamespace(@Nullable DasObject object) {
        return DasUtil.getParentOfClass(object, DasNamespace.class, true);
    }

    @NotNull
    public static JBIterable<DasObject> dasParents(@Nullable DasObject object) {
        if (object == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "dasParents"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.generate((Object)object, TO_PARENT);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "dasParents"));
        }
        return jBIterable;
    }

    @Nullable
    public static <C> C findChild(@Nullable DasObject parent, Class<C> clazz, ObjectKind kind, String name) {
        return (C)(parent == null ? null : parent.getDbChildren(clazz, kind).filter(DasUtil.byName(name)).first());
    }

    @Nullable
    public static DasObject getCatalogObject(@Nullable DasObject object) {
        return DasUtil.getParentOfKind(object, ObjectKind.DATABASE, false);
    }

    @Nullable
    public static DasObject getSchemaObject(@Nullable DasObject object) {
        return DasUtil.getParentOfKind(object, ObjectKind.SCHEMA, false);
    }

    @NotNull
    public static String getName(@Nullable DasObject object) {
        String string = object == null ? NO_NAME : object.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getName"));
        }
        return string;
    }

    @NotNull
    public static String getCatalog(@Nullable DasObject object) {
        String string = DasUtil.getName(DasUtil.getCatalogObject(object));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getCatalog"));
        }
        return string;
    }

    @NotNull
    public static String getSchema(@Nullable DasObject object) {
        String string = DasUtil.getName(DasUtil.getSchemaObject(object));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getSchema"));
        }
        return string;
    }

    public static <T extends DasObject> MultiRef<T> asRef(Iterable<T> objects) {
        return DasUtil.asRef(objects, TO_NAME, Function.ID);
    }

    public static <S, T extends DasObject> MultiRef<T> asRef(final Iterable<S> objects, final Function<? super S, String> namer, final Function<S, T> resolver) {
        final JBIterable fi = JBIterable.from(objects);
        return new MultiRef<T>(){

            @Override
            public MultiRef.It<T> iterate() {
                final Iterator it = objects.iterator();
                return new MultiRef.It<T>(){
                    S cur;

                    @Override
                    @Nullable
                    public T resolve() {
                        return (DasObject)resolver.fun(this.cur);
                    }

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public String next() {
                        this.cur = it.next();
                        return (String)namer.fun(this.cur);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Iterable<String> names() {
                return fi.transform(namer);
            }

            @Override
            public Iterable<? extends T> resolveObjects() {
                return fi.transform(resolver).filter(Condition.NOT_NULL);
            }

            @Override
            public int size() {
                return fi.size();
            }
        };
    }

    @Nullable
    public static DasObject resolveFinalTarget(@Nullable DasSynonym synonym) {
        int k = 9;
        DasObject o = synonym;
        while (o instanceof DasSynonym && k-- > 0) {
            o = o.resolveTarget();
        }
        return k == 0 ? null : o;
    }

    public static boolean isPrimary(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.PRIMARY_KEY);
    }

    public static boolean isForeign(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.FOREIGN_KEY);
    }

    public static boolean isAutoVal(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.AUTO_GENERATED);
    }

    public static boolean isIndexColumn(@Nullable DasColumn column) {
        return DasUtil.hasAttribute(column, DasColumn.Attribute.INDEX);
    }

    private static boolean hasAttribute(@Nullable DasColumn column, @NotNull DasColumn.Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/database/util/DasUtil", "hasAttribute"));
        }
        DasTable table = column == null ? null : column.getTable();
        return table != null && table.getColumnAttrs(column).contains((Object)attribute);
    }

    public static boolean isAncestor(@Nullable DasObject ancestor, @Nullable DasObject element, boolean strict) {
        if (ancestor == null || element == null) {
            return false;
        }
        if (ancestor == element) {
            return !strict;
        }
        for (DasObject object : DasUtil.dasParents(element)) {
            if (object != ancestor) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JBIterable<? extends DasNamespace> getSchemas(@NotNull DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getSchemas"));
        }
        JBIterable<? extends DasNamespace> jBIterable = DasUtil.getSchemas(dataSource.getModel());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getSchemas"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<? extends DasNamespace> getSchemas(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getSchemas"));
        }
        JBIterable<? extends DasNamespace> jBIterable = DasUtil.getSchemas(dataSource.getModel());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getSchemas"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<? extends DasNamespace> getSchemas(@NotNull DasModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/DasUtil", "getSchemas"));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().expand(DasUtil.byKindNot(ObjectKind.SCHEMA))).filter(DasUtil.byKind(ObjectKind.SCHEMA))).filter(DasNamespace.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getSchemas"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<? extends DasNamespace> getNamespaces(@NotNull DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getNamespaces"));
        }
        JBIterable jBIterable = ((JBTreeTraverser)dataSource.getModel().traverser().expand(DasUtil.byKindNot(ObjectKind.SCHEMA))).filter(DasNamespace.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getNamespaces"));
        }
        return jBIterable;
    }

    public static JBIterable<? extends DasNamespace> getNamespaces(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getNamespaces"));
        }
        return ((JBTreeTraverser)dataSource.getModel().traverser().expand(DasUtil.byKindNot(ObjectKind.SCHEMA))).filter(DasNamespace.class);
    }

    public static JBIterable<? extends DasSchemaChild> getPackages(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getPackages"));
        }
        return DasUtil.getSchemaElements(dataSource, DasSchemaChild.class).filter(DasUtil.byKind(ObjectKind.PACKAGE));
    }

    public static JBIterable<? extends DasTable> getTables(@NotNull DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getTables"));
        }
        return DasUtil.getSchemaElements(dataSource, DasTable.class);
    }

    public static JBIterable<? extends DasTable> getTables(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getTables"));
        }
        return DasUtil.getSchemaElements(dataSource, DasTable.class);
    }

    @Deprecated
    public static JBIterable<? extends DasTable> getTables(@NotNull DatabaseSystem ds) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/util/DasUtil", "getTables"));
        }
        if (ds instanceof DataSource) {
            return DasUtil.getTables((DataSource)ds);
        }
        if (ds instanceof DbDataSource) {
            return DasUtil.getTables((DbDataSource)ds);
        }
        return JBIterable.empty();
    }

    public static <T> JBIterable<? extends T> getSchemaElements(@NotNull DataSource dataSource, Class<T> clazz) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getSchemaElements"));
        }
        return ((JBTreeTraverser)dataSource.getModel().traverser().expandAndSkip(DasUtil.byClass(DasNamespace.class))).filter(clazz);
    }

    public static <T> JBIterable<? extends T> getSchemaElements(@NotNull DbDataSource dataSource, Class<T> clazz) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DasUtil", "getSchemaElements"));
        }
        return ((JBTreeTraverser)dataSource.getModel().traverser().expandAndSkip(DasUtil.byClass(DasNamespace.class))).filter(clazz);
    }

    public static JBIterable<? extends DasColumn> getColumns(@NotNull DasObject table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DasUtil", "getColumns"));
        }
        return table.getDbChildren(DasColumn.class, ObjectKind.COLUMN);
    }

    public static JBIterable<? extends DasForeignKey> getForeignKeys(@NotNull DasTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DasUtil", "getForeignKeys"));
        }
        return table.getDbChildren(DasForeignKey.class, ObjectKind.FOREIGN_KEY);
    }

    public static JBIterable<? extends DasIndex> getIndices(@NotNull DasTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DasUtil", "getIndices"));
        }
        return table.getDbChildren(DasIndex.class, ObjectKind.INDEX);
    }

    public static JBIterable<? extends DasTableKey> getTableKeys(@NotNull DasTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DasUtil", "getTableKeys"));
        }
        return table.getDbChildren(DasTableKey.class, ObjectKind.KEY);
    }

    @Nullable
    public static DasTableKey getPrimaryKey(@NotNull DasTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DasUtil", "getPrimaryKey"));
        }
        for (DasTableKey key : DasUtil.getTableKeys(table)) {
            if (!key.isPrimary()) continue;
            return key;
        }
        return null;
    }

    public static boolean containsName(@NotNull String name, @NotNull MultiRef<?> ref) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DasUtil", "containsName"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/util/DasUtil", "containsName"));
        }
        return ContainerUtil.find(ref.names(), (Object)name) != null;
    }

    @NotNull
    public static JBIterable<? extends DasArgument> getParameters(@NotNull DasRoutine routine) {
        if (routine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/util/DasUtil", "getParameters"));
        }
        JBIterable jBIterable = JBIterable.from(routine.getArguments()).filter(PARAMETER);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getParameters"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasObject> getDbChildren(@NotNull DasObject object, @Nullable DasModel model) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        JBIterable<DasObject> jBIterable = DasUtil.getDbChildren(object, model == null ? DasUtil.dasTraverser() : model.traverser(), DasObject.class, ObjectKind.NONE);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public static <C> JBIterable<C> getDbChildren(@NotNull DasObject object, @NotNull DasModel model, @NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        JBIterable<C> jBIterable = DasUtil.getDbChildren(object, model == DasUtil.emptyModel() ? DasUtil.dasTraverser() : model.traverser(), clazz, kind);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public static <C> JBIterable<C> getDbChildren(@NotNull DasObject object, @NotNull JBTreeTraverser<DasObject> traverser, @NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        if (traverser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)object)).expandAndSkip(Conditions.is((Object)object))).filter(DasUtil.byKind(kind))).filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil", "getDbChildren"));
        }
        return jBIterable;
    }

    private static class EmptyModel
    extends JBTreeTraverser<DasObject>
    implements DasModel {
        private static final EmptyModel INSTANCE = new EmptyModel("empty");
        private static final EmptyModel LOADING = new EmptyModel("loading");
        final String debugName;

        private EmptyModel(String debugName) {
            super(Functions.constant((Object)JBIterable.empty()));
            this.debugName = debugName;
        }

        @Override
        @NotNull
        public JBIterable<? extends DasObject> getModelRoots() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil$EmptyModel", "getModelRoots"));
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public DasNamespace getCurrentRootNamespace() {
            return null;
        }

        @Override
        @NotNull
        public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/DasUtil$EmptyModel", "getCasing"));
            }
            Casing casing = CASING_MIXED;
            if (casing == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil$EmptyModel", "getCasing"));
            }
            return casing;
        }

        @Override
        @NotNull
        public JBTreeTraverser<DasObject> traverser() {
            EmptyModel emptyModel = this;
            if (emptyModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil$EmptyModel", "traverser"));
            }
            return emptyModel;
        }

        @NotNull
        protected JBTreeTraverser<DasObject> newInstance(FilteredTraverserBase.Meta<DasObject> meta) {
            EmptyModel emptyModel = this;
            if (emptyModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil$EmptyModel", "newInstance"));
            }
            return emptyModel;
        }

        @Override
        @NotNull
        public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DasUtil$EmptyModel", "getExportedKeys"));
            }
            return jBIterable;
        }

        public String toString() {
            return this.debugName;
        }
    }

    private static class MappedMultiRef<S, T>
    implements MultiRef<T> {
        final MultiRef<? extends S> original;
        final Function<? super S, T> fun;

        private MappedMultiRef(MultiRef<? extends S> original, Function<? super S, T> fun) {
            this.original = original;
            this.fun = fun;
        }

        @Override
        public MultiRef.It<T> iterate() {
            final MultiRef.It<? extends S> it = this.original.iterate();
            return new MultiRef.It<T>(){

                @Override
                @Nullable
                public T resolve() {
                    return fun.fun(it.resolve());
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    return (String)it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public Iterable<String> names() {
            return this.original.names();
        }

        @Override
        public Iterable<T> resolveObjects() {
            return JBIterable.from(this.original.resolveObjects()).transform(this.fun).filter(Condition.NOT_NULL);
        }

        @Override
        public int size() {
            return this.original.size();
        }
    }

    private static class EmptyMultiRef
    implements MultiRef,
    MultiRef.It {
        static final EmptyMultiRef INSTANCE = new EmptyMultiRef();

        private EmptyMultiRef() {
        }

        public MultiRef.It iterate() {
            return this;
        }

        @Override
        public Iterable<String> names() {
            return Collections.emptyList();
        }

        public Iterable resolveObjects() {
            return JBIterable.empty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Nullable
        public Object resolve() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

