/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSource
extends SimpleModificationTracker
implements DatabaseSystem {
    public abstract boolean isGlobal();

    @Override
    public abstract String getUniqueId();

    public abstract boolean isReadOnly();

    @Override
    @NotNull
    public abstract String getName();

    @Override
    @Nullable
    public abstract String getComment();

    @Override
    public String getDatabaseProductName() {
        return this.getInfo().myProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.getInfo().myProductVersion;
    }

    public String getJDBCVersion() {
        return this.getInfo().myJDBCVersion;
    }

    public String getDriverName() {
        return this.getInfo().myDriverName;
    }

    public String getDriverVersion() {
        return this.getInfo().myDriverVersion;
    }

    public Casing getCaseModes() {
        return this.getInfo().myCasing;
    }

    @Override
    @NotNull
    public abstract DasModel getModel();

    protected abstract Info getInfo();

    public abstract String getSourceName();

    @Nullable
    public String quoteIdentifierIfNeeded(@Nullable String identifier) {
        if (this.getInfo().myIdentifierQuoteString == null || identifier == null) {
            return identifier;
        }
        if (identifier.startsWith(this.getInfo().myIdentifierQuoteString)) {
            return identifier;
        }
        int len = identifier.length();
        for (int i = 0; i < len; ++i) {
            char c = identifier.charAt(i);
            if ((i != 0 || StringUtil.isJavaIdentifierStart((char)c)) && (i <= 0 || StringUtil.isJavaIdentifierPart((char)c)) || this.getInfo().myExtraNameCharacters != null && this.getInfo().myExtraNameCharacters.indexOf(c) != -1) continue;
            return this.quoteIdentifier(identifier);
        }
        return identifier;
    }

    @Nullable
    public String quoteIdentifier(@Nullable String identifier) {
        if (this.getInfo().myIdentifierQuoteString == null || identifier == null) {
            return identifier;
        }
        return this.getInfo().myIdentifierQuoteString + identifier + this.getInfo().myIdentifierQuoteString;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "toString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    static class Info {
        String myProductName;
        String myProductVersion;
        String myJDBCVersion;
        @Nullable
        String myIdentifierQuoteString;
        @Nullable
        String myExtraNameCharacters;
        String myDriverName;
        String myDriverVersion;
        Casing myCasing = DasUtil.CASING_MIXED;

        Info() {
        }

        void copyFrom(@NotNull Info info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dataSource/DataSource$Info", "copyFrom"));
            }
            this.myProductName = info.myProductName;
            this.myProductVersion = info.myProductVersion;
            this.myJDBCVersion = info.myJDBCVersion;
            this.myIdentifierQuoteString = info.myIdentifierQuoteString;
            this.myExtraNameCharacters = info.myExtraNameCharacters;
            this.myDriverName = info.myDriverName;
            this.myDriverVersion = info.myDriverVersion;
            this.myCasing = info.myCasing;
        }
    }
}

