/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.search;

import com.intellij.lang.aspectj.augment.LightInterTypeMethod;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.psi.util.PseudoImplLightClass;
import com.intellij.lang.aspectj.search.AspectJSourceFilterScope;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AjDefinitionSearcher
extends QueryExecutorBase<PsiElement, PsiElement> {
    public AjDefinitionSearcher() {
        super(true);
    }

    public void processQuery(@NotNull PsiElement element, @NotNull Processor<PsiElement> consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/search/AjDefinitionSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/search/AjDefinitionSearcher", "processQuery"));
        }
        if (element instanceof LightInterTypeMethod) {
            AjDefinitionSearcher.processInterTypeMethod((LightInterTypeMethod)element, consumer);
        } else if (element instanceof PsiMethod) {
            AjDefinitionSearcher.processMethod((PsiMethod)element, consumer);
        }
    }

    private static void processMethod(PsiMethod method, Processor<PsiElement> consumer) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !aClass.isInterface()) {
            return;
        }
        Project project = method.getProject();
        AspectJSourceFilterScope scope = new AspectJSourceFilterScope(GlobalSearchScope.projectScope((Project)project), project);
        Collection methods = JavaMethodNameIndex.getInstance().get(method.getName(), project, (GlobalSearchScope)scope);
        if (methods == null || methods.isEmpty()) {
            return;
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        for (PsiMethod candidate : methods) {
            LightInterTypeMethod wrapper;
            PsiClass candidateInterface;
            PsiClass candidateClass;
            if (!(candidate instanceof PsiInterTypeMethod) || !((candidateClass = candidate.getContainingClass()) instanceof PseudoImplLightClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)(candidateInterface = ((PseudoImplLightClass)candidateClass).getDelegate()), (PsiClass)aClass, (boolean)true) || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)signature, (MethodSignature)candidate.getHierarchicalMethodSignature()) || consumer.process((Object)(wrapper = new LightInterTypeMethod((PsiInterTypeMethod)candidate, candidateInterface)))) continue;
            return;
        }
    }

    private static void processInterTypeMethod(LightInterTypeMethod method, Processor<PsiElement> consumer) {
        PsiClass aClass;
        if (method.getModifierList().hasModifierProperty("abstract") && (aClass = method.getContainingClass()) != null && aClass.isInterface()) {
            consumer.process((Object)method);
        }
    }
}

