/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.pushIn;

import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.AjRecursiveWalkingElementVisitor;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.PsiInterTypeTypeAnnotation;
import com.intellij.lang.aspectj.refactoring.pushIn.ConflictUsageInfo;
import com.intellij.lang.aspectj.refactoring.pushIn.InterTypeUsageInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;

public class PushInVisitor
extends AjRecursiveWalkingElementVisitor {
    private final Collection<UsageInfo> myUsages = ContainerUtil.newHashSet();

    public Collection<UsageInfo> getUsages() {
        return this.myUsages;
    }

    @Override
    public void visitElement(PsiElement element) {
        super.visitElement(element);
        if (element instanceof PsiInterTypeDeclaration) {
            PsiInterTypeDeclaration declaration = (PsiInterTypeDeclaration)element;
            PsiClass target = declaration.getInterTypeReference().getReferencedClass();
            if (target == null) {
                String message = AspectJBundle.message("action.push.in.bad.target", declaration.getInterTypeReference().getText());
                this.myUsages.add(new ConflictUsageInfo(declaration, message));
            } else if (target.isInterface()) {
                String message = AspectJBundle.message("action.push.in.interface", target.getQualifiedName());
                this.myUsages.add(new ConflictUsageInfo(declaration, message));
            } else if (target instanceof PsiCompiledElement) {
                String message = AspectJBundle.message("action.push.in.compiled.target", target.getQualifiedName());
                this.myUsages.add(new ConflictUsageInfo(declaration, message));
            } else {
                TextRange range = PushInVisitor.getRange(declaration);
                this.myUsages.add(new InterTypeUsageInfo(declaration, declaration.getAspect(), target, range));
            }
        }
    }

    private static TextRange getRange(PsiInterTypeDeclaration declaration) {
        PsiElement nameIdentifier;
        int startOffset = declaration.getInterTypeReference().getStartOffsetInParent();
        int endOffset = -1;
        if (declaration instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)declaration).getNameIdentifier()) != null) {
            endOffset = nameIdentifier.getStartOffsetInParent() + nameIdentifier.getTextLength();
        }
        if (endOffset < startOffset) {
            endOffset = declaration.getTextLength();
        }
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public void visitInterTypeTypeAnnotation(PsiInterTypeTypeAnnotation annotation) {
        PsiClass target = annotation.getSingleType();
        if (target == null) {
            PsiPointcutExpression expression = annotation.getPointcutExpression();
            String message = AspectJBundle.message("action.push.in.type.pattern", expression != null ? expression.getText() : "");
            this.myUsages.add(new ConflictUsageInfo(annotation, message));
        } else if (target instanceof PsiCompiledElement) {
            String message = AspectJBundle.message("action.push.in.compiled.target", target.getQualifiedName());
            this.myUsages.add(new ConflictUsageInfo(annotation, message));
        } else {
            TextRange range = PushInVisitor.getRange(annotation);
            this.myUsages.add(new InterTypeUsageInfo(annotation, annotation.getAspect(), target, range));
        }
    }

    private static TextRange getRange(PsiInterTypeTypeAnnotation typeAnnotation) {
        PsiPointcutExpression expression = typeAnnotation.getPointcutExpression();
        int startOffset = expression != null ? expression.getStartOffsetInParent() : 0;
        int endOffset = typeAnnotation.getAnnotation().getStartOffsetInParent() + typeAnnotation.getAnnotation().getTextLength();
        return new TextRange(startOffset, endOffset);
    }
}

