/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.pushIn;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.refactoring.pushIn.ConflictUsageInfo;
import com.intellij.lang.aspectj.refactoring.pushIn.InterTypeUsageInfo;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInConflictsUtil;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInHandler;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInProcessingTask;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInVisitor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PushInProcessor
extends BaseRefactoringProcessor {
    private final List<PsiElement> myElements;
    private final boolean myDeleteAspects;

    public PushInProcessor(Project project, List<PsiElement> elements, boolean deleteAspects) {
        super(project, EmptyRunnable.INSTANCE);
        this.myElements = elements;
        this.myDeleteAspects = deleteAspects;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        PushInVisitor visitor = new PushInVisitor();
        HashSet visited = ContainerUtil.newHashSet();
        for (PsiElement element : this.myElements) {
            PushInProcessor.collectUsages(element, visitor, visited);
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.toUsageInfoArray(visitor.getUsages());
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private static void collectUsages(PsiElement element, PushInVisitor visitor, Set<PsiDirectory> visited) {
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            if (!visited.add(directory)) {
                return;
            }
            Project project = directory.getProject();
            if (ProjectRootsUtil.isProjectHome((PsiDirectory)directory)) {
                VirtualFile[] roots = ProjectRootManager.getInstance((Project)project).getContentSourceRoots();
                PushInProcessor.collectUsages(visitor, visited, directory, roots);
                return;
            }
            if (ProjectRootsUtil.isModuleContentRoot((PsiDirectory)directory)) {
                Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(directory.getVirtualFile());
                VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                PushInProcessor.collectUsages(visitor, visited, directory, roots);
                return;
            }
            if (!ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && !ProjectRootsUtil.isInSource((PsiDirectory)directory)) {
                return;
            }
        }
        element.accept((PsiElementVisitor)visitor);
    }

    private static void collectUsages(PushInVisitor visitor, Set<PsiDirectory> visited, PsiDirectory directory, VirtualFile[] roots) {
        PsiManager psiManager = directory.getManager();
        for (VirtualFile root : roots) {
            PsiDirectory rootDirectory = psiManager.findDirectory(root);
            assert (rootDirectory != null) : root;
            if (rootDirectory.equals(directory)) {
                rootDirectory.accept((PsiElementVisitor)visitor);
                continue;
            }
            PushInProcessor.collectUsages((PsiElement)rootDirectory, visitor, visited);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor", "preprocessUsages"));
        }
        if (!super.preprocessUsages(refUsages)) {
            return false;
        }
        ArrayList filtered = ContainerUtil.newArrayListWithCapacity((int)((UsageInfo[])refUsages.get()).length);
        MultiMap conflicts = new MultiMap();
        for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
            if (usage instanceof InterTypeUsageInfo) {
                filtered.add((InterTypeUsageInfo)usage);
                continue;
            }
            if (usage instanceof ConflictUsageInfo) {
                conflicts.putValue((Object)usage.getElement(), (Object)((ConflictUsageInfo)usage).getMessage());
                continue;
            }
            conflicts.putValue((Object)usage.getElement(), (Object)("Unknown usage of element " + usage.getElement()));
        }
        PushInConflictsUtil.checkNameConflicts(filtered, (MultiMap<PsiElement, String>)conflicts);
        PushInConflictsUtil.checkReferenceConflicts(filtered, (MultiMap<PsiElement, String>)conflicts);
        if (filtered.isEmpty() && conflicts.isEmpty()) {
            String message = AspectJBundle.message("action.push.in.nothing.found", new Object[0]);
            CommonRefactoringUtil.showErrorMessage((String)PushInHandler.getRefactoringName(), (String)message, (String)"Using_the_Push_ITDs_In_refactoring", (Project)this.myProject);
            return false;
        }
        if (conflicts.isEmpty()) {
            return true;
        }
        UsageInfo[] usages = UsageViewUtil.toUsageInfoArray((Collection)filtered);
        refUsages.set((Object)usages);
        return this.showConflicts(conflicts, (UsageInfo[])(usages.length > 0 ? usages : null));
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor", "createUsageViewDescriptor"));
        }
        MyUsageViewDescriptor myUsageViewDescriptor = new MyUsageViewDescriptor(PsiUtilCore.toPsiElementArray(this.myElements), usages);
        if (myUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor", "createUsageViewDescriptor"));
        }
        return myUsageViewDescriptor;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor", "getElementsToWrite"));
        }
        HashSet elementsToWrite = ContainerUtil.newHashSet();
        for (UsageInfo usage : ((MyUsageViewDescriptor)descriptor).getUsages()) {
            if (!(usage instanceof InterTypeUsageInfo)) continue;
            elementsToWrite.add(((InterTypeUsageInfo)usage).getSource());
            elementsToWrite.add(((InterTypeUsageInfo)usage).getTarget());
        }
        HashSet hashSet = elementsToWrite;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor", "getElementsToWrite"));
        }
        return hashSet;
    }

    protected String getCommandName() {
        return AspectJBundle.message("action.push.in.title", new Object[0]);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor", "performRefactoring"));
        }
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(this.myProject, PushInHandler.getRefactoringName(), false);
        progressTask.setMinIterationTime(200L);
        progressTask.setTask((SequentialTask)new PushInProcessingTask(usages, progressTask, this.myDeleteAspects));
        ProgressManager.getInstance().run((Task)progressTask);
    }

    private static class MyUsageViewDescriptor
    implements UsageViewDescriptor {
        private final PsiElement[] myElements;
        private final UsageInfo[] myUsages;

        public MyUsageViewDescriptor(PsiElement[] elements, UsageInfo[] usages) {
            this.myUsages = usages;
            this.myElements = elements;
        }

        @NotNull
        public PsiElement[] getElements() {
            if (this.myElements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor$MyUsageViewDescriptor", "getElements"));
            }
            return this.myElements;
        }

        @NotNull
        public UsageInfo[] getUsages() {
            if (this.myUsages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/pushIn/PushInProcessor$MyUsageViewDescriptor", "getUsages"));
            }
            return this.myUsages;
        }

        public String getProcessedElementsHeader() {
            return AspectJBundle.message("action.push.in.preview.sources", this.myElements.length);
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            return AspectJBundle.message("action.push.in.preview.usages", usagesCount, filesCount);
        }

        public String getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }
    }
}

